/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.LogicalConnection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.NetXAConnection;
import org.apache.derby.jdbc.ClientBaseDataSource;
import org.apache.derby.jdbc.ClientDriver;

public class ClientPooledConnection
implements PooledConnection {
    private boolean newPC_ = true;
    private ArrayList listeners_ = new ArrayList();
    private int eventIterators;
    Connection physicalConnection_ = null;
    NetConnection netPhysicalConnection_ = null;
    NetXAConnection netXAPhysicalConnection_ = null;
    private final JDBCStatementCache statementCache;
    LogicalConnection logicalConnection_ = null;
    protected LogWriter logWriter_ = null;
    protected int rmId_ = 0;

    public ClientPooledConnection(ClientBaseDataSource ds, LogWriter logWriter, String user, String password) throws SQLException {
        this.logWriter_ = logWriter;
        this.statementCache = ds.maxStatementsToPool() <= 0 ? null : new JDBCStatementCache(ds.maxStatementsToPool());
        try {
            this.netPhysicalConnection_ = (NetConnection)ClientDriver.getFactory().newNetConnection((NetLogWriter)this.logWriter_, user, password, ds, -1, false, this);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        this.physicalConnection_ = this.netPhysicalConnection_;
    }

    public ClientPooledConnection(ClientBaseDataSource ds, LogWriter logWriter, String user, String password, int rmId) throws SQLException {
        this.logWriter_ = logWriter;
        this.rmId_ = rmId;
        this.statementCache = ds.maxStatementsToPool() <= 0 ? null : null;
        try {
            this.netXAPhysicalConnection_ = this.getNetXAConnection(ds, (NetLogWriter)this.logWriter_, user, password, rmId);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        this.physicalConnection_ = this.netXAPhysicalConnection_.getNetConnection();
    }

    public boolean isStatementPoolingEnabled() {
        return this.statementCache != null;
    }

    protected void finalize() throws Throwable {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "finalize");
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        try {
            if (this.logWriter_ != null) {
                this.logWriter_.traceEntry(this, "close");
            }
            if (this.logicalConnection_ != null) {
                this.logicalConnection_.nullPhysicalConnection();
                this.logicalConnection_ = null;
            }
            if (this.physicalConnection_ == null) {
                return;
            }
            this.physicalConnection_.closeResources();
        }
        finally {
            this.physicalConnection_ = null;
        }
    }

    public synchronized java.sql.Connection getConnection() throws SQLException {
        try {
            if (this.logWriter_ != null) {
                this.logWriter_.traceEntry(this, "getConnection");
            }
            this.createLogicalConnection();
            if (!this.newPC_) {
                this.physicalConnection_.reset(this.logWriter_);
            } else {
                this.physicalConnection_.lightReset();
            }
            this.newPC_ = false;
            if (this.logWriter_ != null) {
                this.logWriter_.traceExit((Object)this, "getConnection", this.logicalConnection_);
            }
            return this.logicalConnection_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void createLogicalConnection() throws SqlException {
        if (this.physicalConnection_ == null) {
            throw new SqlException(this.logWriter_, new ClientMessageId("08003.C.1"));
        }
        try {
            if (this.physicalConnection_.transactionInProgress()) {
                this.physicalConnection_.rollback();
            }
        }
        catch (SQLException sqle) {
            throw new SqlException(sqle);
        }
        if (this.logicalConnection_ != null) {
            this.logicalConnection_.closeWithoutRecyclingToPool();
        }
        this.logicalConnection_ = this.statementCache == null ? ClientDriver.getFactory().newLogicalConnection(this.physicalConnection_, this) : ClientDriver.getFactory().newCachingLogicalConnection(this.physicalConnection_, this, this.statementCache);
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry((Object)this, "addConnectionEventListener", listener);
        }
        if (listener == null) {
            return;
        }
        if (this.eventIterators > 0) {
            this.listeners_ = (ArrayList)this.listeners_.clone();
        }
        this.listeners_.add(listener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry((Object)this, "removeConnectionEventListener", listener);
        }
        if (this.eventIterators > 0) {
            this.listeners_ = (ArrayList)this.listeners_.clone();
        }
        this.listeners_.remove(listener);
    }

    public synchronized void recycleConnection() {
        if (this.physicalConnection_.agent_.loggingEnabled()) {
            this.physicalConnection_.agent_.logWriter_.traceEntry(this, "recycleConnection");
        }
        this.logicalConnection_ = null;
        this.fireConnectionEventListeners(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListeners(SqlException exception) {
        if (exception.getErrorCode() < 40000) {
            return;
        }
        ClientPooledConnection clientPooledConnection = this;
        synchronized (clientPooledConnection) {
            this.fireConnectionEventListeners(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionEventListeners(SqlException exception) {
        if (!this.listeners_.isEmpty()) {
            ConnectionEvent event = exception == null ? new ConnectionEvent(this) : new ConnectionEvent(this, exception.getSQLException());
            ++this.eventIterators;
            try {
                Iterator it = this.listeners_.iterator();
                while (it.hasNext()) {
                    ConnectionEventListener listener = (ConnectionEventListener)it.next();
                    if (exception == null) {
                        listener.connectionClosed(event);
                        continue;
                    }
                    listener.connectionErrorOccurred(event);
                }
            }
            finally {
                --this.eventIterators;
            }
        }
    }

    public synchronized void nullLogicalConnection() {
        this.logicalConnection_ = null;
    }

    public void onStatementClose(PreparedStatement statement) {
    }

    public void onStatementErrorOccurred(PreparedStatement statement, SQLException sqle) {
    }

    protected NetXAConnection getNetXAConnection(ClientBaseDataSource ds, NetLogWriter logWriter, String user, String password, int rmId) throws SqlException {
        return new NetXAConnection(logWriter, user, password, ds, rmId, true, this);
    }
}

