/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.jdbc.ClientBaseDataSource;

public class ClientPooledConnection40
extends ClientPooledConnection {
    private final CopyOnWriteArrayList<StatementEventListener> statementEventListeners = new CopyOnWriteArrayList();

    public ClientPooledConnection40(ClientBaseDataSource ds, LogWriter logWriter, String user, String password) throws SQLException {
        super(ds, logWriter, user, password);
    }

    public ClientPooledConnection40(ClientBaseDataSource ds, LogWriter logWriter, String user, String password, int rmId) throws SQLException {
        super(ds, logWriter, user, password, rmId);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry((Object)this, "addStatementEventListener", listener);
        }
        if (listener != null) {
            this.statementEventListeners.add(listener);
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry((Object)this, "removeConnectionEventListener", listener);
        }
        this.statementEventListeners.remove(listener);
    }

    @Override
    public void onStatementClose(PreparedStatement statement) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement);
            for (StatementEventListener l : this.statementEventListeners) {
                l.statementClosed(event);
            }
        }
    }

    @Override
    public void onStatementErrorOccurred(PreparedStatement statement, SQLException sqle) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement, sqle);
            for (StatementEventListener l : this.statementEventListeners) {
                l.statementErrorOccurred(event);
            }
        }
    }
}

