/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import java.sql.SQLException;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Diagnosable;
import org.apache.derby.client.am.ExceptionFormatter;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class SqlException
extends Exception
implements Diagnosable {
    protected static final int DEFAULT_ERRCODE = 99999;
    protected transient Sqlca sqlca_ = null;
    private transient int messageNumber_;
    protected String message_ = null;
    protected String cachedMessage_ = null;
    private String batchPositionLabel_;
    protected String sqlstate_ = null;
    protected int errorcode_ = 99999;
    protected String causeString_ = null;
    protected SqlException nextException_;
    protected Throwable throwable_;
    public static String CLIENT_MESSAGE_RESOURCE_NAME = "org.apache.derby.loc.clientmessages";
    protected static SQLExceptionFactory exceptionFactory = new SQLExceptionFactory();
    private static MessageUtil msgutil_;
    protected SQLException wrappedException_;

    public static MessageUtil getMessageUtil() {
        if (msgutil_ == null) {
            msgutil_ = new MessageUtil(CLIENT_MESSAGE_RESOURCE_NAME);
        }
        return msgutil_;
    }

    public SqlException(LogWriter logwriter, ClientMessageId msgid, Object[] args, Throwable cause) {
        this(logwriter, cause, SqlException.getMessageUtil().getCompleteMessage(msgid.msgid, args), ExceptionUtil.getSQLStateFromIdentifier(msgid.msgid), ExceptionUtil.getSeverityFromIdentifier(msgid.msgid));
    }

    public SqlException(LogWriter logWriter, ClientMessageId msgid, Object[] args, SqlCode sqlcode, Throwable t) {
        this(logWriter, msgid, args, t);
        this.errorcode_ = sqlcode.getCode();
    }

    public SqlException(LogWriter logWriter, ClientMessageId msgid, Object[] args, SqlCode sqlcode) {
        this(logWriter, msgid, args, sqlcode, (Throwable)null);
    }

    public SqlException(LogWriter logWriter, ClientMessageId msgid, SqlCode sqlcode) {
        this(logWriter, msgid, (Object[])null, sqlcode);
    }

    public SqlException(LogWriter logWriter, ClientMessageId msgid, Object arg1, SqlCode sqlcode) {
        this(logWriter, msgid, new Object[]{arg1}, sqlcode);
    }

    public SqlException(LogWriter logWriter, ClientMessageId msgid, Object arg1, Object arg2, SqlCode sqlcode) {
        this(logWriter, msgid, new Object[]{arg1, arg2}, sqlcode);
    }

    public SqlException(LogWriter logwriter, ClientMessageId msgid, Throwable cause) {
        this(logwriter, msgid, (Object[])null, cause);
    }

    public SqlException(LogWriter logwriter, ClientMessageId msgid, Object[] args) {
        this(logwriter, msgid, args, (Throwable)null);
    }

    public SqlException(LogWriter logwriter, ClientMessageId msgid) {
        this(logwriter, msgid, (Object[])null);
    }

    public SqlException(LogWriter logwriter, ClientMessageId msgid, Object arg1) {
        this(logwriter, msgid, new Object[]{arg1});
    }

    public SqlException(LogWriter logwriter, ClientMessageId msgid, Object arg1, Throwable cause) {
        this(logwriter, msgid, new Object[]{arg1}, cause);
    }

    public SqlException(LogWriter logwriter, ClientMessageId msgid, Object arg1, Object arg2, Throwable cause) {
        this(logwriter, msgid, new Object[]{arg1, arg2}, cause);
    }

    public SqlException(LogWriter logwriter, ClientMessageId msgid, Object arg1, Object arg2) {
        this(logwriter, msgid, new Object[]{arg1, arg2});
    }

    public SqlException(LogWriter logwriter, ClientMessageId msgid, Object arg1, Object arg2, Object arg3) {
        this(logwriter, msgid, new Object[]{arg1, arg2, arg3});
    }

    public SqlException(LogWriter logWriter, Sqlca sqlca) {
        this(sqlca, 0, true);
        this.errorcode_ = sqlca.getSqlCode();
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    private SqlException(Sqlca sqlca, int number, boolean chain) {
        this.sqlca_ = sqlca;
        this.messageNumber_ = number;
        this.sqlstate_ = sqlca.getSqlState(number);
        int nextMsg = number + 1;
        if (chain && sqlca.numberOfMessages() > nextMsg) {
            this.setThrowable(new SqlException(sqlca, nextMsg, true));
        }
    }

    protected SqlException(LogWriter logWriter, String reason, String sqlState, int errorCode) {
        this(logWriter, (Throwable)null, reason, sqlState, errorCode);
    }

    protected SqlException(LogWriter logWriter, Throwable throwable, String reason, String sqlState, int errorCode) {
        this.message_ = reason;
        this.sqlstate_ = sqlState;
        this.errorcode_ = errorCode;
        this.setThrowable(throwable);
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    private void setThrowable(Throwable throwable) {
        if (throwable instanceof SqlException) {
            this.setNextException((SqlException)throwable);
        } else if (throwable instanceof SQLException) {
            this.setNextException((SQLException)throwable);
        }
        if (throwable != null) {
            this.initCause(throwable);
        }
    }

    public SqlException(SQLException wrapme) {
        this.wrappedException_ = wrapme;
    }

    public SQLException getSQLException() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_;
        }
        SQLException sqle = exceptionFactory.getSQLException(this.getMessage(), this.getSQLState(), this.getErrorCode());
        sqle.initCause(this);
        if (this.nextException_ != null) {
            sqle.setNextException(this.nextException_.getSQLException());
        }
        return sqle;
    }

    void setBatchPositionLabel(int index) {
        this.batchPositionLabel_ = SqlException.getMessageUtil().getTextMessage("J107") + index + ": ";
    }

    public Sqlca getSqlca() {
        return this.sqlca_;
    }

    public String getMessage() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_.getMessage();
        }
        if (this.sqlca_ != null) {
            this.cachedMessage_ = this.message_ = this.sqlca_.getJDBCMessage(this.messageNumber_);
        } else if (this.cachedMessage_ != null) {
            this.message_ = this.cachedMessage_;
        }
        if (this.batchPositionLabel_ != null) {
            this.message_ = this.batchPositionLabel_ + this.message_;
        }
        if (this.causeString_ != null) {
            this.message_ = this.message_ + this.causeString_;
        }
        return this.message_;
    }

    public String getSQLState() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_.getSQLState();
        }
        return this.sqlstate_;
    }

    public int getErrorCode() {
        if (this.wrappedException_ != null) {
            return this.wrappedException_.getErrorCode();
        }
        return this.errorcode_;
    }

    public SqlException getNextException() {
        if (this.wrappedException_ != null) {
            return new SqlException(this.wrappedException_.getNextException());
        }
        return this.nextException_;
    }

    public void setNextException(SqlException nextException) {
        if (this.wrappedException_ != null) {
            this.wrappedException_.setNextException(nextException.getSQLException());
        } else {
            this.nextException_ = nextException;
        }
    }

    public void setNextException(SQLException nextException) {
        if (this.wrappedException_ != null) {
            this.wrappedException_.setNextException(nextException);
        } else {
            SqlException theEnd = this;
            while (theEnd.nextException_ != null) {
                theEnd = theEnd.nextException_;
            }
            theEnd.nextException_ = new SqlException(nextException);
        }
    }

    public void printTrace(PrintWriter printWriter, String header) {
        ExceptionFormatter.printTrace(this, printWriter, header);
    }

    public static SqlException javaException(LogWriter logWriter, Throwable e) {
        return new SqlException(logWriter, new ClientMessageId("XJ001.U"), new Object[]{e.getClass().getName(), e.getMessage()}, e);
    }

    SqlException copyAsUnchainedSQLException(LogWriter logWriter) {
        if (this.sqlca_ != null) {
            return new SqlException(this.sqlca_, this.messageNumber_, false);
        }
        return new SqlException(logWriter, this.getMessage(), this.getSQLState(), this.getErrorCode());
    }

    public static void setExceptionFactory(SQLExceptionFactory factory) {
        exceptionFactory = factory;
    }
}

