/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement30;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement30;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;

public class BrokeredConnection30
extends BrokeredConnection {
    public BrokeredConnection30(BrokeredConnectionControl control) {
        super(control);
    }

    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            resultSetHoldability = this.statementHoldabilityCheck(resultSetHoldability);
            return this.control.wrapStatement(this.getRealConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            resultSetHoldability = this.statementHoldabilityCheck(resultSetHoldability);
            return this.control.wrapStatement(this.getRealConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final Savepoint setSavepoint() throws SQLException {
        try {
            this.control.checkSavepoint();
            return this.getRealConnection().setSavepoint();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final Savepoint setSavepoint(String name) throws SQLException {
        try {
            this.control.checkSavepoint();
            return this.getRealConnection().setSavepoint(name);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.control.checkRollback();
            this.getRealConnection().rollback(savepoint);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.getRealConnection().releaseSavepoint(savepoint);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final void setHoldability(int holdability) throws SQLException {
        try {
            holdability = this.control.checkHoldCursors(holdability, false);
            this.getRealConnection().setHoldability(holdability);
            this.stateHoldability = holdability;
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, autoGeneratedKeys), sql, new Integer(autoGeneratedKeys));
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, columnIndexes), sql, columnIndexes);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, columnNames), sql, columnNames);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    public BrokeredPreparedStatement newBrokeredStatement(BrokeredStatementControl statementControl, String sql, Object generatedKeys) throws SQLException {
        return new BrokeredPreparedStatement30(statementControl, sql, generatedKeys);
    }

    public BrokeredCallableStatement newBrokeredStatement(BrokeredStatementControl statementControl, String sql) throws SQLException {
        return new BrokeredCallableStatement30(statementControl, sql);
    }
}

