/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.sql.Timestamp;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;

public class DataDescriptorGenerator {
    private UUIDFactory uuidf;
    protected final DataDictionary dataDictionary;

    public DataDescriptorGenerator(DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
        this.uuidf = dataDictionary.getUUIDFactory();
    }

    public SchemaDescriptor newSchemaDescriptor(String schemaName, String aid, UUID oid) throws StandardException {
        return new SchemaDescriptor(this.dataDictionary, schemaName, aid, oid, this.dataDictionary.isSystemSchemaName(schemaName));
    }

    public TableDescriptor newTableDescriptor(String tableName, SchemaDescriptor schema, int tableType, char lockGranularity) {
        return new TableDescriptor(this.dataDictionary, tableName, schema, tableType, lockGranularity);
    }

    public TableDescriptor newTableDescriptor(String tableName, SchemaDescriptor schema, int tableType, boolean onCommitDeleteRows, boolean onRollbackDeleteRows) {
        return new TableDescriptor(this.dataDictionary, tableName, schema, tableType, onCommitDeleteRows, onRollbackDeleteRows);
    }

    public ViewDescriptor newViewDescriptor(UUID viewID, String viewName, String viewText, int checkOption, UUID compSchemaId) {
        return new ViewDescriptor(this.dataDictionary, viewID, viewName, viewText, checkOption, compSchemaId);
    }

    public ReferencedKeyConstraintDescriptor newUniqueConstraintDescriptor(TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] referencedColumns, UUID constraintId, UUID indexId, SchemaDescriptor schemaDesc, boolean isEnabled, int referenceCount) {
        return new ReferencedKeyConstraintDescriptor(3, this.dataDictionary, table, constraintName, deferrable, initiallyDeferred, referencedColumns, constraintId, indexId, schemaDesc, isEnabled, referenceCount);
    }

    public ReferencedKeyConstraintDescriptor newPrimaryKeyConstraintDescriptor(TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] referencedColumns, UUID constraintId, UUID indexId, SchemaDescriptor schemaDesc, boolean isEnabled, int referenceCount) {
        return new ReferencedKeyConstraintDescriptor(2, this.dataDictionary, table, constraintName, deferrable, initiallyDeferred, referencedColumns, constraintId, indexId, schemaDesc, isEnabled, referenceCount);
    }

    public ForeignKeyConstraintDescriptor newForeignKeyConstraintDescriptor(TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] fkColumns, UUID constraintId, UUID indexId, SchemaDescriptor schemaDesc, ReferencedKeyConstraintDescriptor referencedConstraintDescriptor, boolean isEnabled, int raDeleteRule, int raUpdateRule) {
        return new ForeignKeyConstraintDescriptor(this.dataDictionary, table, constraintName, deferrable, initiallyDeferred, fkColumns, constraintId, indexId, schemaDesc, referencedConstraintDescriptor, isEnabled, raDeleteRule, raUpdateRule);
    }

    public ForeignKeyConstraintDescriptor newForeignKeyConstraintDescriptor(TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] fkColumns, UUID constraintId, UUID indexId, SchemaDescriptor schemaDesc, UUID referencedConstraintId, boolean isEnabled, int raDeleteRule, int raUpdateRule) {
        return new ForeignKeyConstraintDescriptor(this.dataDictionary, table, constraintName, deferrable, initiallyDeferred, fkColumns, constraintId, indexId, schemaDesc, referencedConstraintId, isEnabled, raDeleteRule, raUpdateRule);
    }

    public CheckConstraintDescriptor newCheckConstraintDescriptor(TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, UUID constraintId, String constraintText, ReferencedColumns referencedColumns, SchemaDescriptor schemaDesc, boolean isEnabled) {
        return new CheckConstraintDescriptor(this.dataDictionary, table, constraintName, deferrable, initiallyDeferred, constraintId, constraintText, referencedColumns, schemaDesc, isEnabled);
    }

    public CheckConstraintDescriptor newCheckConstraintDescriptor(TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, UUID constraintId, String constraintText, int[] refCols, SchemaDescriptor schemaDesc, boolean isEnabled) {
        ReferencedColumnsDescriptorImpl referencedColumns = new ReferencedColumnsDescriptorImpl(refCols);
        return new CheckConstraintDescriptor(this.dataDictionary, table, constraintName, deferrable, initiallyDeferred, constraintId, constraintText, referencedColumns, schemaDesc, isEnabled);
    }

    public ConglomerateDescriptor newConglomerateDescriptor(long conglomerateId, String name, boolean indexable, IndexRowGenerator indexRowGenerator, boolean isConstraint, UUID uuid, UUID tableID, UUID schemaID) {
        return new ConglomerateDescriptor(this.dataDictionary, conglomerateId, name, indexable, indexRowGenerator, isConstraint, uuid, tableID, schemaID);
    }

    public TriggerDescriptor newTriggerDescriptor(SchemaDescriptor sd, UUID uuid, String name, int eventMask, boolean isBefore, boolean isRow, boolean isEnabled, TableDescriptor td, UUID whenSPSId, UUID actionSPSId, Timestamp creationTimestamp, int[] referencedCols, String triggerDefinition, boolean referencingOld, boolean referencingNew, String oldReferencingName, String newReferencingName) throws StandardException {
        return new TriggerDescriptor(this.dataDictionary, sd, uuid, name, eventMask, isBefore, isRow, isEnabled, td, whenSPSId, actionSPSId, creationTimestamp, referencedCols, triggerDefinition, referencingOld, referencingNew, oldReferencingName, newReferencingName);
    }

    protected UUIDFactory getUUIDFactory() {
        return this.uuidf;
    }

    public FileInfoDescriptor newFileInfoDescriptor(UUID id, SchemaDescriptor sd, String SQLName, long generationId) {
        if (id == null) {
            id = this.getUUIDFactory().createUUID();
        }
        return new FileInfoDescriptor(this.dataDictionary, id, sd, SQLName, generationId);
    }

    public TablePermsDescriptor newTablePermsDescriptor(TableDescriptor td, String selectPerm, String deletePerm, String insertPerm, String updatePerm, String referencesPerm, String triggerPerm, String grantor) throws StandardException {
        if ("N".equals(selectPerm) && "N".equals(deletePerm) && "N".equals(insertPerm) && "N".equals(updatePerm) && "N".equals(referencesPerm) && "N".equals(triggerPerm)) {
            return null;
        }
        return new TablePermsDescriptor(this.dataDictionary, null, grantor, td.getUUID(), selectPerm, deletePerm, insertPerm, updatePerm, referencesPerm, triggerPerm);
    }

    public ColPermsDescriptor newColPermsDescriptor(TableDescriptor td, String type, FormatableBitSet columns, String grantor) throws StandardException {
        return new ColPermsDescriptor(this.dataDictionary, null, grantor, td.getUUID(), type, columns);
    }

    public RoutinePermsDescriptor newRoutinePermsDescriptor(AliasDescriptor ad, String grantor) throws StandardException {
        return new RoutinePermsDescriptor(this.dataDictionary, null, grantor, ad.getUUID());
    }

    public RoleGrantDescriptor newRoleGrantDescriptor(UUID uuid, String roleName, String grantee, String grantor, boolean withadminoption, boolean isDef) throws StandardException {
        return new RoleGrantDescriptor(this.dataDictionary, uuid, roleName, grantee, grantor, withadminoption, isDef);
    }
}

