/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.drda.CodePoint;

class AppRequester {
    protected static final int MGR_LEVEL_UNKNOWN = -1;
    protected static final int UNKNOWN_CLIENT = 0;
    protected static final int JCC_CLIENT = 1;
    protected static final int CCC_CLIENT = 2;
    protected static final int DNC_CLIENT = 3;
    private static final int[] MIN_MGR_LEVELS = new int[]{3, 4, 3, 4, 5, 1, 3, 4, 1, 6, 1, 5, 0};
    protected String extnam;
    protected String srvnam;
    protected String srvrlslv;
    protected String srvclsnm;
    protected String spvnam;
    protected String prdid;
    private int[] managerLevels = new int[CodePoint.MGR_CODEPOINTS.length];
    private int clientType;
    protected int versionLevel;
    protected int releaseLevel;
    protected int modifyLevel;

    AppRequester() {
        for (int i = 0; i < CodePoint.MGR_CODEPOINTS.length; ++i) {
            this.managerLevels[i] = -1;
        }
    }

    protected int getManagerLevel(int manager) {
        int mindex = CodePoint.getManagerIndex(manager);
        if (mindex < 0 || mindex > this.managerLevels.length) {
            SanityManager.THROWASSERT("Unknown manager " + manager + " mindex = " + mindex);
        }
        return this.managerLevels[mindex];
    }

    protected void setClientVersion(String productId) {
        this.prdid = productId;
        this.versionLevel = Integer.parseInt(this.prdid.substring(3, 5));
        this.releaseLevel = Integer.parseInt(this.prdid.substring(5, 7));
        this.modifyLevel = Integer.parseInt(this.prdid.substring(7, 8));
        this.clientType = this.srvrlslv == null ? 0 : (this.srvrlslv.indexOf("JCC") != -1 ? 1 : (this.srvrlslv.indexOf("DNC") != -1 ? 3 : 0));
    }

    protected boolean supportsSecMecUSRSSBPWD() {
        return this.clientType == 3 && this.greaterThanOrEqualTo(10, 2, 0);
    }

    protected final boolean supportsQryclsimpForLmtblkprc() {
        return this.clientType == 3;
    }

    protected boolean greaterThanOrEqualTo(int vLevel, int rLevel, int mLevel) {
        if (this.versionLevel > vLevel) {
            return true;
        }
        if (this.versionLevel == vLevel) {
            if (this.releaseLevel > rLevel) {
                return true;
            }
            if (this.releaseLevel == rLevel && this.modifyLevel >= mLevel) {
                return true;
            }
        }
        return false;
    }

    protected void setManagerLevel(int manager, int managerLevel) {
        int i = CodePoint.getManagerIndex(manager);
        if (i < 0 || i > this.managerLevels.length) {
            SanityManager.THROWASSERT("Unknown manager " + manager + " i = " + i);
        }
        this.managerLevels[i] = managerLevel >= MIN_MGR_LEVELS[i] ? managerLevel : 0;
    }

    protected boolean equals(AppRequester a) {
        if (!this.prdid.equals(a.prdid)) {
            return false;
        }
        if (this.notEquals(this.srvrlslv, a.srvrlslv)) {
            return false;
        }
        if (this.notEquals(this.extnam, a.extnam)) {
            return false;
        }
        if (this.notEquals(this.srvnam, a.srvnam)) {
            return false;
        }
        if (this.notEquals(this.srvclsnm, a.srvclsnm)) {
            return false;
        }
        if (this.notEquals(this.spvnam, a.spvnam)) {
            return false;
        }
        for (int i = 0; i < this.managerLevels.length; ++i) {
            if (this.managerLevels[i] == a.managerLevels[i]) continue;
            return false;
        }
        return true;
    }

    private boolean notEquals(Object a, Object b) {
        if (a != null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return true;
        }
        return a != null && !a.equals(b);
    }

    protected int supportedMessageParamLength() {
        switch (this.clientType) {
            case 1: 
            case 3: {
                return 2400;
            }
        }
        return 70;
    }

    protected int getClientType() {
        return this.clientType;
    }

    protected boolean isXARequester() {
        return this.getManagerLevel(7169) >= 7;
    }

    protected boolean supportsSessionDataCaching() {
        return this.clientType == 3 && this.greaterThanOrEqualTo(10, 4, 0);
    }
}

