/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.io.DirFile;
import org.apache.derby.impl.io.DirRandomAccessFile4;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class DirFile4
extends DirFile {
    private RandomAccessFile lockFileOpen;
    private FileChannel lockFileChannel;
    private FileLock dbLock;
    private final boolean rwsOK;

    DirFile4(String path, boolean rwsOK) {
        super(path);
        this.rwsOK = rwsOK;
    }

    DirFile4(String directoryName, String fileName, boolean rwsOK) {
        super(directoryName, fileName);
        this.rwsOK = rwsOK;
    }

    DirFile4(DirFile directoryName, String fileName, boolean rwsOK) {
        super(directoryName, fileName);
        this.rwsOK = rwsOK;
    }

    public StorageFile getParentDir() {
        String parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return new DirFile4(parent, this.rwsOK);
    }

    public OutputStream getOutputStream(boolean append) throws FileNotFoundException {
        return new FileOutputStream(this, append);
    }

    public synchronized int getExclusiveFileLock() {
        int status;
        boolean validExclusiveLock = false;
        try {
            if (this.createNewFile()) {
                validExclusiveLock = true;
            } else if (this.length() > 0L) {
                validExclusiveLock = true;
            }
            if (validExclusiveLock) {
                this.lockFileOpen = new RandomAccessFile(this, "rw");
                this.lockFileChannel = this.lockFileOpen.getChannel();
                this.dbLock = this.lockFileChannel.tryLock();
                if (this.dbLock == null) {
                    this.lockFileChannel.close();
                    this.lockFileChannel = null;
                    this.lockFileOpen.close();
                    this.lockFileOpen = null;
                    status = 2;
                } else {
                    this.lockFileOpen.writeInt(1);
                    this.lockFileChannel.force(true);
                    status = 1;
                }
            } else {
                status = 0;
            }
        }
        catch (IOException ioe) {
            this.releaseExclusiveFileLock();
            status = 0;
            SanityManager.THROWASSERT("Unable to Acquire Exclusive Lock on " + this.getPath(), ioe);
        }
        return status;
    }

    public synchronized void releaseExclusiveFileLock() {
        try {
            if (this.dbLock != null) {
                this.dbLock.release();
                this.dbLock = null;
            }
            if (this.lockFileChannel != null) {
                this.lockFileChannel.close();
                this.lockFileChannel = null;
            }
            if (this.lockFileOpen != null) {
                this.lockFileOpen.close();
                this.lockFileOpen = null;
            }
            super.releaseExclusiveFileLock();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public StorageRandomAccessFile getRandomAccessFile(String mode) throws FileNotFoundException {
        if (!this.rwsOK && ("rws".equals(mode) || "rwd".equals(mode))) {
            mode = "rw";
        }
        return new DirRandomAccessFile4(this, mode);
    }
}

