/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class AggregateNode
extends UnaryOperatorNode {
    private boolean distinct;
    private AggregateDefinition uad;
    private StringBuffer aggregatorClassName;
    private String aggregateDefinitionClassName;
    private Class aggregateDefinitionClass;
    private ClassInspector classInspector;
    private String aggregateName;
    private ResultColumn generatedRC;
    private ColumnReference generatedRef;

    public void init(Object operand, Object uadClass, Object distinct, Object aggregateName) throws StandardException {
        super.init(operand);
        this.aggregateName = (String)aggregateName;
        if (uadClass instanceof String) {
            this.aggregateDefinitionClassName = (String)uadClass;
            this.distinct = (Boolean)distinct;
        } else {
            this.aggregateDefinitionClass = (Class)uadClass;
            this.aggregateDefinitionClassName = this.aggregateDefinitionClass.getName();
            if (!this.aggregateDefinitionClass.equals(MaxMinAggregateDefinition.class)) {
                this.distinct = (Boolean)distinct;
            }
        }
    }

    public ValueNode replaceAggregatesWithColumnReferences(ResultColumnList rcl, int tableNumber) throws StandardException {
        if (this.generatedRef == null) {
            CompilerContext cc = this.getCompilerContext();
            String generatedColName = "SQLCol" + cc.getNextColumnNumber();
            this.generatedRC = (ResultColumn)this.getNodeFactory().getNode(80, generatedColName, this, this.getContextManager());
            this.generatedRC.markGenerated();
            this.generatedRef = (ColumnReference)this.getNodeFactory().getNode(62, this.generatedRC.getName(), null, this.getContextManager());
            this.generatedRef.setSource(this.generatedRC);
            this.generatedRef.setNestingLevel(0);
            this.generatedRef.setSourceLevel(0);
            if (tableNumber != -1) {
                this.generatedRef.setTableNumber(tableNumber);
            }
            rcl.addResultColumn(this.generatedRC);
            this.generatedRef.markGeneratedToReplaceAggregate();
        } else {
            rcl.addResultColumn(this.generatedRC);
        }
        return this.generatedRef;
    }

    AggregateDefinition getAggregateDefinition() {
        return this.uad;
    }

    public ResultColumn getGeneratedRC() {
        SanityManager.ASSERT(this.generatedRC != null, "generatedRC is null.  replaceAggregateWithColumnReference() has not been called on this AggergateNode.  Make sure the node is under a ResultColumn as expected.");
        return this.generatedRC;
    }

    public ColumnReference getGeneratedRef() {
        SanityManager.ASSERT(this.generatedRef != null, "generatedRef is null.  replaceAggregateWithColumnReference() has not been called on this AggergateNode.  Make sure the node is under a ResultColumn as expected.");
        return this.generatedRef;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        DataTypeDescriptor dts = null;
        ClassFactory cf = this.getClassFactory();
        this.classInspector = cf.getClassInspector();
        this.instantiateAggDef();
        aggregateVector.addElement(this);
        if (this.operand != null) {
            this.bindOperand(fromList, subqueryList, aggregateVector);
            HasNodeVisitor visitor = new HasNodeVisitor(this.getClass(), ResultSetNode.class);
            this.operand.accept(visitor);
            if (visitor.hasNode()) {
                throw StandardException.newException("42Y33", this.aggregateName);
            }
            dts = this.operand.getTypeServices();
            if (this.uad instanceof CountAggregateDefinition && !dts.isNullable()) {
                this.setOperator(this.aggregateName);
                this.setMethodName(this.aggregateName);
            }
            if (this.distinct && !this.operand.getTypeId().orderable(cf)) {
                throw StandardException.newException("X0X67.S", dts.getTypeId().getSQLTypeName());
            }
            if (this.operand instanceof UntypedNullConstantNode) {
                throw StandardException.newException("42Y83", this.aggregateName);
            }
        }
        this.aggregatorClassName = new StringBuffer();
        DataTypeDescriptor resultType = this.uad.getAggregator(dts, this.aggregatorClassName);
        if (resultType == null) {
            throw StandardException.newException("42Y22", (Object)this.aggregateName, (Object)this.operand.getTypeId().getSQLTypeName());
        }
        this.checkAggregatorClassName(this.aggregatorClassName.toString());
        this.setType(resultType);
        return this;
    }

    private void checkAggregatorClassName(String className) throws StandardException {
        this.verifyClassExist(className);
        if (!this.classInspector.assignableTo(className, "org.apache.derby.iapi.sql.execute.ExecAggregator")) {
            throw StandardException.newException("42Y32", (Object)className, (Object)this.aggregateName, (Object)this.operand.getTypeId().getSQLTypeName());
        }
    }

    private void instantiateAggDef() throws StandardException {
        Class theClass = this.aggregateDefinitionClass;
        if (theClass == null) {
            String aggClassName = this.aggregateDefinitionClassName;
            this.verifyClassExist(aggClassName);
            try {
                theClass = this.classInspector.getClass(aggClassName);
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        Object instance = null;
        try {
            instance = theClass.newInstance();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
        if (!(instance instanceof AggregateDefinition)) {
            throw StandardException.newException("42Y00", this.aggregateDefinitionClassName);
        }
        if (instance instanceof MaxMinAggregateDefinition) {
            MaxMinAggregateDefinition temp = instance;
            if (this.aggregateName.equals("MAX")) {
                temp.setMaxOrMin(true);
            } else {
                temp.setMaxOrMin(false);
            }
        }
        if (instance instanceof SumAvgAggregateDefinition) {
            SumAvgAggregateDefinition temp1 = instance;
            if (this.aggregateName.equals("SUM")) {
                temp1.setSumOrAvg(true);
            } else {
                temp1.setSumOrAvg(false);
            }
        }
        this.uad = instance;
        this.setOperator(this.aggregateName);
        this.setMethodName(this.aggregateDefinitionClassName);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getAggregatorClassName() {
        return this.aggregatorClassName.toString();
    }

    public String getAggregateName() {
        return this.aggregateName;
    }

    public ResultColumn getNewAggregatorResultColumn(DataDictionary dd) throws StandardException {
        String className = this.aggregatorClassName.toString();
        DataTypeDescriptor compType = DataTypeDescriptor.getSQLDataTypeDescriptor(className);
        ConstantNode nullNode = this.getNullNode(compType);
        nullNode.bindExpression(null, null, null);
        return (ResultColumn)this.getNodeFactory().getNode(80, this.aggregateName, nullNode, this.getContextManager());
    }

    public ResultColumn getNewExpressionResultColumn(DataDictionary dd) throws StandardException {
        ValueNode node;
        ValueNode valueNode = node = this.operand == null ? this.getNewNullResultExpression() : this.operand;
        if (this.operand instanceof ColumnReference) {
            ((ColumnReference)this.operand).remapColumnReferencesToExpressions();
        }
        return (ResultColumn)this.getNodeFactory().getNode(80, "##aggregate expression", node, this.getContextManager());
    }

    public ValueNode getNewNullResultExpression() throws StandardException {
        return this.getNullNode(this.getTypeServices());
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.THROWASSERT("generateExpression() should never be called on an AggregateNode.  replaceAggregatesWithColumnReferences should have been called prior to generateExpression");
    }

    public String toString() {
        return "Aggregate: " + this.aggregateName + "\ndistinct: " + this.distinct + super.toString();
    }

    public boolean isConstant() {
        return false;
    }

    public boolean constantExpression(PredicateList where) {
        return false;
    }
}

