/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;
import org.apache.derby.impl.sql.compile.ValueNode;

public class CreateTriggerNode
extends DDLStatementNode {
    private TableName triggerName;
    private TableName tableName;
    private int triggerEventMask;
    private ResultColumnList triggerCols;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private Vector refClause;
    private ValueNode whenClause;
    private String whenText;
    private int whenOffset;
    private StatementNode actionNode;
    private String actionText;
    private String originalActionText;
    private int actionOffset;
    private SchemaDescriptor triggerSchemaDescriptor;
    private SchemaDescriptor compSchemaDescriptor;
    private int[] referencedColInts;
    private TableDescriptor triggerTableDescriptor;
    private UUID actionCompSchemaId;
    private String oldTableName;
    private String newTableName;
    private boolean oldTableInReferencingClause;
    private boolean newTableInReferencingClause;

    public void init(Object triggerName, Object tableName, Object triggerEventMask, Object triggerCols, Object isBefore, Object isRow, Object isEnabled, Object refClause, Object whenClause, Object whenText, Object whenOffset, Object actionNode, Object actionText, Object actionOffset) throws StandardException {
        this.initAndCheck(triggerName);
        this.triggerName = (TableName)triggerName;
        this.tableName = (TableName)tableName;
        this.triggerEventMask = (Integer)triggerEventMask;
        this.triggerCols = (ResultColumnList)triggerCols;
        this.isBefore = (Boolean)isBefore;
        this.isRow = (Boolean)isRow;
        this.isEnabled = (Boolean)isEnabled;
        this.refClause = (Vector)refClause;
        this.whenClause = (ValueNode)whenClause;
        this.whenText = whenText == null ? null : ((String)whenText).trim();
        this.whenOffset = (Integer)whenOffset;
        this.actionNode = (StatementNode)actionNode;
        this.originalActionText = (String)actionText;
        this.actionText = actionText == null ? null : ((String)actionText).trim();
        this.actionOffset = (Integer)actionOffset;
        this.implicitCreateSchema = true;
    }

    public String statementToString() {
        return "CREATE TRIGGER";
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.triggerCols != null) {
            this.printLabel(depth, "triggerColumns: ");
            this.triggerCols.treePrint(depth + 1);
        }
        if (this.whenClause != null) {
            this.printLabel(depth, "whenClause: ");
            this.whenClause.treePrint(depth + 1);
        }
        if (this.actionNode != null) {
            this.printLabel(depth, "actionNode: ");
            this.actionNode.treePrint(depth + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindStatement() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        this.compSchemaDescriptor = lcc.getDefaultSchema();
        this.triggerSchemaDescriptor = this.getSchemaDescriptor();
        this.triggerTableDescriptor = this.getTableDescriptor(this.tableName);
        if (this.isSessionSchema(this.triggerTableDescriptor.getSchemaDescriptor())) {
            throw StandardException.newException("XCL51.S");
        }
        if (this.isPrivilegeCollectionRequired()) {
            compilerContext.pushCurrentPrivType(5);
            compilerContext.addRequiredTablePriv(this.triggerTableDescriptor);
            compilerContext.popCurrentPrivType();
        }
        boolean needInternalSQL = this.bindReferencesClause(dd);
        lcc.pushTriggerTable(this.triggerTableDescriptor);
        try {
            if (needInternalSQL) {
                compilerContext.setReliability(0);
            }
            if (this.isBefore) {
                compilerContext.setReliability(2048);
            }
            this.actionNode.bindStatement();
        }
        finally {
            lcc.popTriggerTable(this.triggerTableDescriptor);
        }
        compilerContext.createDependency(this.triggerTableDescriptor);
        if (this.triggerCols != null && this.triggerCols.size() != 0) {
            this.referencedColInts = new int[this.triggerCols.size()];
            Hashtable<String, ResultColumn> columnNames = new Hashtable<String, ResultColumn>();
            int tcSize = this.triggerCols.size();
            for (int i = 0; i < tcSize; ++i) {
                ResultColumn rc = (ResultColumn)this.triggerCols.elementAt(i);
                if (columnNames.put(rc.getName(), rc) != null) {
                    throw StandardException.newException("42Y40", (Object)rc.getName(), (Object)this.triggerName);
                }
                ColumnDescriptor cd = this.triggerTableDescriptor.getColumnDescriptor(rc.getName());
                if (cd == null) {
                    throw StandardException.newException("42X14", (Object)rc.getName(), (Object)this.tableName);
                }
                this.referencedColInts[i] = cd.getPosition();
            }
            Arrays.sort(this.referencedColInts);
        }
        if (this.actionNode.referencesSessionSchema()) {
            throw StandardException.newException("XCL51.S");
        }
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.triggerTableDescriptor.getSchemaName()) || this.actionNode.referencesSessionSchema();
    }

    private boolean bindReferencesClause(DataDictionary dd) throws StandardException {
        this.validateReferencesClause(dd);
        if (this.isBefore) {
            this.forbidActionsOnGenCols();
        }
        StringBuffer newText = new StringBuffer();
        boolean regenNode = false;
        int start = 0;
        if (this.isRow) {
            CollectNodesVisitor visitor = new CollectNodesVisitor(ColumnReference.class);
            this.actionNode.accept(visitor);
            Vector refs = visitor.getList();
            QueryTreeNode[] cols = this.sortRefs(refs, true);
            for (int i = 0; i < cols.length; ++i) {
                TableName tableName;
                ColumnReference ref = (ColumnReference)cols[i];
                if (ref.getBeginOffset() == -1 || (tableName = ref.getTableNameNode()) == null || (this.oldTableName == null || !this.oldTableName.equals(tableName.getTableName())) && (this.newTableName == null || !this.newTableName.equals(tableName.getTableName()))) continue;
                int tokBeginOffset = tableName.getBeginOffset();
                int tokEndOffset = tableName.getEndOffset();
                if (tokBeginOffset == -1) continue;
                regenNode = true;
                this.checkInvalidTriggerReference(tableName.getTableName());
                String colName = ref.getColumnName();
                int columnLength = ref.getEndOffset() - ref.getBeginOffset() + 1;
                newText.append(this.originalActionText.substring(start, tokBeginOffset - this.actionOffset));
                newText.append(this.genColumnReferenceSQL(dd, colName, tableName.getTableName(), tableName.getTableName().equals(this.oldTableName)));
                start = tokEndOffset - this.actionOffset + columnLength + 2;
            }
        } else {
            CollectNodesVisitor visitor = new CollectNodesVisitor(FromBaseTable.class);
            this.actionNode.accept(visitor);
            Vector refs = visitor.getList();
            QueryTreeNode[] tabs = this.sortRefs(refs, false);
            for (int i = 0; i < tabs.length; ++i) {
                FromBaseTable fromTable = (FromBaseTable)tabs[i];
                String refTableName = fromTable.getTableName().getTableName();
                String baseTableName = fromTable.getBaseTableName();
                if (baseTableName == null || (this.oldTableName == null || !this.oldTableName.equals(baseTableName)) && (this.newTableName == null || !this.newTableName.equals(baseTableName))) continue;
                int tokBeginOffset = fromTable.getTableNameField().getBeginOffset();
                int tokEndOffset = fromTable.getTableNameField().getEndOffset();
                if (tokBeginOffset == -1) continue;
                this.checkInvalidTriggerReference(baseTableName);
                regenNode = true;
                newText.append(this.originalActionText.substring(start, tokBeginOffset - this.actionOffset));
                newText.append(baseTableName.equals(this.oldTableName) ? "new org.apache.derby.catalog.TriggerOldTransitionRows() " : "new org.apache.derby.catalog.TriggerNewTransitionRows() ");
                if (refTableName.equals(baseTableName)) {
                    newText.append(baseTableName).append(" ");
                }
                start = tokEndOffset - this.actionOffset + 1;
            }
        }
        if (regenNode) {
            if (start < this.originalActionText.length()) {
                newText.append(this.originalActionText.substring(start));
            }
            this.actionText = newText.toString();
            this.actionNode = this.parseStatement(this.actionText, true);
        }
        return regenNode;
    }

    private QueryTreeNode[] sortRefs(Vector refs, boolean isRow) {
        int size = refs.size();
        QueryTreeNode[] sorted = new QueryTreeNode[size];
        int i = 0;
        Enumeration e = refs.elements();
        while (e.hasMoreElements()) {
            if (isRow) {
                sorted[i++] = (ColumnReference)e.nextElement();
                continue;
            }
            sorted[i++] = (FromBaseTable)e.nextElement();
        }
        for (i = 0; i < size - 1; ++i) {
            QueryTreeNode temp = null;
            for (int j = 0; j < size - i - 1; ++j) {
                if ((!isRow || sorted[j].getBeginOffset() <= sorted[j + 1].getBeginOffset()) && (isRow || ((FromBaseTable)sorted[j]).getTableNameField().getBeginOffset() <= ((FromBaseTable)sorted[j + 1]).getTableNameField().getBeginOffset())) continue;
                temp = sorted[j];
                sorted[j] = sorted[j + 1];
                sorted[j + 1] = temp;
            }
            if (temp == null) break;
        }
        return sorted;
    }

    private void forbidActionsOnGenCols() throws StandardException {
        ColumnDescriptorList generatedColumns = this.triggerTableDescriptor.getGeneratedColumns();
        int genColCount = generatedColumns.size();
        if (genColCount == 0) {
            return;
        }
        CollectNodesVisitor visitor = new CollectNodesVisitor(ColumnReference.class);
        this.actionNode.accept(visitor);
        Vector columnRefs = visitor.getList();
        int colRefCount = columnRefs.size();
        for (int crf_idx = 0; crf_idx < colRefCount; ++crf_idx) {
            ColumnReference cr = (ColumnReference)columnRefs.get(crf_idx);
            String colRefName = cr.getColumnName();
            String tabRefName = cr.getTableName();
            for (int gc_idx = 0; gc_idx < genColCount; ++gc_idx) {
                String genColName = generatedColumns.elementAt(gc_idx).getColumnName();
                if (!genColName.equals(colRefName) || !this.equals(this.newTableName, tabRefName)) continue;
                throw StandardException.newException("42XAA", genColName);
            }
        }
    }

    private boolean equals(String left, String right) {
        if (left == null) {
            return right == null;
        }
        return left.equals(right);
    }

    private String genColumnReferenceSQL(DataDictionary dd, String colName, String tabName, boolean isOldTable) throws StandardException {
        ColumnDescriptor colDesc = null;
        colDesc = this.triggerTableDescriptor.getColumnDescriptor(colName);
        if (colDesc == null) {
            throw StandardException.newException("42X04", tabName + "." + colName);
        }
        DataTypeDescriptor dts = colDesc.getType();
        TypeId typeId = dts.getTypeId();
        if (!typeId.isXMLTypeId()) {
            StringBuffer methodCall = new StringBuffer();
            methodCall.append("CAST (org.apache.derby.iapi.db.Factory::getTriggerExecutionContext().");
            methodCall.append(isOldTable ? "getOldRow()" : "getNewRow()");
            methodCall.append(".getObject(");
            methodCall.append(colDesc.getPosition());
            methodCall.append(") AS ");
            methodCall.append(typeId.userType() ? typeId.getSQLTypeName() : dts.getSQLstring());
            methodCall.append(") ");
            return methodCall.toString();
        }
        StringBuffer methodCall = new StringBuffer();
        methodCall.append("XMLPARSE(DOCUMENT CAST( ");
        methodCall.append("org.apache.derby.iapi.db.Factory::getTriggerExecutionContext().");
        methodCall.append(isOldTable ? "getOldRow()" : "getNewRow()");
        methodCall.append(".getString(");
        methodCall.append(colDesc.getPosition());
        methodCall.append(") AS CLOB) PRESERVE WHITESPACE ) ");
        return methodCall.toString();
    }

    private void checkInvalidTriggerReference(String tableName) throws StandardException {
        if (tableName.equals(this.oldTableName) && (this.triggerEventMask & 4) == 4) {
            throw StandardException.newException("42Y92", (Object)"INSERT", (Object)"new");
        }
        if (tableName.equals(this.newTableName) && (this.triggerEventMask & 2) == 2) {
            throw StandardException.newException("42Y92", (Object)"DELETE", (Object)"old");
        }
    }

    private void validateReferencesClause(DataDictionary dd) throws StandardException {
        if (this.refClause == null || this.refClause.size() == 0) {
            return;
        }
        Enumeration e = this.refClause.elements();
        while (e.hasMoreElements()) {
            TriggerReferencingStruct trn = (TriggerReferencingStruct)e.nextElement();
            if (this.isRow && !trn.isRow) {
                throw StandardException.newException("42Y92", (Object)"ROW", (Object)"row");
            }
            if (!this.isRow && trn.isRow) {
                throw StandardException.newException("42Y92", (Object)"STATEMENT", (Object)"table");
            }
            if (trn.isNew) {
                if (this.newTableInReferencingClause) {
                    throw StandardException.newException("42Y93");
                }
                if ((this.triggerEventMask & 2) == 2) {
                    throw StandardException.newException("42Y92", (Object)"DELETE", (Object)"old");
                }
                this.newTableName = trn.identifier;
                this.newTableInReferencingClause = true;
            } else {
                if (this.oldTableInReferencingClause) {
                    throw StandardException.newException("42Y93");
                }
                if ((this.triggerEventMask & 4) == 4) {
                    throw StandardException.newException("42Y92", (Object)"INSERT", (Object)"new");
                }
                this.oldTableName = trn.identifier;
                this.oldTableInReferencingClause = true;
            }
            if (!this.isBefore || trn.isRow) continue;
            throw StandardException.newException("42Y92", (Object)"BEFORE", (Object)"row");
        }
    }

    public ConstantAction makeConstantAction() throws StandardException {
        String oldReferencingName = this.oldTableInReferencingClause ? this.oldTableName : null;
        String newReferencingName = this.newTableInReferencingClause ? this.newTableName : null;
        return this.getGenericConstantActionFactory().getCreateTriggerConstantAction(this.triggerSchemaDescriptor.getSchemaName(), this.getRelativeName(), this.triggerEventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTableDescriptor, null, this.whenText, null, this.actionText, this.actionCompSchemaId == null ? this.compSchemaDescriptor.getUUID() : this.actionCompSchemaId, null, this.referencedColInts, this.originalActionText, this.oldTableInReferencingClause, this.newTableInReferencingClause, oldReferencingName, newReferencingName);
    }

    public String toString() {
        String refString = "null";
        if (this.refClause != null) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = this.refClause.elements();
            while (e.hasMoreElements()) {
                buf.append("\t");
                TriggerReferencingStruct trn = (TriggerReferencingStruct)e.nextElement();
                buf.append(trn.toString());
                buf.append("\n");
            }
            refString = buf.toString();
        }
        return super.toString() + "tableName: " + this.tableName + "\ntriggerEventMask: " + this.triggerEventMask + "\nisBefore: " + this.isBefore + "\nisRow: " + this.isRow + "\nisEnabled: " + this.isEnabled + "\nwhenText: " + this.whenText + "\nrefClause: " + refString + "\nactionText: " + this.actionText + "\n";
    }
}

