/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.RowUtil;

public class ForeignKeyRIChecker
extends GenericRIChecker {
    ForeignKeyRIChecker(TransactionController tc, FKInfo fkinfo) throws StandardException {
        super(tc, fkinfo);
        if (this.fkInfo.type != 1) {
            SanityManager.THROWASSERT("invalid type " + this.fkInfo.type + " for a ForeignKeyRIChecker");
        }
    }

    void doCheck(ExecRow row, boolean restrictCheckOnly) throws StandardException {
        if (restrictCheckOnly) {
            return;
        }
        if (this.isAnyFieldNull(row)) {
            return;
        }
        ScanController scan = this.getScanController(this.fkInfo.refConglomNumber, this.refScoci, this.refDcoci, row);
        if (!scan.next()) {
            this.close();
            StandardException se = StandardException.newException("23503", this.fkInfo.fkConstraintNames[0], (Object)this.fkInfo.tableName, (Object)StatementUtil.typeName(this.fkInfo.stmtType), (Object)RowUtil.toString(row, this.fkInfo.colArray));
            throw se;
        }
    }

    int getRICheckIsolationLevel() {
        return 2;
    }
}

