/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.RAFContainer;
import org.apache.derby.io.StorageRandomAccessFile;

class RAFContainer4
extends RAFContainer {
    private FileChannel ourChannel = null;
    private int iosInProgress = 0;

    public RAFContainer4(BaseDataFileFactory factory) {
        super(factory);
    }

    private FileChannel getChannel(StorageRandomAccessFile file) {
        if (file instanceof RandomAccessFile) {
            return ((RandomAccessFile)((Object)file)).getChannel();
        }
        return null;
    }

    private FileChannel getChannel() {
        if (this.ourChannel == null) {
            this.ourChannel = this.getChannel(this.fileData);
        }
        return this.ourChannel;
    }

    synchronized boolean openContainer(ContainerKey newIdentity) throws StandardException {
        SanityManager.ASSERT(this.iosInProgress == 0, "Container opened while IO operations are in progress. This should not happen.");
        SanityManager.ASSERT(this.fileData == null, "fileData isn't null");
        SanityManager.ASSERT(this.ourChannel == null, "ourChannel isn't null");
        return super.openContainer(newIdentity);
    }

    synchronized void createContainer(ContainerKey newIdentity) throws StandardException {
        SanityManager.ASSERT(this.iosInProgress == 0, "Container created while IO operations are in progress. This should not happen.");
        SanityManager.ASSERT(this.fileData == null, "fileData isn't null");
        SanityManager.ASSERT(this.ourChannel == null, "ourChannel isn't null");
        super.createContainer(newIdentity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeContainer() {
        SanityManager.ASSERT(this.iosInProgress == 0 || this.getCommittedDropState(), "Container closed while IO operations are in progress.  This should not happen.");
        if (this.ourChannel != null) {
            try {
                this.ourChannel.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.ourChannel = null;
            }
        }
        super.closeContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPage(long pageNumber, byte[] pageData) throws IOException, StandardException {
        if (pageNumber == 0L) {
            RAFContainer4 rAFContainer4 = this;
            synchronized (rAFContainer4) {
                this.readPage0(pageNumber, pageData);
            }
        } else {
            this.readPage0(pageNumber, pageData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPage0(long pageNumber, byte[] pageData) throws IOException, StandardException {
        FileChannel ioChannel;
        RAFContainer4 rAFContainer4 = this;
        synchronized (rAFContainer4) {
            SanityManager.ASSERT(!this.getCommittedDropState());
            ioChannel = this.getChannel();
        }
        if (ioChannel != null) {
            RAFContainer4 rAFContainer42;
            long pageOffset = pageNumber * (long)this.pageSize;
            ByteBuffer pageBuf = ByteBuffer.wrap(pageData);
            try {
                rAFContainer42 = this;
                synchronized (rAFContainer42) {
                    ++this.iosInProgress;
                }
                this.readFull(pageBuf, ioChannel, pageOffset);
            }
            finally {
                rAFContainer42 = this;
                synchronized (rAFContainer42) {
                    --this.iosInProgress;
                }
            }
            if (this.dataFactory.databaseEncrypted() && pageNumber != 0L) {
                this.decryptPage(pageData, this.pageSize);
            }
        } else {
            super.readPage(pageNumber, pageData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePage(long pageNumber, byte[] pageData, boolean syncPage) throws IOException, StandardException {
        if (pageNumber == 0L) {
            RAFContainer4 rAFContainer4 = this;
            synchronized (rAFContainer4) {
                this.writePage0(pageNumber, pageData, syncPage);
            }
        } else {
            this.writePage0(pageNumber, pageData, syncPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writePage0(long pageNumber, byte[] pageData, boolean syncPage) throws IOException, StandardException {
        FileChannel ioChannel;
        RAFContainer4 rAFContainer4 = this;
        synchronized (rAFContainer4) {
            if (this.getCommittedDropState()) {
                return;
            }
            ioChannel = this.getChannel();
        }
        if (ioChannel != null) {
            RAFContainer4 rAFContainer42;
            byte[] dataToWrite;
            long pageOffset = pageNumber * (long)this.pageSize;
            byte[] encryptionBuf = null;
            if (this.dataFactory.databaseEncrypted()) {
                encryptionBuf = new byte[this.pageSize];
            }
            SanityManager.ASSERT((dataToWrite = this.updatePageArray(pageNumber, pageData, encryptionBuf, false)) != null, "RAFContainer4: dataToWrite is null after updatePageArray()");
            ByteBuffer writeBuffer = ByteBuffer.wrap(dataToWrite);
            this.dataFactory.writeInProgress();
            try {
                rAFContainer42 = this;
                synchronized (rAFContainer42) {
                    ++this.iosInProgress;
                }
                this.writeFull(writeBuffer, ioChannel, pageOffset);
            }
            catch (ClosedChannelException ioe) {
                RAFContainer4 rAFContainer43 = this;
                synchronized (rAFContainer43) {
                    block45: {
                        if (!this.getCommittedDropState()) break block45;
                        SanityManager.DEBUG_PRINT("RAFContainer4", "Write to a dropped and closed container discarded.");
                        return;
                    }
                    throw ioe;
                }
            }
            finally {
                RAFContainer4 rAFContainer44 = this;
                synchronized (rAFContainer44) {
                    --this.iosInProgress;
                }
                this.dataFactory.writeFinished();
            }
            if (syncPage) {
                this.dataFactory.writeInProgress();
                try {
                    rAFContainer42 = this;
                    synchronized (rAFContainer42) {
                        ++this.iosInProgress;
                    }
                    if (this.dataFactory.dataNotSyncedAtAllocation) return;
                    ioChannel.force(false);
                    return;
                }
                finally {
                    rAFContainer42 = this;
                    synchronized (rAFContainer42) {
                        --this.iosInProgress;
                    }
                    this.dataFactory.writeFinished();
                }
            }
            rAFContainer42 = this;
            synchronized (rAFContainer42) {
                this.needsSync = true;
                return;
            }
        }
        super.writePage(pageNumber, pageData, syncPage);
    }

    void writeAtOffset(StorageRandomAccessFile file, byte[] bytes, long offset) throws IOException {
        FileChannel ioChannel = this.getChannel(file);
        if (ioChannel != null) {
            this.writeFull(ByteBuffer.wrap(bytes), ioChannel, offset);
        } else {
            super.writeAtOffset(file, bytes, offset);
        }
    }

    byte[] getEmbryonicPage(StorageRandomAccessFile file, long offset) throws IOException {
        FileChannel ioChannel = this.getChannel(file);
        if (ioChannel != null) {
            ByteBuffer buffer = ByteBuffer.allocate(204);
            this.readFull(buffer, ioChannel, offset);
            return buffer.array();
        }
        return super.getEmbryonicPage(file, offset);
    }

    private final void readFull(ByteBuffer dstBuffer, FileChannel srcChannel, long position) throws IOException {
        while (dstBuffer.remaining() > 0) {
            if (srcChannel.read(dstBuffer, position + (long)dstBuffer.position()) != -1) continue;
            throw new EOFException("Reached end of file while attempting to read a whole page.");
        }
    }

    private final void writeFull(ByteBuffer srcBuffer, FileChannel dstChannel, long position) throws IOException {
        while (srcBuffer.remaining() > 0) {
            dstChannel.write(srcBuffer, position + (long)srcBuffer.position());
        }
    }
}

