/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.SyncFailedException;
import java.util.LinkedList;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.replication.master.MasterFactory;
import org.apache.derby.impl.store.raw.log.ChecksumOperation;
import org.apache.derby.impl.store.raw.log.LogAccessFileBuffer;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.io.StorageRandomAccessFile;

public class LogAccessFile {
    private static final int LOG_RECORD_FIXED_OVERHEAD_SIZE = 16;
    private static final int LOG_RECORD_HEADER_SIZE = 12;
    private static final int LOG_RECORD_TRAILER_SIZE = 4;
    private static final int LOG_NUMBER_LOG_BUFFERS = 3;
    private LinkedList freeBuffers;
    private LinkedList dirtyBuffers;
    private LogAccessFileBuffer currentBuffer;
    private boolean flushInProgress = false;
    private final StorageRandomAccessFile log;
    private final Object logFileSemaphore;
    static int mon_numWritesToLog;
    static int mon_numBytesToLog;
    MasterFactory masterFac;
    boolean inReplicationMasterMode = false;
    boolean inReplicationSlaveMode = false;
    private ArrayOutputStream logOutputBuffer;
    private FormatIdOutputStream logicalOut;
    private long checksumInstant = -1L;
    private int checksumLength;
    private int checksumLogRecordSize;
    private boolean writeChecksum;
    private ChecksumOperation checksumLogOperation;
    private LogRecord checksumLogRecord;
    private LogToFile logFactory;
    private boolean databaseEncrypted = false;

    public LogAccessFile(LogToFile logFactory, StorageRandomAccessFile log, int bufferSize) {
        if (SanityManager.DEBUG_ON("LogBufferOff")) {
            bufferSize = 10;
        }
        logFactory.checkForReplication(this);
        this.log = log;
        this.logFileSemaphore = log;
        this.logFactory = logFactory;
        SanityManager.ASSERT(true);
        this.freeBuffers = new LinkedList();
        this.dirtyBuffers = new LinkedList();
        for (int i = 0; i < 3; ++i) {
            LogAccessFileBuffer b = new LogAccessFileBuffer(bufferSize);
            this.freeBuffers.addLast(b);
        }
        this.currentBuffer = (LogAccessFileBuffer)this.freeBuffers.removeFirst();
        this.writeChecksum = logFactory.checkVersion(10, 1);
        if (this.inReplicationSlaveMode) {
            this.writeChecksum = false;
        }
        if (this.writeChecksum) {
            this.checksumLogOperation = new ChecksumOperation();
            this.checksumLogOperation.init();
            this.checksumLogRecord = new LogRecord();
            this.checksumLogRecord.setValue(null, this.checksumLogOperation);
            this.checksumLength = LogRecord.getStoredSize(this.checksumLogOperation.group(), null) + this.checksumLogOperation.getStoredSize();
            if (logFactory.databaseEncrypted()) {
                this.checksumLength = logFactory.getEncryptedDataLength(this.checksumLength);
                this.databaseEncrypted = true;
            }
            this.checksumLogRecordSize = this.checksumLength + 16;
            this.logOutputBuffer = new ArrayOutputStream();
            this.logicalOut = new FormatIdOutputStream(this.logOutputBuffer);
        } else {
            this.checksumLogRecordSize = 0;
        }
        this.currentBuffer.init(this.checksumLogRecordSize);
    }

    public void writeLogRecord(int length, long instant, byte[] data, int data_offset, byte[] optional_data, int optional_data_offset, int optional_data_length) throws StandardException, IOException {
        int total_log_record_length = length + 16;
        if (total_log_record_length <= this.currentBuffer.bytes_free) {
            int newpos;
            this.currentBuffer.position = newpos = this.appendLogRecordToBuffer(this.currentBuffer.buffer, this.currentBuffer.position, length, instant, data, data_offset, optional_data, optional_data_offset, optional_data_length);
            this.currentBuffer.bytes_free -= total_log_record_length;
            this.currentBuffer.greatest_instant = instant;
            int normalizedPosition = this.currentBuffer.position;
            if (this.writeChecksum) {
                normalizedPosition -= this.checksumLogRecordSize;
            }
            SanityManager.ASSERT(this.currentBuffer.bytes_free + normalizedPosition == this.currentBuffer.length, "free_bytes and position do not add up to the total length of the buffer");
        } else {
            int bigBufferLength = this.checksumLogRecordSize + total_log_record_length;
            byte[] bigbuffer = new byte[bigBufferLength];
            this.appendLogRecordToBuffer(bigbuffer, this.checksumLogRecordSize, length, instant, data, data_offset, optional_data, optional_data_offset, optional_data_length);
            if (this.writeChecksum) {
                this.checksumLogOperation.reset();
                this.checksumLogOperation.update(bigbuffer, this.checksumLogRecordSize, total_log_record_length);
                this.writeChecksumLogRecord(bigbuffer);
            }
            this.flushLogAccessFile();
            this.writeToLog(bigbuffer, 0, bigBufferLength, instant);
        }
    }

    private int appendLogRecordToBuffer(byte[] buff, int pos, int length, long instant, byte[] data, int data_offset, byte[] optional_data, int optional_data_offset, int optional_data_length) {
        pos = this.writeInt(length, buff, pos);
        pos = this.writeLong(instant, buff, pos);
        int data_length = length - optional_data_length;
        System.arraycopy(data, data_offset, buff, pos, data_length);
        pos += data_length;
        if (optional_data_length != 0) {
            System.arraycopy(optional_data, optional_data_offset, buff, pos, optional_data_length);
            pos += optional_data_length;
        }
        pos = this.writeInt(length, buff, pos);
        return pos;
    }

    private final int writeInt(int i, byte[] b, int p) {
        b[p++] = (byte)(i >>> 24 & 0xFF);
        b[p++] = (byte)(i >>> 16 & 0xFF);
        b[p++] = (byte)(i >>> 8 & 0xFF);
        b[p++] = (byte)(i & 0xFF);
        return p;
    }

    private final int writeLong(long l, byte[] b, int p) {
        b[p++] = (byte)((int)(l >>> 56) & 0xFF);
        b[p++] = (byte)((int)(l >>> 48) & 0xFF);
        b[p++] = (byte)((int)(l >>> 40) & 0xFF);
        b[p++] = (byte)((int)(l >>> 32) & 0xFF);
        b[p++] = (byte)((int)(l >>> 24) & 0xFF);
        b[p++] = (byte)((int)(l >>> 16) & 0xFF);
        b[p++] = (byte)((int)(l >>> 8) & 0xFF);
        b[p++] = (byte)((int)l & 0xFF);
        return p;
    }

    public void writeInt(int i) {
        SanityManager.ASSERT(this.currentBuffer.bytes_free >= 4);
        this.currentBuffer.position = this.writeInt(i, this.currentBuffer.buffer, this.currentBuffer.position);
        this.currentBuffer.bytes_free -= 4;
    }

    public void writeLong(long l) {
        SanityManager.ASSERT(this.currentBuffer.bytes_free >= 8);
        this.currentBuffer.position = this.writeLong(l, this.currentBuffer.buffer, this.currentBuffer.position);
        this.currentBuffer.bytes_free -= 8;
    }

    public void write(int b) {
        SanityManager.ASSERT(this.currentBuffer.bytes_free > 0);
        this.currentBuffer.buffer[this.currentBuffer.position++] = (byte)b;
        --this.currentBuffer.bytes_free;
    }

    public void write(byte[] b, int off, int len) {
        SanityManager.ASSERT(len <= this.currentBuffer.bytes_free);
        System.arraycopy(b, off, this.currentBuffer.buffer, this.currentBuffer.position, len);
        this.currentBuffer.bytes_free -= len;
        this.currentBuffer.position += len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushDirtyBuffers() throws IOException {
        LogAccessFile logAccessFile;
        LogAccessFileBuffer buf = null;
        int nFlushed = 0;
        try {
            int noOfBuffers;
            LogAccessFile logAccessFile2 = this;
            synchronized (logAccessFile2) {
                while (this.flushInProgress) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {}
                }
                noOfBuffers = this.dirtyBuffers.size();
                if (noOfBuffers > 0) {
                    buf = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                }
                this.flushInProgress = true;
            }
            while (nFlushed < noOfBuffers) {
                if (buf.position != 0) {
                    this.writeToLog(buf.buffer, 0, buf.position, buf.greatest_instant);
                }
                ++nFlushed;
                logAccessFile2 = this;
                synchronized (logAccessFile2) {
                    this.freeBuffers.addLast(buf);
                    if (nFlushed < noOfBuffers) {
                        buf = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                    } else {
                        int size = this.dirtyBuffers.size();
                        if (size > 0 && nFlushed <= 3) {
                            noOfBuffers += size;
                            buf = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                        }
                    }
                }
            }
            Object var9_9 = null;
            logAccessFile = this;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            LogAccessFile logAccessFile3 = this;
            synchronized (logAccessFile3) {
                this.flushInProgress = false;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (logAccessFile) {
            this.flushInProgress = false;
            this.notifyAll();
        }
    }

    public void flushLogAccessFile() throws IOException, StandardException {
        this.switchLogBuffer();
        this.flushDirtyBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchLogBuffer() throws IOException, StandardException {
        LogAccessFile logAccessFile = this;
        synchronized (logAccessFile) {
            if (this.currentBuffer.position == this.checksumLogRecordSize) {
                return;
            }
            if (this.writeChecksum) {
                this.checksumLogOperation.reset();
                this.checksumLogOperation.update(this.currentBuffer.buffer, this.checksumLogRecordSize, this.currentBuffer.position - this.checksumLogRecordSize);
                this.writeChecksumLogRecord(this.currentBuffer.buffer);
            }
            this.dirtyBuffers.addLast(this.currentBuffer);
            if (this.freeBuffers.size() == 0) {
                this.flushDirtyBuffers();
            }
            SanityManager.ASSERT(this.freeBuffers.size() > 0);
            this.currentBuffer = (LogAccessFileBuffer)this.freeBuffers.removeFirst();
            this.currentBuffer.init(this.checksumLogRecordSize);
            SanityManager.ASSERT(this.currentBuffer.position == this.checksumLogRecordSize);
            SanityManager.ASSERT(this.currentBuffer.bytes_free == this.currentBuffer.length);
            SanityManager.ASSERT(this.currentBuffer.bytes_free > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncLogAccessFile() throws IOException, StandardException {
        int i = 0;
        while (true) {
            try {
                LogAccessFile logAccessFile = this;
                synchronized (logAccessFile) {
                    this.log.sync(false);
                }
            }
            catch (SyncFailedException sfe) {
                ++i;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (i <= 20) continue;
                throw StandardException.newException("XSLA4.D", sfe);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void corrupt() throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, StandardException {
        if (this.currentBuffer.position != this.checksumLogRecordSize) {
            SanityManager.THROWASSERT("Log file being closed with data still buffered " + this.currentBuffer.position + " " + this.currentBuffer.bytes_free);
        }
        this.flushLogAccessFile();
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    protected void setReplicationMasterRole(MasterFactory masterFac) {
        this.masterFac = masterFac;
        this.inReplicationMasterMode = true;
    }

    protected void stopReplicationMasterRole() {
        this.inReplicationMasterMode = false;
        this.masterFac = null;
    }

    protected void setReplicationSlaveRole() {
        this.inReplicationSlaveMode = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToLog(byte[] b, int off, int len, long highestInstant) throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                int i = 0;
                while (true) {
                    try {
                        this.log.write(b, off, len);
                        if (!this.inReplicationMasterMode) break;
                        this.masterFac.appendLog(highestInstant, b, off, len);
                    }
                    catch (IOException ioe) {
                        if (i >= 5) {
                            throw ioe;
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
        ++mon_numWritesToLog;
        mon_numBytesToLog += len;
    }

    protected long reserveSpaceForChecksum(int length, long logFileNumber, long currentPosition) throws StandardException, IOException {
        int total_log_record_length = length + 16;
        boolean reserveChecksumSpace = false;
        if (this.currentBuffer.position == this.checksumLogRecordSize) {
            reserveChecksumSpace = this.writeChecksum;
        } else if (total_log_record_length > this.currentBuffer.bytes_free) {
            this.switchLogBuffer();
            reserveChecksumSpace = this.writeChecksum;
        }
        if (reserveChecksumSpace) {
            SanityManager.ASSERT(this.checksumInstant == -1L, "CHECKSUM INSTANT IS GETTING OVER WRITTEN");
            this.checksumInstant = LogCounter.makeLogInstantAsLong(logFileNumber, currentPosition);
            return this.checksumLogRecordSize;
        }
        return 0L;
    }

    private void writeChecksumLogRecord(byte[] buffer) throws IOException, StandardException {
        int p = 0;
        p = this.writeInt(this.checksumLength, buffer, p);
        p = this.writeLong(this.checksumInstant, buffer, p);
        this.logOutputBuffer.setData(buffer);
        this.logOutputBuffer.setPosition(p);
        this.logicalOut.writeObject(this.checksumLogRecord);
        if (this.databaseEncrypted) {
            int len = this.logFactory.encrypt(buffer, 12, this.checksumLength, buffer, 12);
            SanityManager.ASSERT(len == this.checksumLength, "encrypted log buffer length != log buffer len");
        }
        p = 12 + this.checksumLength;
        SanityManager.ASSERT((p = this.writeInt(this.checksumLength, buffer, p)) == this.checksumLogRecordSize, "position=" + p + "ckrecordsize=" + this.checksumLogRecordSize);
        if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
            SanityManager.DEBUG(LogToFile.DBG_FLAG, "Write log record: tranId=Null instant: " + LogCounter.toDebugString(this.checksumInstant) + " length: " + this.checksumLength + "\n" + this.checksumLogOperation + "\n");
        }
        this.checksumInstant = -1L;
    }

    protected void writeEndMarker(int marker) throws IOException, StandardException {
        this.flushLogAccessFile();
        byte[] b = this.currentBuffer.buffer;
        int p = 0;
        p = this.writeInt(marker, b, p);
        this.writeToLog(b, 0, p, -1L);
    }
}

