/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.GlobalXact;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;

public class GlobalXactId
extends GlobalXact
implements GlobalTransactionId {
    public GlobalXactId(int format_id, byte[] global_id, byte[] branch_id) {
        this.format_id = format_id;
        this.global_id = new byte[global_id.length];
        System.arraycopy(global_id, 0, this.global_id, 0, global_id.length);
        this.branch_id = new byte[branch_id.length];
        System.arraycopy(branch_id, 0, this.branch_id, 0, branch_id.length);
    }

    public GlobalXactId() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.format_id);
        SanityManager.ASSERT(this.global_id.length <= 64);
        SanityManager.ASSERT(this.global_id != null);
        SanityManager.ASSERT(this.branch_id != null);
        out.write(this.global_id.length);
        if (this.global_id.length > 0) {
            out.write(this.global_id);
        }
        out.write(this.branch_id.length);
        if (this.branch_id.length > 0) {
            out.write(this.branch_id);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.format_id = in.readInt();
        int array_len = in.read();
        SanityManager.ASSERT(array_len >= 0);
        this.global_id = new byte[array_len];
        if (array_len > 0) {
            in.read(this.global_id);
        }
        SanityManager.ASSERT((array_len = in.read()) >= 0);
        this.branch_id = new byte[array_len];
        if (array_len > 0) {
            in.read(this.branch_id);
        }
    }

    public int getTypeFormatId() {
        return 328;
    }

    public int getFormat_Id() {
        return this.format_id;
    }

    public byte[] getGlobalTransactionId() {
        return this.global_id;
    }

    public byte[] getBranchQualifier() {
        return this.branch_id;
    }
}

