/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.util;

public class Geom {
    static float magnitude(Point3D Point1, Point3D Point2) {
        Point3D Vector = Geom.newPoint3D(0.0f, 0.0f, 0.0f);
        Vector.X = Point2.X - Point1.X;
        Vector.Y = Point2.Y - Point1.Y;
        Vector.Z = Point2.Z - Point1.Z;
        return (float)Math.sqrt(Vector.X * Vector.X + Vector.Y * Vector.Y + Vector.Z * Vector.Z);
    }

    public static float DistancePointLine(Point3D point, Point3D lineStart, Point3D lineEnd) {
        Point3D intersection = Geom.newPoint3D(0.0f, 0.0f, 0.0f);
        float LineMag = Geom.magnitude(lineEnd, lineStart);
        float U = ((point.X - lineStart.X) * (lineEnd.X - lineStart.X) + (point.Y - lineStart.Y) * (lineEnd.Y - lineStart.Y) + (point.Z - lineStart.Z) * (lineEnd.Z - lineStart.Z)) / (LineMag * LineMag);
        if (U < 0.0f || U > 1.0f) {
            return 0.0f;
        }
        intersection.X = lineStart.X + U * (lineEnd.X - lineStart.X);
        intersection.Y = lineStart.Y + U * (lineEnd.Y - lineStart.Y);
        intersection.Z = lineStart.Z + U * (lineEnd.Z - lineStart.Z);
        return Geom.magnitude(point, intersection);
    }

    public static Point3D newPoint3D(float x, float y, float z) {
        Geom geom = new Geom();
        geom.getClass();
        return geom.new Point3D(x, y, z);
    }

    public class Point3D {
        public float X;
        public float Y;
        public float Z;

        public Point3D() {
            this.X = 0.0f;
            this.Y = 0.0f;
            this.Z = 0.0f;
        }

        public Point3D(float X, float Y, float Z) {
            this.X = X;
            this.Y = Y;
            this.Z = Z;
        }
    }
}

