/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.actions;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.editors.core.actions.DesignElementAction;
import org.eclipse.vtp.desktop.editors.core.actions.DesignElementActionFilter;
import org.eclipse.vtp.desktop.editors.themes.core.commands.CommandListener;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.osgi.framework.Bundle;

public class DesignElementActionManager {
    public static String designElementActionExtensionPointId = "org.eclipse.vtp.desktop.editors.core.designElementAction";
    private static DesignElementActionManager instance = new DesignElementActionManager();
    private List<ActionRecord> actionRecords = new ArrayList<ActionRecord>();

    public static DesignElementActionManager getDefault() {
        return instance;
    }

    public DesignElementActionManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(designElementActionExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            ActionRecord ar = new ActionRecord();
            String filterClassName = primitiveExtensions[i].getAttribute("filter-class");
            String actionClassName = primitiveExtensions[i].getAttribute("action-class");
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            try {
                Class actionClass;
                Class filterClass = contributor.loadClass(filterClassName);
                ar.filter = (DesignElementActionFilter)filterClass.newInstance();
                ar.actionClass = actionClass = contributor.loadClass(actionClassName);
                ar.con = actionClass.getConstructor(IDesignElement.class, CommandListener.class);
                this.actionRecords.add(ar);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public List<DesignElementAction> getActions(IDesignElement element, CommandListener commandListener) {
        LinkedList<DesignElementAction> ret = new LinkedList<DesignElementAction>();
        for (ActionRecord ar : this.actionRecords) {
            if (!ar.filter.isApplicable(element)) continue;
            ret.add(ar.createAction(element, commandListener));
        }
        return ret;
    }

    private class ActionRecord {
        Class<DesignElementAction> actionClass = null;
        Constructor<DesignElementAction> con = null;
        DesignElementActionFilter filter = null;

        private ActionRecord() {
        }

        DesignElementAction createAction(IDesignElement element, CommandListener commandListener) {
            try {
                return this.con.newInstance(element, commandListener);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

