/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.configuration;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.core.dialogs.ContentPage;
import org.eclipse.vtp.desktop.core.dialogs.MultiPageFramedDialog;
import org.eclipse.vtp.desktop.editors.core.configuration.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.configuration.ConfigurationContextSelector;
import org.eclipse.vtp.desktop.editors.core.configuration.ConfigurationContextSelectorListener;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.design.IDesign;

public class ComponentPropertiesDialog
extends MultiPageFramedDialog
implements ConfigurationContextSelectorListener {
    private IWorkflowProject project = null;
    private ConfigurationContextSelector selector = null;

    public ComponentPropertiesDialog(IDesign design, Shell parentShell) {
        super(parentShell);
        this.setSideBarSize(120);
        this.project = design.getDocument().getProject();
    }

    protected boolean processOk() {
        try {
            List pages = this.getPages();
            Iterator iterator = pages.iterator();
            while (iterator.hasNext()) {
                ((ComponentPropertiesPanel)((Object)iterator.next())).save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected void cancelPressed() {
        try {
            List pages = this.getPages();
            Iterator iterator = pages.iterator();
            while (iterator.hasNext()) {
                ((ComponentPropertiesPanel)((Object)iterator.next())).cancel();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.cancelPressed();
    }

    public void cancelDialog() {
        this.cancelPressed();
    }

    protected void handleShellCloseEvent() {
        try {
            List pages = this.getPages();
            Iterator iterator = pages.iterator();
            while (iterator.hasNext()) {
                ((ComponentPropertiesPanel)((Object)iterator.next())).cancel();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.handleShellCloseEvent();
    }

    protected void createDialogContents(Composite parent) {
        try {
            parent.setLayout((Layout)new GridLayout(1, false));
            Composite topComp = new Composite(parent, 0);
            topComp.setBackgroundMode(1);
            topComp.setBackground(parent.getBackground());
            topComp.setLayout((Layout)new FillLayout());
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 0x1000000;
            topComp.setLayoutData((Object)gridData);
            this.selector = new ConfigurationContextSelector(this.project);
            this.selector.createControls(topComp);
            Composite bottomComp = new Composite(parent, 0);
            bottomComp.setBackground(parent.getBackground());
            bottomComp.setLayout((Layout)new FillLayout());
            bottomComp.setLayoutData((Object)new GridData(1808));
            Composite c = new Composite(bottomComp, 0);
            c.setBackground(bottomComp.getBackground());
            super.createDialogContents(c);
            this.selector.addListener(this);
            this.selector.setContextFilter(((ComponentPropertiesPanel)this.getCurrentPage()).getApplicableContexts());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void contextSelectionChanged(Map<String, Object> values) {
        List pages = this.getPages();
        Iterator iterator = pages.iterator();
        while (iterator.hasNext()) {
            ((ComponentPropertiesPanel)((Object)iterator.next())).setConfigurationContext(values);
        }
    }

    public void addPage(ContentPage page) {
        if (page instanceof ComponentPropertiesPanel) {
            ((ComponentPropertiesPanel)page).setContainer(this);
        }
        super.addPage(page);
    }

    public void selectionChanged(String selection) {
        super.selectionChanged(selection);
        this.selector.setContextFilter(((ComponentPropertiesPanel)this.getCurrentPage()).getApplicableContexts());
    }

    public List<ComponentPropertiesPanel> getPanels() {
        LinkedList<ComponentPropertiesPanel> ret = new LinkedList<ComponentPropertiesPanel>();
        for (ContentPage contentPage : this.getPages()) {
            if (!(contentPage instanceof ComponentPropertiesPanel)) continue;
            ret.add((ComponentPropertiesPanel)contentPage);
        }
        return ret;
    }
}

