/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.editors.core.actions.DesignElementAction;
import org.eclipse.vtp.desktop.editors.core.actions.DesignElementActionManager;
import org.eclipse.vtp.desktop.editors.core.configuration.ComponentPropertiesDialog;
import org.eclipse.vtp.desktop.editors.core.configuration.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.configuration.ComponentPropertiesPanelProviderRegistry;
import org.eclipse.vtp.desktop.editors.core.controller.ControllerListener;
import org.eclipse.vtp.desktop.editors.core.controller.ModelNavigationListener;
import org.eclipse.vtp.desktop.editors.core.dialogs.CanvasPropertiesDialog;
import org.eclipse.vtp.desktop.editors.core.dialogs.CreateDialogTemplateWizard;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModel;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModelListener;
import org.eclipse.vtp.desktop.editors.core.model.SelectionResult;
import org.eclipse.vtp.desktop.editors.themes.core.ComponentFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ConnectorFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ElementFrame;
import org.eclipse.vtp.desktop.editors.themes.core.commands.BeginConnector;
import org.eclipse.vtp.desktop.editors.themes.core.commands.Command;
import org.eclipse.vtp.desktop.editors.themes.core.commands.CommandListener;
import org.eclipse.vtp.desktop.editors.themes.core.commands.LocateElement;
import org.eclipse.vtp.desktop.editors.themes.core.commands.ShowProperties;
import org.eclipse.vtp.desktop.editors.themes.core.commands.StartMove;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponent;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignConnector;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.desktop.model.elements.core.internal.DialogElement;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.desktop.views.pallet.PallateProviderManager;
import org.eclipse.vtp.desktop.views.pallet.PalletItem;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;
import org.eclipse.vtp.desktop.views.pallet.PalletItemTransfer;

public class BasicController
implements CommandListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
PaintListener,
DropTargetListener,
DragSourceListener,
KeyListener,
RenderedModelListener {
    RenderedModel currentCanvas;
    Point commandPosition = null;
    List<ControllerListener> listeners = new ArrayList<ControllerListener>();
    Map<String, Object> resourceMap = new HashMap<String, Object>();
    Control interactionSurface = null;
    boolean dragging = false;
    Point dragPoint = null;
    boolean isLine = false;
    boolean isArea = false;
    private DropTarget dropTarget = null;
    private DragSource dragSource = null;
    IAdaptable adaptableContainer = null;
    List<PalletItemProvider> providers = null;

    public BasicController(RenderedModel renderedCanvas) {
        this.currentCanvas = renderedCanvas;
        this.currentCanvas.addListener(this);
        this.providers = PallateProviderManager.getPallateProviders();
    }

    public void setContainer(IAdaptable adaptableContainer) {
        this.adaptableContainer = adaptableContainer;
    }

    public void setResourceMap(Map<String, Object> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public void showConnectorProperties(IDesignConnector connector) {
        try {
            Shell workbenchShell = Display.getCurrent().getActiveShell();
            boolean canDelete = connector.getConnectionPoints().isEmpty();
            ComponentPropertiesDialog cpd = new ComponentPropertiesDialog(this.currentCanvas.getUIModel(), workbenchShell);
            Color dialogFrameColor = new Color((Device)Display.getCurrent(), 77, 113, 179);
            Color dialogSideBarColor = new Color((Device)Display.getCurrent(), 240, 243, 249);
            cpd.setFrameColor(dialogFrameColor);
            cpd.setSideBarColor(dialogSideBarColor);
            cpd.setTitle("DesignConnector Properties: " + connector.getOrigin().getName() + " -> " + connector.getDestination().getName());
            List<ComponentPropertiesPanel> panels = ComponentPropertiesPanelProviderRegistry.getInstance().getPropertiesPanels((IDesignComponent)connector);
            for (ComponentPropertiesPanel panel : panels) {
                if (!panel.getName().equals("General")) continue;
                cpd.addPage(panel);
            }
            for (ComponentPropertiesPanel panel : panels) {
                if (panel.getName().equals("General")) continue;
                cpd.addPage(panel);
            }
            for (ComponentPropertiesPanel panel : panels) {
                panel.resolve();
            }
            cpd.open();
            if (connector.getConnectionPoints().isEmpty() && canDelete) {
                connector.getDesign().removeDesignConnector(connector);
            }
            this.fireGraphicUpdate(0, 0, this.currentCanvas.getUIModel().getWidth(), this.currentCanvas.getUIModel().getHeight(), false);
            dialogFrameColor.dispose();
            dialogSideBarColor.dispose();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void showCanvasProperties() {
        Shell workbenchShell = Display.getCurrent().getActiveShell();
        CanvasPropertiesDialog cpd = new CanvasPropertiesDialog(workbenchShell);
        cpd.setRenderedCanvas(this.currentCanvas);
        if (cpd.open() == 0) {
            this.fireGraphicUpdate(0, 0, this.currentCanvas.getUIModel().getWidth(), this.currentCanvas.getUIModel().getHeight(), false);
        }
    }

    public void showElementProperties(IDesignElement element) {
        this.showElementProperties(element, false);
    }

    public boolean showElementProperties(IDesignElement element, boolean deleteOnCancel) {
        boolean persists = !deleteOnCancel;
        try {
            Shell workbenchShell = Display.getCurrent().getActiveShell();
            ComponentPropertiesDialog cpd = new ComponentPropertiesDialog(this.currentCanvas.getUIModel(), workbenchShell);
            Color dialogFrameColor = new Color((Device)Display.getCurrent(), 77, 113, 179);
            Color dialogSideBarColor = new Color((Device)Display.getCurrent(), 240, 243, 249);
            cpd.setFrameColor(dialogFrameColor);
            cpd.setSideBarColor(dialogSideBarColor);
            cpd.setTitle(element.getTitle());
            List<ComponentPropertiesPanel> panels = ComponentPropertiesPanelProviderRegistry.getInstance().getPropertiesPanels((IDesignComponent)element);
            if (panels.size() > 0) {
                for (ComponentPropertiesPanel cpp : panels) {
                    cpd.addPage(cpp);
                }
                for (ComponentPropertiesPanel panel : panels) {
                    panel.resolve();
                }
                int open = cpd.open();
                if (open != 0 && deleteOnCancel) {
                    persists = false;
                    element.getDesign().removeDesignElement(element);
                } else if (deleteOnCancel) {
                    persists = true;
                }
                this.fireGraphicUpdate(0, 0, this.currentCanvas.getUIModel().getWidth(), this.currentCanvas.getUIModel().getHeight(), false);
            }
            dialogFrameColor.dispose();
            dialogSideBarColor.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return persists;
    }

    public void setControl(Control interactiveSurface) {
        this.interactionSurface = interactiveSurface;
        this.dropTarget = new DropTarget(this.interactionSurface, 19);
        this.dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), PalletItemTransfer.getInstance()});
        this.dropTarget.addDropListener((DropTargetListener)this);
        interactiveSurface.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BasicController.this.dropTarget.dispose();
                if (BasicController.this.dragSource != null) {
                    BasicController.this.dragSource.dispose();
                }
            }
        });
    }

    public void addListener(ControllerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ControllerListener listener) {
        this.listeners.remove(listener);
    }

    public void fillContextMenu(IMenuManager menuManager) {
        try {
            final Point contextPoint = new Point(this.commandPosition.x, this.commandPosition.y);
            MenuManager addMenu = new MenuManager("Add");
            menuManager.add((IContributionItem)addMenu);
            Comparator<PalletItem> comp = new Comparator<PalletItem>(){

                @Override
                public int compare(PalletItem o1, PalletItem o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            int i = 0;
            while (i < this.providers.size()) {
                if (i > 0) {
                    addMenu.add((IContributionItem)new Separator());
                }
                PalletItemProvider provider = this.providers.get(i);
                List items = provider.getPalletItems();
                Collections.sort(items, comp);
                for (Object item : items) {
                    if (!item.canBeContainedBy(this.currentCanvas.getUIModel())) continue;
                    addMenu.add((IAction)new Action(item.getName(), (PalletItem)item, contextPoint){
                        private final /* synthetic */ PalletItem val$item;
                        private final /* synthetic */ Point val$contextPoint;
                        {
                            this.val$item = palletItem;
                            this.val$contextPoint = point;
                            super($anonymous0);
                        }

                        public void run() {
                            BasicController.this.addElement(this.val$item, this.val$contextPoint);
                        }
                    });
                }
                ++i;
            }
            if (this.currentCanvas.getSelection() != null && this.currentCanvas.getSelection().getSelectedItems().size() > 1 && this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame) {
                MenuManager alignEdgeMenu = new MenuManager("Align Edges");
                menuManager.add((IContributionItem)alignEdgeMenu);
                alignEdgeMenu.add((IAction)new Action("Left"){

                    public void run() {
                        BasicController.this.currentCanvas.getSelection().alignEdge(16384);
                    }
                });
                alignEdgeMenu.add((IAction)new Action("Top"){

                    public void run() {
                        BasicController.this.currentCanvas.getSelection().alignEdge(128);
                    }
                });
                alignEdgeMenu.add((IAction)new Action("Right"){

                    public void run() {
                        BasicController.this.currentCanvas.getSelection().alignEdge(131072);
                    }
                });
                alignEdgeMenu.add((IAction)new Action("Bottom"){

                    public void run() {
                        BasicController.this.currentCanvas.getSelection().alignEdge(1024);
                    }
                });
                MenuManager alignCenterMenu = new MenuManager("Align Centers");
                menuManager.add((IContributionItem)alignCenterMenu);
                alignCenterMenu.add((IAction)new Action("Horizontal"){

                    public void run() {
                        BasicController.this.currentCanvas.getSelection().alignCenter(256);
                    }
                });
                alignCenterMenu.add((IAction)new Action("Vertical"){

                    public void run() {
                        BasicController.this.currentCanvas.getSelection().alignCenter(512);
                    }
                });
            }
            if (this.currentCanvas.getSelection() != null && this.currentCanvas.getSelection().getSelectedItems().size() == 1 && this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame && ((ElementFrame)this.currentCanvas.getSelection().getPrimarySelection()).getDesignElement() instanceof PrimitiveElement) {
                PrimitiveElement primitiveElement = (PrimitiveElement)((ElementFrame)this.currentCanvas.getSelection().getPrimarySelection()).getDesignElement();
                List<DesignElementAction> actionList = DesignElementActionManager.getDefault().getActions((IDesignElement)primitiveElement, this);
                for (DesignElementAction action : actionList) {
                    menuManager.add((IAction)action);
                }
            }
            if (this.currentCanvas.getSelection() != null && this.currentCanvas.getSelection().getSelectedItems().size() == 1 && this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame && ((ElementFrame)this.currentCanvas.getSelection().getPrimarySelection()).getDesignElement() instanceof DialogElement) {
                final DialogElement primitiveElement = (DialogElement)((ElementFrame)this.currentCanvas.getSelection().getPrimarySelection()).getDesignElement();
                menuManager.add((IAction)new Action("Create Template"){

                    public void run() {
                        CreateDialogTemplateWizard cdtw = new CreateDialogTemplateWizard(primitiveElement);
                        WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)cdtw);
                        wd.open();
                    }
                });
            }
            if (this.currentCanvas.getSelection() != null && this.currentCanvas.getSelection().getPrimarySelection() instanceof ConnectorFrame) {
                menuManager.add((IAction)new Action("Toggle Midpoint"){

                    public void run() {
                        ConnectorFrame cf = (ConnectorFrame)BasicController.this.currentCanvas.getSelection().getPrimarySelection();
                        cf.toggleMidPoint(contextPoint.x, contextPoint.y);
                        BasicController.this.fireGraphicUpdate(cf.getBounds(), false);
                    }
                });
            }
            if (this.currentCanvas.getSelection().getPrimarySelection() != null && this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame) {
                boolean canDelete = true;
                if (this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame) {
                    List<ComponentFrame> items = this.currentCanvas.getSelection().getSelectedItems();
                    int i2 = 0;
                    while (i2 < items.size()) {
                        ElementFrame ef = (ElementFrame)items.get(i2);
                        IDesignElement el = ef.getDesignElement();
                        canDelete &= el.canDelete();
                        ++i2;
                    }
                }
                if (canDelete) {
                    menuManager.add((IAction)new Action("Delete"){

                        public void run() {
                            MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                            confirmationDialog.setMessage("Are you sure you want to delete the selected item(s)?");
                            int result = confirmationDialog.open();
                            if (result == 64) {
                                BasicController.this.currentCanvas.deleteSelectedItems();
                                BasicController.this.fireGraphicUpdate(0, 0, BasicController.this.currentCanvas.getUIModel().getWidth(), BasicController.this.currentCanvas.getUIModel().getHeight(), false);
                            }
                        }
                    });
                }
            }
            if (this.currentCanvas.getSelection().getPrimarySelection() != null && this.currentCanvas.getSelection().getPrimarySelection() instanceof ConnectorFrame) {
                menuManager.add((IAction)new Action("Delete"){

                    public void run() {
                        MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                        confirmationDialog.setMessage("Are you sure you want to delete the selected item(s)?");
                        int result = confirmationDialog.open();
                        if (result == 64) {
                            BasicController.this.currentCanvas.deleteSelectedItems();
                            BasicController.this.fireGraphicUpdate(0, 0, BasicController.this.currentCanvas.getUIModel().getWidth(), BasicController.this.currentCanvas.getUIModel().getHeight(), false);
                        }
                    }
                });
            }
            menuManager.add((IContributionItem)new Separator());
            if (this.currentCanvas.getSelection().getPrimarySelection() == null || this.currentCanvas.getSelection().getPrimarySelection() instanceof ConnectorFrame) {
                menuManager.add((IAction)new Action("Properties"){

                    public void run() {
                        ComponentFrame cf;
                        ComponentFrame componentFrame = cf = BasicController.this.currentCanvas.getSelection().getSelectedItems().size() > 1 ? null : BasicController.this.currentCanvas.getSelection().getPrimarySelection();
                        if (cf != null) {
                            if (cf instanceof ConnectorFrame) {
                                BasicController.this.showConnectorProperties(((ConnectorFrame)cf).getDesignConnector());
                            } else {
                                BasicController.this.showElementProperties(((ElementFrame)cf).getDesignElement());
                            }
                        } else {
                            BasicController.this.showCanvasProperties();
                        }
                    }
                });
            }
            if (this.currentCanvas.getSelection().getPrimarySelection() != null && this.currentCanvas.getSelection().getSelectedItems().size() == 1 && this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame && ComponentPropertiesPanelProviderRegistry.getInstance().hasPropertiesPanels((IDesignComponent)((ElementFrame)this.currentCanvas.getSelection().getPrimarySelection()).getDesignElement())) {
                menuManager.add((IAction)new Action("Properties"){

                    public void run() {
                        ComponentFrame cf;
                        ComponentFrame componentFrame = cf = BasicController.this.currentCanvas.getSelection().getSelectedItems().size() > 1 ? null : BasicController.this.currentCanvas.getSelection().getPrimarySelection();
                        if (cf != null) {
                            if (cf instanceof ConnectorFrame) {
                                BasicController.this.showConnectorProperties(((ConnectorFrame)cf).getDesignConnector());
                            } else {
                                BasicController.this.showElementProperties(((ElementFrame)cf).getDesignElement());
                            }
                        } else {
                            BasicController.this.showCanvasProperties();
                        }
                    }
                });
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void fireGraphicUpdate(Rectangle rec, boolean inProgress) {
        this.fireGraphicUpdate(rec.x, rec.y, rec.width, rec.height, inProgress);
    }

    public void fireGraphicUpdate(int x, int y, int width, int height, boolean inProgress) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).graphicUpdate(x, y, width, height, inProgress);
            ++i;
        }
    }

    public void fireSelectionChanged() {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).selectionChanged(this.currentCanvas.getSelection());
            ++i;
        }
    }

    public void mouseDown(MouseEvent event) {
        try {
            this.commandPosition = new Point(event.x, event.y);
            Rectangle initialSelectionRect = this.currentCanvas.getSelection().getTertiaryBounds();
            ComponentFrame initialPrimarySelection = this.currentCanvas.getSelection().getPrimarySelection();
            SelectionResult result = this.currentCanvas.selectAt(event.x, event.y, (event.stateMask & 0x20000) != 0);
            System.out.println("result: hit=" + result.wasHit() + " selectionChanged=" + result.wasSelectionChanged() + " primaryChanged=" + result.wasPrimaryChanged());
            if (result.wasSelectionChanged()) {
                if (initialPrimarySelection == null) {
                    this.fireGraphicUpdate(this.currentCanvas.getSelection().getTertiaryBounds(), false);
                } else {
                    this.fireGraphicUpdate(this.currentCanvas.getSelection().getTertiaryBounds() == null ? initialSelectionRect : initialSelectionRect.union(this.currentCanvas.getSelection().getTertiaryBounds()), false);
                }
                this.fireSelectionChanged();
            }
            if (event.button == 1) {
                if (result.wasHit()) {
                    this.currentCanvas.getSelection().getPrimarySelection().mouseDown((CommandListener)this, event.x, event.y, event.stateMask);
                } else {
                    this.dragPoint = this.commandPosition;
                    this.dragging = true;
                    this.isArea = true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void mouseUp(MouseEvent event) {
        try {
            this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(0));
            this.commandPosition = new Point(event.x, event.y);
            if (this.dragging) {
                boolean wasLine = this.isLine;
                boolean wasArea = this.isArea;
                this.dragging = false;
                this.isLine = false;
                this.isArea = false;
                if (wasLine) {
                    ElementFrame ef = (ElementFrame)this.currentCanvas.getSelection().getPrimarySelection();
                    ElementFrame dest = this.currentCanvas.findElementAt(event.x, event.y);
                    if (dest != null) {
                        if (dest.getDesignElement().acceptsConnector(ef.getDesignElement())) {
                            ConnectorFrame connectorFrame = this.currentCanvas.connectElements(ef, dest);
                            this.showConnectorProperties(connectorFrame.getDesignConnector());
                            this.currentCanvas.select((ComponentFrame)connectorFrame, false);
                            this.currentCanvas.postAddedItem();
                        }
                        this.currentCanvas.getSelection().validateSelection();
                        this.fireGraphicUpdate(ef.getBounds().union(dest.getBounds()), false);
                    } else {
                        this.fireGraphicUpdate(ef.getBounds().union(new Rectangle(Math.min(this.dragPoint.x, this.commandPosition.x), Math.min(this.dragPoint.y, this.commandPosition.y), Math.abs(this.commandPosition.x - this.dragPoint.x) + 2, Math.abs(this.commandPosition.y - this.dragPoint.y) + 2)), false);
                    }
                } else if (wasArea) {
                    Rectangle selectionArea = new Rectangle(Math.min(this.dragPoint.x, this.commandPosition.x) - 2, Math.min(this.dragPoint.y, this.commandPosition.y) - 2, Math.abs(this.dragPoint.x - this.commandPosition.x) + 4, Math.abs(this.dragPoint.y - this.commandPosition.y) + 4);
                    Rectangle initialSelectionRect = this.currentCanvas.getSelection().getTertiaryBounds();
                    this.currentCanvas.selectRegion(selectionArea, (event.stateMask & 0x20000) != 0);
                    Rectangle currentSelectionRect = this.currentCanvas.getSelection().getTertiaryBounds();
                    if (initialSelectionRect != null && !initialSelectionRect.isEmpty()) {
                        selectionArea.add(initialSelectionRect);
                    }
                    if (currentSelectionRect != null && !currentSelectionRect.isEmpty()) {
                        selectionArea.add(currentSelectionRect);
                    }
                    this.fireGraphicUpdate(selectionArea, false);
                } else {
                    this.currentCanvas.getSelection().endMove();
                    this.fireGraphicUpdate(this.currentCanvas.getSelection().getTertiaryBounds(), false);
                }
            } else {
                ComponentFrame cf = this.currentCanvas.findComponentAt(event.x, event.y);
                if (cf != null) {
                    cf.mouseUp((CommandListener)this, event.x, event.y, event.stateMask);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
        this.commandPosition = new Point(event.x, event.y);
        this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(0));
        this.dragging = false;
        this.isLine = false;
        this.isArea = false;
        ComponentFrame cf = this.currentCanvas.findComponentAt(event.x, event.y);
        if (cf != null) {
            cf.mouseDoubleClick((CommandListener)this, event.x, event.y, event.stateMask);
        } else {
            this.showCanvasProperties();
        }
    }

    public void mouseMove(MouseEvent event) {
        Point oldPosition = this.commandPosition;
        this.commandPosition = new Point(event.x, event.y);
        if (this.dragging) {
            this.currentCanvas.startBatchUpdate();
            Rectangle redrawArea = null;
            if (!this.isLine && !this.isArea) {
                redrawArea = this.currentCanvas.getSelection().getTertiaryBounds();
                this.currentCanvas.getSelection().adjustPosition(this.commandPosition.x - this.dragPoint.x, this.commandPosition.y - this.dragPoint.y);
                redrawArea.add(this.currentCanvas.getSelection().getTertiaryBounds());
                this.dragPoint = this.commandPosition;
            } else if (this.isArea) {
                if (oldPosition == null) {
                    oldPosition = new Point(0, 0);
                }
                Rectangle previousSelectionArea = new Rectangle(Math.min(this.dragPoint.x, oldPosition.x) - 2, Math.min(this.dragPoint.y, oldPosition.y) - 2, Math.abs(this.dragPoint.x - oldPosition.x) + 4, Math.abs(this.dragPoint.y - oldPosition.y) + 4);
                Rectangle currentSelectionArea = new Rectangle(Math.min(this.dragPoint.x, this.commandPosition.x) - 2, Math.min(this.dragPoint.y, this.commandPosition.y) - 2, Math.abs(this.dragPoint.x - this.commandPosition.x) + 4, Math.abs(this.dragPoint.y - this.commandPosition.y) + 4);
                redrawArea = previousSelectionArea.union(currentSelectionArea);
            } else {
                ElementFrame ef = (ElementFrame)this.currentCanvas.getSelection().getPrimarySelection();
                redrawArea = ef.getBounds().union(new Rectangle(Math.min(this.dragPoint.x, this.commandPosition.x), Math.min(this.dragPoint.y, this.commandPosition.y), Math.abs(this.commandPosition.x - this.dragPoint.x) + 2, Math.abs(this.commandPosition.y - this.dragPoint.y) + 2));
                redrawArea.add(new Rectangle(Math.min(this.dragPoint.x, oldPosition.x), Math.min(this.dragPoint.y, oldPosition.y), Math.abs(oldPosition.x - this.dragPoint.x) + 2, Math.abs(oldPosition.y - this.dragPoint.y) + 2));
                ElementFrame df = this.currentCanvas.findElementAt(event.x, event.y);
                if (df != null) {
                    if (!df.getDesignElement().acceptsConnector(ef.getDesignElement())) {
                        this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(20));
                    }
                } else {
                    this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(2));
                }
            }
            this.currentCanvas.endBatchUpdate();
        }
    }

    public void mouseEnter(MouseEvent event) {
    }

    public void mouseExit(MouseEvent event) {
        if (!this.dragging || !this.isLine) {
            // empty if block
        }
    }

    public void mouseHover(MouseEvent event) {
        this.commandPosition = new Point(event.x, event.y);
    }

    public void paintControl(PaintEvent e) {
        this.paintCanvas(e.gc);
    }

    public void paintCanvas(GC gc1) {
        int curPri = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        Image buffer = new Image(gc1.getDevice(), this.currentCanvas.getUIModel().getWidth(), this.currentCanvas.getUIModel().getHeight());
        GC gc = new GC((Drawable)buffer);
        gc.setBackground(gc1.getBackground());
        gc.setForeground(gc1.getForeground());
        gc.fillRectangle(0, 0, this.currentCanvas.getUIModel().getWidth(), this.currentCanvas.getUIModel().getHeight());
        if (this.isLine && this.dragging) {
            gc.drawLine(this.dragPoint.x, this.dragPoint.y, this.commandPosition.x, this.commandPosition.y);
        }
        this.currentCanvas.paintCanvas(gc, this.resourceMap, 0);
        if (this.isArea && this.dragging) {
            gc.setLineStyle(3);
            gc.setLineWidth(2);
            Rectangle currentSelectionArea = new Rectangle(Math.min(this.dragPoint.x, this.commandPosition.x), Math.min(this.dragPoint.y, this.commandPosition.y), Math.abs(this.dragPoint.x - this.commandPosition.x), Math.abs(this.dragPoint.y - this.commandPosition.y));
            gc.drawRectangle(currentSelectionArea);
            gc.setLineWidth(1);
        }
        gc1.drawImage(buffer, 0, 0);
        gc.dispose();
        buffer.dispose();
        Thread.currentThread().setPriority(curPri);
    }

    public void executeCommand(Command command) {
        if (command instanceof StartMove) {
            this.dragging = true;
            this.dragPoint = this.commandPosition;
            this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(5));
            this.currentCanvas.getSelection().startMove();
        } else if (command instanceof BeginConnector) {
            this.dragging = true;
            ElementFrame ef = (ElementFrame)this.currentCanvas.getSelection().getPrimarySelection();
            this.dragPoint = ef.getDesignElement().getCenterPoint();
            this.isLine = true;
            this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(2));
        } else if (command instanceof ShowProperties) {
            IDesignElement component;
            ComponentFrame cof = this.currentCanvas.getSelection().getPrimarySelection();
            Object object = component = cof instanceof ElementFrame ? ((ElementFrame)cof).getDesignElement() : ((ConnectorFrame)cof).getDesignConnector();
            if (component instanceof DesignConnector) {
                this.showConnectorProperties((IDesignConnector)((DesignConnector)component));
            } else {
                ModelNavigationListener navigationListener;
                DesignElement element = (DesignElement)component;
                if (element instanceof DialogElement && (navigationListener = (ModelNavigationListener)this.adaptableContainer.getAdapter(ModelNavigationListener.class)) != null) {
                    navigationListener.showDesign(((DialogElement)element).getId());
                }
                this.showElementProperties((IDesignElement)element);
            }
        } else if (command instanceof LocateElement) {
            LocateElement le = (LocateElement)command;
            String elementId = le.getElementId();
            ModelNavigationListener navigationListener = (ModelNavigationListener)this.adaptableContainer.getAdapter(ModelNavigationListener.class);
            if (navigationListener != null) {
                navigationListener.navigateToElement(elementId);
            }
        }
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        this.interactionSurface.setFocus();
        try {
            PalletItem pi = PalletItemTransfer.getInstance().getPalletItem();
            Point dropPoint = this.interactionSurface.toControl(event.x, event.y);
            this.addElement(pi, dropPoint);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void addElement(PalletItem pi, Point dropPoint) {
        DesignElement createdElement = pi.createElement((Design)this.currentCanvas.getUIModel());
        this.currentCanvas.addElement(createdElement, dropPoint.x, dropPoint.y);
        this.fireGraphicUpdate(0, 0, this.currentCanvas.getUIModel().getWidth(), this.currentCanvas.getUIModel().getHeight(), false);
        boolean persists = true;
        if (pi.isPopOnDrop()) {
            persists = this.showElementProperties((IDesignElement)createdElement, true);
        }
        if (persists) {
            this.currentCanvas.selectAt(dropPoint.x, dropPoint.y, false);
            this.currentCanvas.postAddedItem();
        }
    }

    public void dropAccept(DropTargetEvent event) {
        if (!PalletItemTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 0;
        }
    }

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = event.x == -1 && event.y == -1;
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == '\u007f' && this.currentCanvas.getSelection().getPrimarySelection() != null) {
            boolean canDelete = true;
            if (this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame) {
                List<ComponentFrame> items = this.currentCanvas.getSelection().getSelectedItems();
                int i = 0;
                while (i < items.size()) {
                    ElementFrame ef = (ElementFrame)items.get(i);
                    IDesignElement el = ef.getDesignElement();
                    canDelete &= el.canDelete();
                    ++i;
                }
            }
            if (!canDelete) {
                return;
            }
            MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
            confirmationDialog.setMessage("Are you sure you want to delete the selected item(s)?");
            int result = confirmationDialog.open();
            if (result == 64) {
                this.currentCanvas.deleteSelectedItems();
                this.fireGraphicUpdate(0, 0, this.currentCanvas.getUIModel().getWidth(), this.currentCanvas.getUIModel().getHeight(), false);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void renderedModelChanged(RenderedModel renderedCanvas) {
        this.fireGraphicUpdate(0, 0, this.currentCanvas.getUIModel().getWidth(), this.currentCanvas.getUIModel().getHeight(), false);
    }

    @Override
    public void renderedModelFormatChanged(RenderedModel renderedCanvas) {
        this.fireGraphicUpdate(0, 0, this.currentCanvas.getUIModel().getWidth(), this.currentCanvas.getUIModel().getHeight(), false);
    }

    public RenderedModel getRenderedCanvas() {
        return this.currentCanvas;
    }
}

