/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObject;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectField;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.internal.BusinessObject;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BusinessObjectEditor
extends EditorPart {
    BusinessObject bo;
    boolean dirty = false;
    TableViewer viewer;
    List<FieldRecord> fieldRecords = new ArrayList<FieldRecord>();
    TextCellEditor nameEditor;
    ComboBoxCellEditor typeEditor;
    ComboBoxCellEditor precisionEditor;
    ComboBoxCellEditor styleEditor;
    CheckboxCellEditor securedEditor;
    TextCellEditor initialValueEditor;
    List<String> currentTypes = new ArrayList<String>();

    public void doSave(IProgressMonitor monitor) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = doc.createElement("business-object");
            doc.appendChild(rootElement);
            rootElement.setAttribute("id", this.bo.getId());
            rootElement.setAttribute("name", this.bo.getName());
            Element fields = rootElement.getOwnerDocument().createElement("fields");
            rootElement.appendChild(fields);
            for (FieldRecord fr : this.fieldRecords) {
                Element fieldElement = fields.getOwnerDocument().createElement("field");
                fields.appendChild(fieldElement);
                fieldElement.setAttribute("name", fr.name);
                fieldElement.setAttribute("initialValue", fr.initialValue);
                fieldElement.setAttribute("secured", Boolean.toString(fr.secured));
                fr.type.write(fieldElement);
            }
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("encoding", "UTF-8");
            trans.transform(source, new XMLWriter((OutputStream)baos).toXMLResult());
            this.bo.write((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            this.dirty = false;
            this.firePropertyChange(257);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof FileEditorInput)) {
            throw new PartInitException("Cannot edit: " + input);
        }
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(input.getName());
        IFile file = ((FileEditorInput)input).getFile();
        IProject project = file.getProject();
        try {
            IWorkflowProject workflowProject = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowProject(project);
            List dbs = workflowProject.getBusinessObjectSet().getBusinessObjects();
            for (IBusinessObject bus : dbs) {
                if (!bus.getUnderlyingFile().equals((Object)file)) continue;
                this.bo = (BusinessObject)bus;
                break;
            }
            if (this.bo == null) {
                throw new PartInitException("database table file not associated correctly");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new PartInitException("not in application project", (Throwable)e);
        }
        List fields = this.bo.getFields();
        for (IBusinessObjectField bof : fields) {
            FieldRecord fr = new FieldRecord();
            fr.name = bof.getName();
            fr.type = bof.getDataType();
            fr.initialValue = bof.getInitialValue();
            fr.secured = bof.isSecured();
            this.fieldRecords.add(fr);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 65540);
        table.setHeaderVisible(true);
        TableColumn fieldLock = new TableColumn(table, 0);
        fieldLock.setImage(Activator.getDefault().getImageRegistry().get("ICON_LOCK"));
        fieldLock.setWidth(23);
        TableColumn fieldName = new TableColumn(table, 0);
        fieldName.setText("Name");
        fieldName.setWidth(200);
        TableColumn dataType = new TableColumn(table, 0);
        dataType.setText("Type");
        dataType.setWidth(150);
        TableColumn precision = new TableColumn(table, 0);
        precision.setText("Precision");
        precision.setWidth(60);
        TableColumn initialValue = new TableColumn(table, 0);
        initialValue.setText("Initial Value");
        initialValue.setWidth(200);
        this.nameEditor = new TextCellEditor((Composite)table);
        this.nameEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                String text = (String)value;
                if (text == null) {
                    text = "";
                }
                FieldRecord fr = (FieldRecord)((IStructuredSelection)BusinessObjectEditor.this.viewer.getSelection()).getFirstElement();
                int i = 0;
                while (i < BusinessObjectEditor.this.fieldRecords.size()) {
                    if (fr != BusinessObjectEditor.this.fieldRecords.get(i) && BusinessObjectEditor.this.fieldRecords.get((int)i).name.equals(text)) {
                        return "A field with that name already exists.";
                    }
                    ++i;
                }
                return null;
            }
        });
        this.nameEditor.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                if (!newValidState) {
                    BusinessObjectEditor.this.nameEditor.getControl().setForeground(BusinessObjectEditor.this.nameEditor.getControl().getDisplay().getSystemColor(3));
                } else {
                    BusinessObjectEditor.this.nameEditor.getControl().setForeground(BusinessObjectEditor.this.nameEditor.getControl().getDisplay().getSystemColor(2));
                }
            }
        });
        this.typeEditor = new ComboBoxCellEditor((Composite)table, new String[]{"String", "Number", "Decimal", "Boolean", "DateTime", "Array", "Map"}, 12);
        this.precisionEditor = new ComboBoxCellEditor((Composite)table, new String[]{"Single", "Double", "Absolute"}, 12);
        this.initialValueEditor = new TextCellEditor((Composite)table);
        this.securedEditor = new CheckboxCellEditor((Composite)table);
        this.viewer = new TableViewer(table);
        this.viewer.setColumnProperties(new String[]{"Secured", "Name", "Type", "Precision", "Initial"});
        this.viewer.setContentProvider((IContentProvider)new FieldContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FieldLabelProvider());
        this.viewer.setCellModifier((ICellModifier)new FieldCellModifier());
        this.viewer.setCellEditors(new CellEditor[]{this.securedEditor, this.nameEditor, this.typeEditor, this.precisionEditor, this.initialValueEditor});
        this.viewer.setInput((Object)this);
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BusinessObjectEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)new Action("Add Field"){

            public void run() {
                FieldRecord newField = new FieldRecord();
                newField.name = "";
                newField.type = FieldType.STRING;
                newField.initialValue = "";
                BusinessObjectEditor.this.fieldRecords.add(newField);
                BusinessObjectEditor.this.viewer.refresh();
                BusinessObjectEditor.this.viewer.editElement((Object)newField, 1);
                BusinessObjectEditor.this.fireModified();
            }
        });
        if (!this.viewer.getSelection().isEmpty()) {
            final FieldRecord fr = (FieldRecord)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            manager.add((IAction)new Action("Remove Field"){

                public void run() {
                    MessageBox mb = new MessageBox(BusinessObjectEditor.this.viewer.getControl().getShell(), 200);
                    mb.setMessage("Are you sure you want to delete this?");
                    int result = mb.open();
                    if (result == 64) {
                        BusinessObjectEditor.this.fieldRecords.remove(fr);
                        BusinessObjectEditor.this.viewer.refresh();
                        BusinessObjectEditor.this.fireModified();
                    }
                }
            });
        }
    }

    public void setFocus() {
    }

    private void fireModified() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public class BaseTypeDialog
    extends Dialog {
        String baseType;
        Combo typeCombo;
        List<String> types;

        public BaseTypeDialog(Shell parentShell) {
            super(parentShell);
            this.typeCombo = null;
            this.types = null;
        }

        public BaseTypeDialog(IShellProvider parentShell) {
            super(parentShell);
            this.typeCombo = null;
            this.types = null;
        }

        public void setCurrentType(String type) {
            this.baseType = type;
        }

        public void setTypes(List<String> types) {
            this.types = types;
        }

        protected Control createDialogArea(Composite parent) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label nameLabel = new Label(parent, 0);
            nameLabel.setText("Base Type:");
            nameLabel.setLayoutData((Object)new GridData());
            this.typeCombo = new Combo(parent, 12);
            this.typeCombo.setItems(this.types.toArray(new String[this.types.size()]));
            if (this.baseType == null) {
                this.baseType = this.types.get(0);
            } else {
                int i = 0;
                while (i < this.types.size()) {
                    if (this.types.get(i).equals(this.baseType)) {
                        this.typeCombo.select(i);
                    }
                    ++i;
                }
            }
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.typeCombo.setLayoutData((Object)gd);
            this.typeCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    BaseTypeDialog.this.baseType = BaseTypeDialog.this.typeCombo.getSelectionIndex() > 0 ? BaseTypeDialog.this.types.get(BaseTypeDialog.this.typeCombo.getSelectionIndex()) : BaseTypeDialog.this.types.get(0);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return parent;
        }

        public String getBaseType() {
            return this.baseType;
        }
    }

    public class FieldCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            FieldRecord fr = (FieldRecord)element;
            if (property.equals("Type") || property.equals("Name") || property.equals("Initial")) {
                return true;
            }
            if (property.equals("Precision")) {
                return !fr.type.isObject() && fr.type.getPrimitiveType().hasPrecision();
            }
            return property.equals("Secured");
        }

        public Object getValue(Object element, String property) {
            FieldRecord fr = (FieldRecord)element;
            if (property.equals("Secured")) {
                return new Boolean(fr.secured);
            }
            if (property.equals("Precision")) {
                return new Integer(fr.type.getPrecision());
            }
            if (property.equals("Name")) {
                return fr.name == null ? "" : fr.name;
            }
            if (property.equals("Initial")) {
                return fr.initialValue == null ? "" : fr.initialValue;
            }
            if (property.equals("Type")) {
                BusinessObjectEditor.this.currentTypes.clear();
                BusinessObjectEditor.this.currentTypes.add("String");
                BusinessObjectEditor.this.currentTypes.add("Number");
                BusinessObjectEditor.this.currentTypes.add("Decimal");
                BusinessObjectEditor.this.currentTypes.add("Boolean");
                BusinessObjectEditor.this.currentTypes.add("DateTime");
                BusinessObjectEditor.this.currentTypes.add("Array");
                BusinessObjectEditor.this.currentTypes.add("Map");
                int sel = -1;
                List bos = BusinessObjectEditor.this.bo.getBusinessObjectSet().getBusinessObjects();
                int i = 0;
                while (i < bos.size()) {
                    IBusinessObject b = (IBusinessObject)bos.get(i);
                    if (!b.getName().equals(BusinessObjectEditor.this.bo.getName())) {
                        BusinessObjectEditor.this.currentTypes.add(b.getName());
                        if (fr.type.isObject() && b.getName().equals(fr.type.getObjectType().getName())) {
                            sel = i + 7;
                        }
                    }
                    ++i;
                }
                BusinessObjectEditor.this.typeEditor.setItems(BusinessObjectEditor.this.currentTypes.toArray(new String[BusinessObjectEditor.this.currentTypes.size()]));
                if (sel == -1) {
                    switch (fr.type.getPrimitiveType()) {
                        case STRING: {
                            return new Integer(0);
                        }
                        case NUMBER: {
                            return new Integer(1);
                        }
                        case DECIMAL: {
                            return new Integer(2);
                        }
                        case BOOLEAN: {
                            return new Integer(3);
                        }
                        case DATETIME: {
                            return new Integer(4);
                        }
                        case ARRAY: {
                            return new Integer(5);
                        }
                        case MAP: {
                            return new Integer(6);
                        }
                    }
                } else {
                    return new Integer(sel);
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            block7: {
                block13: {
                    String selectedType;
                    block11: {
                        FieldType.Primitive prim;
                        block12: {
                            FieldType.Primitive basePrim;
                            FieldRecord fr;
                            block10: {
                                block9: {
                                    block8: {
                                        block6: {
                                            TableItem ti = (TableItem)element;
                                            fr = (FieldRecord)ti.getData();
                                            if (!property.equals("Secured")) break block6;
                                            fr.secured = (Boolean)value;
                                            break block7;
                                        }
                                        if (!property.equals("Name")) break block8;
                                        if (value != null) {
                                            String oldName = fr.name;
                                            fr.name = (String)value;
                                            if (!fr.name.equals(oldName)) {
                                                BusinessObjectEditor.this.fireModified();
                                            }
                                        }
                                        break block7;
                                    }
                                    if (!property.equals("Initial")) break block9;
                                    fr.initialValue = value == null ? "" : (String)value;
                                    BusinessObjectEditor.this.fireModified();
                                    break block7;
                                }
                                if (!property.equals("Precision")) break block10;
                                fr.type.setPrecision(((Integer)value).intValue());
                                BusinessObjectEditor.this.fireModified();
                                break block7;
                            }
                            if (!property.equals("Type")) break block7;
                            int sel = (Integer)value;
                            if (!fr.type.getName().equals(BusinessObjectEditor.this.currentTypes.get(sel))) {
                                fr.initialValue = "";
                            }
                            if ((prim = FieldType.Primitive.find((String)(selectedType = BusinessObjectEditor.this.currentTypes.get(sel)))) == null) break block11;
                            if (!prim.hasBaseType()) break block12;
                            BaseTypeDialog btd = new BaseTypeDialog(BusinessObjectEditor.this.getEditorSite().getShell());
                            if (fr.type.getPrimitiveType().hasBaseType()) {
                                btd.setCurrentType(fr.type.getBaseTypeName());
                            }
                            LinkedList<String> types = new LinkedList<String>();
                            types.add("ANYTYPE");
                            types.add("String");
                            types.add("Number");
                            types.add("Decimal");
                            types.add("Boolean");
                            types.add("DateTime");
                            List bos = BusinessObjectEditor.this.bo.getBusinessObjectSet().getBusinessObjects();
                            for (IBusinessObject b : bos) {
                                if (b.equals(BusinessObjectEditor.this.bo)) continue;
                                types.add(b.getName());
                            }
                            btd.setTypes(types);
                            int d = btd.open();
                            if (d != 0 || (basePrim = FieldType.Primitive.find((String)btd.getBaseType())) == null) break block13;
                            fr.type = new FieldType(prim, basePrim);
                            break block13;
                        }
                        fr.type = new FieldType(prim);
                        break block13;
                    }
                    List bos = BusinessObjectEditor.this.bo.getBusinessObjectSet().getBusinessObjects();
                    for (IBusinessObject b : bos) {
                        if (!b.getName().equals(selectedType)) continue;
                        fr.type = new FieldType(b);
                        break;
                    }
                }
                BusinessObjectEditor.this.fireModified();
            }
            BusinessObjectEditor.this.viewer.refresh(true);
        }
    }

    public class FieldContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return BusinessObjectEditor.this.fieldRecords.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class FieldLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        Color alternateBackground;
        Color background;
        Color foreground;

        public FieldLabelProvider() {
            this.alternateBackground = new Color((Device)BusinessObjectEditor.this.viewer.getControl().getDisplay(), 216, 238, 255);
            this.background = BusinessObjectEditor.this.viewer.getControl().getDisplay().getSystemColor(1);
            this.foreground = BusinessObjectEditor.this.viewer.getControl().getDisplay().getSystemColor(2);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            FieldRecord fr = (FieldRecord)element;
            if (columnIndex == 0) {
                if (fr.secured) {
                    return Activator.getDefault().getImageRegistry().get("ICON_LOCK");
                }
            } else if (columnIndex == 1) {
                return Activator.getDefault().getImageRegistry().get("ICON_TINY_SQUARE");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            FieldRecord fr = (FieldRecord)element;
            if (columnIndex == 0) {
                return "";
            }
            if (columnIndex == 1) {
                return fr.name;
            }
            if (columnIndex == 2) {
                StringBuilder builder = new StringBuilder(fr.type.isObject() ? fr.type.getObjectType().getName() : fr.type.getPrimitiveType().getName());
                if (fr.type.hasBaseType()) {
                    builder.append(" <");
                    if (fr.type.isObjectBaseType()) {
                        builder.append(fr.type.getObjectBaseType().getName());
                    } else {
                        builder.append(fr.type.getPrimitiveBaseType().getName());
                    }
                    builder.append(">");
                }
                return builder.toString();
            }
            if (columnIndex == 3) {
                if (!fr.type.isObject() && fr.type.getPrimitiveType().hasPrecision()) {
                    if (fr.type.getPrecision() == 0) {
                        return "Single";
                    }
                    if (fr.type.getPrecision() == 1) {
                        return "Double";
                    }
                    if (fr.type.getPrecision() == 2) {
                        return "Absolute";
                    }
                }
                return "";
            }
            if (columnIndex == 4) {
                return fr.initialValue == null ? "" : fr.initialValue;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.alternateBackground.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getForeground(Object element) {
            return this.foreground;
        }

        public Color getBackground(Object element) {
            Color bg = null;
            int i = 0;
            while (i < BusinessObjectEditor.this.fieldRecords.size()) {
                if (BusinessObjectEditor.this.fieldRecords.get(i).equals(element)) {
                    if (i % 2 == 0) {
                        bg = this.background;
                        break;
                    }
                    bg = this.alternateBackground;
                    break;
                }
                ++i;
            }
            return bg;
        }
    }

    public class FieldRecord {
        String name;
        FieldType type;
        String initialValue;
        boolean secured = false;
    }
}

