/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.model;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModelListener;
import org.eclipse.vtp.desktop.editors.core.model.SelectionResult;
import org.eclipse.vtp.desktop.editors.core.model.SelectionStructure;
import org.eclipse.vtp.desktop.editors.core.model.UndoSystem;
import org.eclipse.vtp.desktop.editors.themes.core.ComponentFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ComponentFrameListener;
import org.eclipse.vtp.desktop.editors.themes.core.ConnectorFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ElementFrame;
import org.eclipse.vtp.desktop.editors.themes.core.Theme;
import org.eclipse.vtp.desktop.editors.themes.core.ThemeManager;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponent;
import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.ModelListener;
import org.eclipse.vtp.desktop.model.core.internal.DesignDocument;
import org.eclipse.vtp.desktop.model.core.internal.DesignWriter;
import org.eclipse.vtp.desktop.model.core.internal.IDesignFilter;
import org.eclipse.vtp.desktop.model.core.internal.PartialDesignDocument;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.eclipse.vtp.desktop.model.core.internal.design.DesignElement;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RenderedModel
implements ComponentFrameListener,
ModelListener {
    private IDesign uiModel;
    private List<RenderedModelListener> listeners = new ArrayList<RenderedModelListener>();
    private List<ElementFrame> elementFrames;
    private List<ConnectorFrame> connectorFrames;
    private SelectionStructure selection = null;
    private Theme theme = ThemeManager.getDefault().getCurrentTheme();
    private UndoSystem undoSystem = null;
    private IUndoContext undoContext = IOperationHistory.GLOBAL_UNDO_CONTEXT;
    private boolean batchUpdate = false;
    private boolean adding = false;

    public RenderedModel(IDesign uiModel) {
        this.uiModel = uiModel;
        uiModel.addListener((ModelListener)this);
        this.elementFrames = new LinkedList<ElementFrame>();
        List uiElements = uiModel.getDesignElements();
        for (IDesignElement uiElement : uiElements) {
            ElementFrame elementFrame = this.theme.createElementFrame(uiElement);
            elementFrame.addListener((ComponentFrameListener)this);
            this.elementFrames.add(elementFrame);
        }
        this.connectorFrames = new LinkedList<ConnectorFrame>();
        List uiConnectors = uiModel.getDesignConnectors();
        for (IDesignConnector uiConnector : uiConnectors) {
            ElementFrame source = null;
            ElementFrame destination = null;
            for (ElementFrame ef : this.elementFrames) {
                if (ef.getDesignElement().getId().equals(uiConnector.getOrigin().getId())) {
                    source = ef;
                }
                if (ef.getDesignElement().getId().equals(uiConnector.getDestination().getId())) {
                    destination = ef;
                }
                if (source != null && destination != null) break;
            }
            ConnectorFrame connectorFrame = this.theme.createConnectorFrame(source, destination, uiConnector);
            connectorFrame.addListener((ComponentFrameListener)this);
            this.connectorFrames.add(connectorFrame);
        }
        this.selection = new SelectionStructure(this);
    }

    public void startBatchUpdate() {
        this.batchUpdate = true;
    }

    public void endBatchUpdate() {
        this.endBatchUpdate(true);
    }

    public void endBatchUpdate(boolean signal) {
        this.batchUpdate = false;
        if (signal) {
            this.fireChange();
        }
    }

    public void setUndoSystem(UndoSystem undoSystem) {
        this.undoSystem = undoSystem;
    }

    public IOperationHistory getOperationHistory() {
        return this.undoSystem.getOperationHistory();
    }

    public void setUndoContext(IUndoContext context) {
        this.undoContext = context == null ? IOperationHistory.GLOBAL_UNDO_CONTEXT : context;
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    public void enableUndo() {
        this.undoSystem.enableUndo();
    }

    public void disableUndo() {
        this.undoSystem.disableUndo();
    }

    public IDesign getUIModel() {
        return this.uiModel;
    }

    public void initializeGraphics(GC gc, Map<String, Object> resourceMap) {
        for (ElementFrame ef : this.elementFrames) {
            ef.initializeGraphics(gc, resourceMap);
        }
        for (ConnectorFrame cf : this.connectorFrames) {
            cf.initializeGraphics(gc, resourceMap);
        }
    }

    public ElementFrame findElementAt(int x, int y) {
        int i = this.elementFrames.size() - 1;
        while (i > -1) {
            ElementFrame df = this.elementFrames.get(i);
            if (df.touchesComponent(x, y)) {
                return df;
            }
            --i;
        }
        return null;
    }

    public ConnectorFrame findConnectorAt(int x, int y) {
        for (ConnectorFrame cf : this.connectorFrames) {
            if (!cf.touchesComponent(x, y)) continue;
            return cf;
        }
        return null;
    }

    public ComponentFrame findComponentAt(int x, int y) {
        ElementFrame cf = this.findElementAt(x, y);
        if (cf == null) {
            cf = this.findConnectorAt(x, y);
        }
        return cf;
    }

    public ElementFrame addElement(DesignElement element, int x, int y) {
        this.adding = true;
        this.uiModel.addDesignElement((IDesignElement)element);
        this.adding = false;
        element.setCenterPoint(x, y);
        ElementFrame ret = this.theme.createElementFrame((IDesignElement)element);
        ret.addListener((ComponentFrameListener)this);
        this.elementFrames.add(ret);
        this.fireChange();
        return ret;
    }

    public ConnectorFrame connectElements(ElementFrame source, ElementFrame destination) {
        this.adding = true;
        IDesignConnector connector = this.uiModel.createDesignConnector(source.getDesignElement(), destination.getDesignElement());
        this.adding = false;
        ConnectorFrame ret = this.theme.createConnectorFrame(source, destination, connector);
        ret.addListener((ComponentFrameListener)this);
        this.connectorFrames.add(ret);
        this.fireChange();
        return ret;
    }

    public void paintCanvas(GC gc, Map<String, Object> resourceMap, int flags) {
        for (ConnectorFrame cf : this.connectorFrames) {
            cf.renderFrame(gc, 0, flags, resourceMap);
        }
        for (ElementFrame ef : this.elementFrames) {
            ef.renderFrame(gc, 0, flags, resourceMap);
        }
    }

    public SelectionResult selectAt(int x, int y, boolean additive) {
        ComponentFrame cof = this.findComponentAt(x, y);
        return this.selection.select(cof, additive);
    }

    public void selectRegion(Rectangle rect, boolean additive) {
        LinkedList<ElementFrame> selectList = new LinkedList<ElementFrame>();
        for (ElementFrame ef : this.elementFrames) {
            if (!ef.touchesElement(rect)) continue;
            selectList.add(ef);
        }
        this.selection.select(selectList, additive);
    }

    public void selectPartialDocument(PartialDesignDocument pdd) {
        this.selection.clear();
        block0: for (IDesignElement de : pdd.getMainDesign().getDesignElements()) {
            for (ElementFrame ef : this.elementFrames) {
                if (!ef.getDesignComponent().getId().equals(de.getId())) continue;
                this.selection.select((ComponentFrame)ef, true);
                continue block0;
            }
        }
        if (pdd.getMainDesign().getDesignElements().size() == 0 && pdd.getMainDesign().getDesignConnectors().size() > 0) {
            for (ConnectorFrame ef : this.connectorFrames) {
                if (!ef.getDesignComponent().getId().equals(((IDesignConnector)pdd.getMainDesign().getDesignConnectors().get(0)).getId())) continue;
                this.selection.select((ComponentFrame)ef, true);
                return;
            }
        }
    }

    public void select(ComponentFrame componentFrame, boolean additive) {
        this.selection.select(componentFrame, additive);
    }

    public SelectionStructure getSelection() {
        return this.selection;
    }

    public void deleteSelectedItems() {
        try {
            IDesignDocument designDocument = this.uiModel.getDocument();
            Document document = this.getSelectionDocument(true);
            PartialDesignDocument pdd = new PartialDesignDocument(designDocument, (Design)this.uiModel, document);
            DeleteOperation delo = new DeleteOperation(pdd);
            delo.addContext(this.undoContext);
            this.getOperationHistory().execute((IUndoableOperation)delo, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postAddedItem() {
        try {
            IDesignDocument designDocument = this.uiModel.getDocument();
            Document document = this.getSelectionDocument(true);
            PartialDesignDocument pdd = new PartialDesignDocument(designDocument, (Design)this.uiModel, document);
            AddComponentOperation delo = new AddComponentOperation(pdd);
            delo.addContext(this.undoContext);
            this.getOperationHistory().execute((IUndoableOperation)delo, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    Document getSelectionDocument(boolean includeTertiaryConnectors) {
        IDesignFilter selectionFilter = new IDesignFilter(includeTertiaryConnectors){
            List<IDesignComponent> components = new ArrayList<IDesignComponent>();
            {
                for (ComponentFrame cf : RenderedModel.this.selection.getSelectedItems()) {
                    this.components.add(cf.getDesignComponent());
                }
                for (ComponentFrame cf : RenderedModel.this.selection.getSecondarySelectedItems()) {
                    this.components.add(cf.getDesignComponent());
                }
                if (bl) {
                    for (ComponentFrame cf : RenderedModel.this.selection.getTertiarySelectedItems()) {
                        this.components.add(cf.getDesignComponent());
                    }
                }
            }

            public boolean matches(IDesignComponent component) {
                for (IDesignComponent dc : this.components) {
                    if (!dc.getId().equals(component.getId())) continue;
                    return true;
                }
                return false;
            }
        };
        try {
            DesignWriter writer = new DesignWriter();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "design-fragment", null);
            Element rootElement = document.getDocumentElement();
            rootElement.setAttribute("xml-version", "4.0.0");
            IDesignDocument designDocument = this.getUIModel().getDocument();
            if (!this.uiModel.equals(designDocument.getMainDesign())) {
                rootElement.setAttribute("dialog-only", "true");
                writer.writeDesign(rootElement, (Design)this.uiModel, selectionFilter);
            } else {
                writer.writeDesign(rootElement, (Design)designDocument.getMainDesign(), selectionFilter);
                Element dialogsElement = rootElement.getOwnerDocument().createElement("dialogs");
                rootElement.appendChild(dialogsElement);
                block2: for (IDesign dialogDesign : designDocument.getDialogDesigns()) {
                    List<ComponentFrame> items = this.selection.getSelectedItems();
                    for (ComponentFrame cf : items) {
                        if (!cf.getDesignComponent().getId().equals(dialogDesign.getDesignId())) continue;
                        writer.writeDesign(dialogsElement, (Design)dialogDesign);
                        continue block2;
                    }
                }
            }
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void copySelectedItems(Clipboard clipboard) {
        try {
            Document document = this.getSelectionDocument(false);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory transfactory = TransformerFactory.newInstance();
            Transformer t = transfactory.newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            t.transform(new DOMSource(document), new XMLWriter((OutputStream)baos).toXMLResult());
            clipboard.setContents(new Object[]{baos.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<ConnectorFrame> getConnectorFrames() {
        return Collections.unmodifiableList(this.connectorFrames);
    }

    public List<ElementFrame> getElementFrames() {
        return Collections.unmodifiableList(this.elementFrames);
    }

    public void componentFrameChanged(ComponentFrame componentFrame) {
        if (!this.batchUpdate) {
            this.fireChange();
        }
    }

    public void addListener(RenderedModelListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(RenderedModelListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChange() {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).renderedModelChanged(this);
            ++i;
        }
    }

    protected void fireFormatChange() {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).renderedModelFormatChanged(this);
            ++i;
        }
    }

    public void componentFrameDeleted(ComponentFrame componentFrame) {
        System.out.println("component frame deleted: " + componentFrame.getDesignComponent().getId());
        if (componentFrame instanceof ElementFrame) {
            this.elementFrames.remove(componentFrame);
        } else {
            this.connectorFrames.remove(componentFrame);
        }
    }

    public void componentFrameRepaintRequested(ComponentFrame componentFrame) {
        this.selection.validateSelection();
        this.fireChange();
    }

    public void orientationChanged(IDesign canvas) {
        for (ElementFrame elementFrame : this.elementFrames) {
            Rectangle bounds = elementFrame.getBounds();
            int xoff = 0;
            int yoff = 0;
            if (bounds.x + bounds.width > canvas.getWidth()) {
                xoff = canvas.getWidth() - (bounds.x + bounds.width + 5);
            }
            if (bounds.y + bounds.height > canvas.getHeight()) {
                yoff = canvas.getHeight() - (bounds.y + bounds.height + 5);
            }
            if (xoff == 0 && yoff == 0) continue;
            elementFrame.adjustPosition(xoff, yoff);
        }
        this.selection.validateSelection();
        this.fireFormatChange();
    }

    public void paperSizeChanged(IDesign canvas) {
        for (ElementFrame elementFrame : this.elementFrames) {
            Rectangle bounds = elementFrame.getBounds();
            int xoff = 0;
            int yoff = 0;
            if (bounds.x + bounds.width > canvas.getWidth()) {
                xoff = canvas.getWidth() - (bounds.x + bounds.width + 5);
            }
            if (bounds.y + bounds.height > canvas.getHeight()) {
                yoff = canvas.getHeight() - (bounds.y + bounds.height + 5);
            }
            if (xoff == 0 && yoff == 0) continue;
            elementFrame.adjustPosition(xoff, yoff);
        }
        this.selection.validateSelection();
        this.fireFormatChange();
    }

    public void nameChanged(IDesign design) {
        this.fireChange();
    }

    public void componentAdded(IDesign model, IDesignComponent component) {
        if (!this.adding) {
            if (component instanceof IDesignElement) {
                ElementFrame elementFrame = this.theme.createElementFrame((IDesignElement)component);
                elementFrame.addListener((ComponentFrameListener)this);
                this.elementFrames.add(elementFrame);
            } else {
                IDesignConnector uiConnector = (IDesignConnector)component;
                ElementFrame source = null;
                ElementFrame destination = null;
                for (ElementFrame ef : this.elementFrames) {
                    if (ef.getDesignElement().getId().equals(uiConnector.getOrigin().getId())) {
                        source = ef;
                    }
                    if (ef.getDesignElement().getId().equals(uiConnector.getDestination().getId())) {
                        destination = ef;
                    }
                    if (source != null && destination != null) break;
                }
                ConnectorFrame connectorFrame = this.theme.createConnectorFrame(source, destination, uiConnector);
                connectorFrame.addListener((ComponentFrameListener)this);
                this.connectorFrames.add(connectorFrame);
            }
            this.fireChange();
        }
    }

    public void componentRemoved(IDesign model, IDesignComponent component) {
        System.out.println("component removed: " + component.getId());
    }

    public class AddComponentOperation
    extends AbstractOperation {
        PartialDesignDocument pdd;

        public AddComponentOperation(PartialDesignDocument pdd) {
            super("Add");
            this.pdd = null;
            this.pdd = pdd;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            System.out.println("undoing add operation");
            PartialDesignDocument clone = this.pdd.clone();
            ((DesignDocument)RenderedModel.this.uiModel.getDocument()).merge(RenderedModel.this.uiModel, clone, false);
            RenderedModel.this.selectPartialDocument(clone);
            RenderedModel.this.fireChange();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            System.out.println("redoing add operation");
            ((DesignDocument)RenderedModel.this.uiModel.getDocument()).reverse(RenderedModel.this.uiModel, this.pdd.clone());
            RenderedModel.this.selection.clear();
            RenderedModel.this.fireChange();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    public class DeleteOperation
    extends AbstractOperation {
        PartialDesignDocument pdd;

        public DeleteOperation(PartialDesignDocument pdd) {
            super("Delete");
            this.pdd = null;
            this.pdd = pdd;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ((DesignDocument)RenderedModel.this.uiModel.getDocument()).reverse(RenderedModel.this.uiModel, this.pdd.clone());
            RenderedModel.this.selection.clear();
            RenderedModel.this.fireChange();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            System.out.println("redoing delete operation");
            ((DesignDocument)RenderedModel.this.uiModel.getDocument()).reverse(RenderedModel.this.uiModel, this.pdd.clone());
            RenderedModel.this.selection.clear();
            RenderedModel.this.fireChange();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            System.out.println("undoing delete operation");
            PartialDesignDocument clone = this.pdd.clone();
            ((DesignDocument)RenderedModel.this.uiModel.getDocument()).merge(RenderedModel.this.uiModel, clone, false);
            RenderedModel.this.selectPartialDocument(clone);
            RenderedModel.this.fireChange();
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    public class ThemeListener
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            event.getProperty().equals("CurrentTheme");
        }
    }
}

