/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.editors.core.widgets.RowDivider;

public class UIHelper {
    public static Composite createWrapperComposite(Composite parent) {
        return UIHelper.createWrapperComposite(parent, 20);
    }

    public static Composite createWrapperComposite(Composite parent, int indent) {
        Composite containerComp = new Composite(parent, 0);
        containerComp.setBackground(parent.getBackground());
        GridData gridData = new GridData(802);
        gridData.horizontalIndent = indent;
        gridData.widthHint = 150;
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        containerComp.setLayout((Layout)gl);
        containerComp.setLayoutData((Object)gridData);
        return containerComp;
    }

    public static Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 30;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public static RowDivider createRowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 50;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    public static Combo createValueDropDown(Composite parent) {
        Combo ret = new Combo(parent, 2060);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public static Text createValueText(Composite parent) {
        return UIHelper.createValueText(parent, 50);
    }

    public static Text createValueText(Composite parent, int width) {
        Text ret = new Text(parent, 2052);
        GridData gd = new GridData(768);
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = width;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public static Text createValuePlaceHolder(Composite parent) {
        Text ret = new Text(parent, 2052);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setVisible(false);
        ret.setEnabled(false);
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public static Text createValueTextArea(Composite parent) {
        Text ret = new Text(parent, 2818);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.heightHint = 75;
        gd.widthHint = 225;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public static Text createValuePassword(Composite parent) {
        Text ret = new Text(parent, 0x400804);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public static Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 2048);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public static Slider createValueSlider(Composite parent, int min, int max, String leftName, String rightName) {
        Composite sliderComp = new Composite(parent, 0);
        sliderComp.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        sliderComp.setLayoutData((Object)gd);
        sliderComp.setLayout((Layout)new FormLayout());
        Label leftLabel = new Label(sliderComp, 0);
        leftLabel.setBackground(sliderComp.getBackground());
        leftLabel.setText(leftName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        leftLabel.setLayoutData((Object)fd);
        Label rightLabel = new Label(sliderComp, 0);
        rightLabel.setBackground(sliderComp.getBackground());
        rightLabel.setText(rightName);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        rightLabel.setLayoutData((Object)fd);
        Slider ret = new Slider(sliderComp, 256);
        ret.setMinimum(min);
        ret.setMaximum(max);
        fd = new FormData();
        fd.left = new FormAttachment((Control)leftLabel, 0, 16384);
        fd.right = new FormAttachment((Control)rightLabel, 0, 131072);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)leftLabel, -3);
        fd.width = 150;
        ret.setLayoutData((Object)fd);
        return ret;
    }
}

