/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.widgets;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.core.custom.ToggleButton;
import org.eclipse.vtp.desktop.editors.core.widgets.ValueControl;
import org.eclipse.vtp.desktop.editors.core.widgets.ValueStackListener;
import org.eclipse.vtp.desktop.model.core.design.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BindingItem;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BrandBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PropertyBindingItem;

public class ValueStack
implements ToggleButton.ToggleButtonListener {
    private String settingName = null;
    private StackLayout stackLayout = null;
    private Composite mainComp = null;
    private Composite stackComp = null;
    private Composite staticComp = null;
    private Label staticValue = null;
    private Composite valueComp = null;
    private ValueControl valueControl = null;
    private Composite variableComp = null;
    private Combo variableCombo = null;
    private Composite expressionComp = null;
    private Text expressionText = null;
    private Composite buttonComp = null;
    private ToggleButton defaultButton = null;
    private ToggleButton staticButton = null;
    private ToggleButton variableButton = null;
    private ToggleButton expressionButton = null;
    private BrandBinding setting = null;
    private List<ValueStackListener> listeners = new LinkedList<ValueStackListener>();
    private String ultimateDefault = "";
    private List<Variable> variables = new ArrayList<Variable>();

    public ValueStack(String settingName, String ultimateDefault, List<Variable> variables) {
        this.settingName = settingName;
        this.ultimateDefault = ultimateDefault;
        this.variables = variables;
    }

    public void createControls(Composite parent) {
        this.mainComp = new Composite(parent, 0);
        this.mainComp.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.mainComp.setLayout((Layout)gridLayout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        this.mainComp.setLayoutData((Object)gd);
        this.stackComp = new Composite(this.mainComp, 0);
        this.stackComp.setBackground(parent.getDisplay().getSystemColor(6));
        this.stackLayout = new StackLayout();
        this.stackComp.setLayout((Layout)this.stackLayout);
        this.stackComp.setLayoutData((Object)new GridData(768));
        this.staticComp = new Composite(this.stackComp, 0);
        this.staticComp.setBackground(parent.getBackground());
        gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 4;
        this.staticComp.setLayout((Layout)gridLayout);
        this.staticValue = new Label(this.staticComp, 0);
        this.staticValue.setBackground(parent.getBackground());
        gd = new GridData(1808);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 4;
        this.staticValue.setLayoutData((Object)gd);
        this.staticValue.setAlignment(131072);
        this.staticValue.setText("null");
        this.valueComp = new Composite(this.stackComp, 0);
        this.valueComp.setBackground(parent.getBackground());
        gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 4;
        this.valueComp.setLayout((Layout)gridLayout);
        this.variableComp = new Composite(this.stackComp, 0);
        this.variableComp.setBackground(parent.getBackground());
        gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 4;
        this.variableComp.setLayout((Layout)gridLayout);
        this.variableCombo = new Combo(this.variableComp, 12);
        for (Variable var : this.variables) {
            this.addVariable((ObjectDefinition)var);
        }
        this.variableCombo.select(0);
        gd = new GridData(1808);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 4;
        this.variableCombo.setLayoutData((Object)gd);
        this.expressionComp = new Composite(this.stackComp, 0);
        this.expressionComp.setBackground(parent.getBackground());
        gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 4;
        this.expressionComp.setLayout((Layout)gridLayout);
        this.expressionText = new Text(this.expressionComp, 2052);
        gd = new GridData(1808);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 4;
        this.expressionText.setLayoutData((Object)gd);
        this.stackLayout.topControl = this.staticComp;
        this.buttonComp = new Composite(this.mainComp, 0);
        this.buttonComp.setBackground(parent.getBackground());
        gridLayout = new GridLayout(4, true);
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.buttonComp.setLayout((Layout)gridLayout);
        this.buttonComp.setLayoutData((Object)new GridData());
        GridData gridData = null;
        this.staticButton = new ToggleButton(this.buttonComp);
        this.staticButton.setBackground(parent.getBackground());
        this.staticButton.setText("S");
        gridData = new GridData();
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        this.staticButton.setLayoutData((Object)gridData);
        this.staticButton.setToggleDownOnly(true);
        this.staticButton.addSelectionListener((ToggleButton.ToggleButtonListener)this);
        this.variableButton = new ToggleButton(this.buttonComp);
        this.variableButton.setBackground(parent.getBackground());
        this.variableButton.setText("V");
        gridData = new GridData();
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        this.variableButton.setLayoutData((Object)gridData);
        this.variableButton.setSelected(true);
        this.variableButton.setToggleDownOnly(true);
        this.variableButton.addSelectionListener((ToggleButton.ToggleButtonListener)this);
        this.expressionButton = new ToggleButton(this.buttonComp);
        this.expressionButton.setBackground(parent.getBackground());
        this.expressionButton.setText("E");
        gridData = new GridData();
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        this.expressionButton.setLayoutData((Object)gridData);
        this.expressionButton.setSelected(true);
        this.expressionButton.setToggleDownOnly(true);
        this.expressionButton.addSelectionListener((ToggleButton.ToggleButtonListener)this);
        this.defaultButton = new ToggleButton(this.buttonComp);
        this.defaultButton.setBackground(parent.getBackground());
        this.defaultButton.setText("I");
        gridData = new GridData();
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        this.defaultButton.setLayoutData((Object)gridData);
        this.defaultButton.setSelected(true);
        this.defaultButton.setToggleDownOnly(true);
        this.defaultButton.addSelectionListener((ToggleButton.ToggleButtonListener)this);
        this.mainComp.layout(true, true);
        this.stackComp.layout(true, true);
    }

    public Composite getValueComposite() {
        return this.valueComp;
    }

    public void setValueControl(ValueControl valueControl) {
        this.valueControl = valueControl;
    }

    public String getSettingName() {
        return this.settingName;
    }

    public void setSetting(BrandBinding brandBinding) {
        GridLayout layout;
        if (this.setting != null) {
            this.save();
        }
        this.setting = brandBinding;
        if (!this.setting.hasParent()) {
            layout = (GridLayout)this.buttonComp.getLayout();
            layout.numColumns = 3;
            ((GridData)this.defaultButton.getLayoutData()).exclude = true;
            this.defaultButton.setVisible(false);
            this.mainComp.layout(true, true);
        } else {
            layout = (GridLayout)this.buttonComp.getLayout();
            layout.numColumns = 4;
            ((GridData)this.defaultButton.getLayoutData()).exclude = false;
            this.defaultButton.setVisible(true);
            this.mainComp.layout(true, true);
        }
        PropertyBindingItem pbi = (PropertyBindingItem)this.setting.getBindingItem();
        if (pbi == null && this.setting.isInherited()) {
            if (this.setting.hasParent()) {
                String value = this.ultimateDefault;
                this.staticValue.setText(value);
                this.stackLayout.topControl = this.staticComp;
                this.defaultButton.setSelected(true);
                this.staticButton.setSelected(false);
                this.variableButton.setSelected(false);
                this.expressionButton.setSelected(false);
                this.valueControl.setValue(value);
            } else {
                String value = this.ultimateDefault;
                this.valueControl.setValue(value);
                this.stackLayout.topControl = this.valueComp;
                this.defaultButton.setSelected(false);
                this.staticButton.setSelected(true);
                this.variableButton.setSelected(false);
                this.expressionButton.setSelected(false);
            }
        } else if (this.setting.isInherited()) {
            this.staticValue.setText(pbi.getValue());
            this.stackLayout.topControl = this.staticComp;
            this.defaultButton.setSelected(true);
            this.staticButton.setSelected(false);
            this.variableButton.setSelected(false);
            this.expressionButton.setSelected(false);
            this.valueControl.setValue(pbi.getValue());
        } else {
            this.staticValue.setText("");
            this.defaultButton.setSelected(false);
            if (pbi.getValueType().equals("static")) {
                this.stackLayout.topControl = this.valueComp;
                this.staticButton.setSelected(true);
                this.variableButton.setSelected(false);
                this.expressionButton.setSelected(false);
                this.valueControl.setValue(pbi.getValue());
            } else if (pbi.getValueType().equals("variable")) {
                this.stackLayout.topControl = this.variableComp;
                this.staticButton.setSelected(false);
                this.variableButton.setSelected(true);
                this.expressionButton.setSelected(false);
                this.variableCombo.select(0);
                int i = 0;
                while (i < this.variableCombo.getItemCount()) {
                    if (this.variableCombo.getItem(i).equals(pbi.getValue())) {
                        this.variableCombo.select(i);
                        break;
                    }
                    ++i;
                }
            } else {
                this.stackLayout.topControl = this.expressionComp;
                this.staticButton.setSelected(false);
                this.variableButton.setSelected(false);
                this.expressionButton.setSelected(true);
                this.expressionText.setText(pbi.getValue());
            }
        }
        this.mainComp.layout(true, true);
        this.stackComp.layout(true, true);
    }

    public void save() {
        if (this.defaultButton.isSelected()) {
            this.setting.setBindingItem(null);
        } else if (this.variableButton != null && this.variableButton.isSelected()) {
            PropertyBindingItem pbi = (PropertyBindingItem)this.setting.getBindingItem();
            if (pbi == null || this.setting.isInherited()) {
                pbi = new PropertyBindingItem();
            }
            pbi.setVariable(this.variableCombo.getItem(this.variableCombo.getSelectionIndex()));
            this.setting.setBindingItem((BindingItem)pbi);
        } else if (this.expressionButton != null && this.expressionButton.isSelected()) {
            PropertyBindingItem pbi = (PropertyBindingItem)this.setting.getBindingItem();
            if (pbi == null || this.setting.isInherited()) {
                pbi = new PropertyBindingItem();
            }
            pbi.setExpression(this.expressionText.getText());
            this.setting.setBindingItem((BindingItem)pbi);
        } else {
            PropertyBindingItem pbi = (PropertyBindingItem)this.setting.getBindingItem();
            if (pbi == null || this.setting.isInherited()) {
                pbi = new PropertyBindingItem();
            }
            pbi.setStaticValue(this.valueControl.getValue());
            this.setting.setBindingItem((BindingItem)pbi);
        }
    }

    public void toggleButtonSelected(ToggleButton button) {
        try {
            if (button == this.defaultButton) {
                PropertyBindingItem currentItem = (PropertyBindingItem)this.setting.getBindingItem();
                this.setting.setBindingItem(null);
                PropertyBindingItem inheritedItem = (PropertyBindingItem)this.setting.getBindingItem();
                this.staticValue.setText(inheritedItem == null ? this.ultimateDefault : inheritedItem.getValue());
                this.setting.setBindingItem((BindingItem)currentItem);
                this.stackLayout.topControl = this.staticComp;
                this.staticButton.setSelected(false);
                this.variableButton.setSelected(false);
                this.expressionButton.setSelected(false);
            } else if (button == this.variableButton) {
                this.stackLayout.topControl = this.variableComp;
                this.staticButton.setSelected(false);
                this.defaultButton.setSelected(false);
                this.expressionButton.setSelected(false);
            } else if (button == this.expressionButton) {
                this.stackLayout.topControl = this.expressionComp;
                this.staticButton.setSelected(false);
                this.variableButton.setSelected(false);
                this.defaultButton.setSelected(false);
            } else {
                this.stackLayout.topControl = this.valueComp;
                this.defaultButton.setSelected(false);
                this.variableButton.setSelected(false);
                this.expressionButton.setSelected(false);
            }
            this.mainComp.layout(true, true);
            this.stackComp.layout(true, true);
            this.fireTypeChange();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public String getValue() {
        if (this.defaultButton != null && this.defaultButton.isSelected()) {
            return this.staticValue.getText();
        }
        if (this.staticButton != null && this.staticButton.isSelected()) {
            return this.valueControl.getValue();
        }
        if (this.variableButton != null && this.variableButton.isSelected()) {
            return this.variableCombo.getItem(this.variableCombo.getSelectionIndex());
        }
        if (this.expressionButton != null && this.expressionButton.isSelected()) {
            return this.expressionText.getText();
        }
        return null;
    }

    private void fireTypeChange() {
        for (ValueStackListener listener : this.listeners) {
            listener.valueTypeChanged(this);
        }
    }

    public boolean isStaticValue() {
        return this.staticButton.isSelected();
    }

    public void addListener(ValueStackListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(ValueStackListener listener) {
        this.listeners.remove(listener);
    }

    private void addVariable(ObjectDefinition var) {
        if (var.getType().hasValue()) {
            this.variableCombo.add(var.getPath());
        } else {
            List fields = var.getFields();
            for (ObjectField field : fields) {
                this.addVariable((ObjectDefinition)field);
            }
        }
    }
}

