/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.themes.mantis;

import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.vtp.desktop.editors.themes.core.CanvasFrame;
import org.eclipse.vtp.desktop.model.core.design.IDesign;

public class MantisCanvasFrame
implements CanvasFrame {
    private IDesign uiCanvas;
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);

    public MantisCanvasFrame(IDesign uiCanvas) {
        this.uiCanvas = uiCanvas;
    }

    public Rectangle getInsets() {
        return new Rectangle(1, 1, 1, 1);
    }

    public void setBounds(Rectangle rect) {
        this.bounds = rect;
    }

    public void renderFrame(GC gc, int stage, int renderFlags, Map<String, Object> resourceMap) {
        Color darkGray;
        Color lightGray = (Color)resourceMap.get("LIGHT_GRAY");
        if (lightGray == null) {
            lightGray = new Color(gc.getDevice(), 204, 204, 204);
            resourceMap.put("LIGHT_GRAY", lightGray);
        }
        if ((darkGray = (Color)resourceMap.get("DARK_GRAY")) == null) {
            darkGray = new Color(gc.getDevice(), 128, 128, 128);
            resourceMap.put("DARK_GRAY", darkGray);
        }
        int w = this.uiCanvas.getWidth();
        int h = this.uiCanvas.getHeight();
        Color foreground = gc.getForeground();
        Color background = gc.getBackground();
        gc.setForeground(lightGray);
        gc.setBackground(darkGray);
        gc.fillGradientRectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, true);
        gc.setForeground(gc.getDevice().getSystemColor(2));
        Rectangle rect = new Rectangle((this.bounds.width - w) / 2 - 1, (this.bounds.height - h) / 2 - 1, w + 1, h + 1);
        gc.drawRectangle(rect);
        gc.setBackground(foreground);
        rect.x += 3;
        rect.y += 3;
        gc.fillRectangle(rect);
        gc.setForeground(foreground);
        gc.setBackground(background);
    }
}

