/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.themes.mantis;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.vtp.desktop.editors.themes.core.ComponentFrame;
import org.eclipse.vtp.desktop.editors.themes.core.ComponentFrameListener;
import org.eclipse.vtp.desktop.editors.themes.core.commands.Command;
import org.eclipse.vtp.desktop.editors.themes.core.commands.CommandListener;
import org.eclipse.vtp.desktop.editors.themes.core.commands.ShowProperties;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponent;
import org.eclipse.vtp.desktop.model.core.design.IDesignComponentListener;

public abstract class MantisComponentFrame
implements ComponentFrame,
IDesignComponentListener,
PropertyChangeListener {
    private List<ComponentFrameListener> listeners = new ArrayList<ComponentFrameListener>();
    private IDesignComponent uiComponent = null;

    protected MantisComponentFrame(IDesignComponent uiComponent) {
        this.uiComponent = uiComponent;
    }

    public IDesignComponent getDesignComponent() {
        return this.uiComponent;
    }

    public void addListener(ComponentFrameListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(ComponentFrameListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChange() {
        for (ComponentFrameListener listener : this.listeners) {
            listener.componentFrameChanged((ComponentFrame)this);
        }
    }

    protected void fireDelete() {
        for (ComponentFrameListener listener : this.listeners) {
            listener.componentFrameDeleted((ComponentFrame)this);
        }
    }

    public void componentChanged(IDesignComponent component) {
        this.fireChange();
    }

    public void mouseDoubleClick(CommandListener commandListener, int x, int y, int modifiers) {
        commandListener.executeCommand((Command)new ShowProperties());
    }

    public void componentDeleted(IDesignComponent component) {
        this.fireDelete();
    }

    protected void fireRepaintRequest() {
        for (ComponentFrameListener listener : this.listeners) {
            listener.componentFrameRepaintRequested((ComponentFrame)this);
        }
    }

    public void renderFrame(GC graphicsContext, int stage, int renderFlags, Map<String, Object> resourceMap) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    protected Color getColor(GC gc, Map<String, Object> resourceMap, String name, int r, int g, int b) {
        Object obj = resourceMap.get(name);
        if (obj == null) {
            obj = new Color(gc.getDevice(), r, g, b);
            resourceMap.put(name, obj);
        }
        return (Color)obj;
    }

    protected Font getFont(GC gc, Map<String, Object> resourceMap, String name, String fontName, int size, int style) {
        Object obj = resourceMap.get(name);
        if (obj == null) {
            obj = new Font(gc.getDevice(), fontName, size, style);
            resourceMap.put(name, obj);
        }
        return (Font)obj;
    }
}

