/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.voice.editor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.media.core.ContentDialog;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.ContentComposite;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;

public class VoiceContentDialog
extends ContentDialog
implements ModifyListener {
    private String itemName = "";
    private Set<String> unavailableNames = new HashSet<String>();
    private Text itemNameField = null;

    public VoiceContentDialog(Shell parentShell) {
        super(parentShell);
    }

    public VoiceContentDialog(IShellProvider parentShellProvider) {
        super(parentShellProvider);
    }

    public void initialize(String itemName, String[] unavailableNames, Content contentItem, IMediaProvider mediaProvider) {
        this.itemName = itemName == null ? "" : itemName;
        this.unavailableNames.addAll(Arrays.asList(unavailableNames));
        this.unavailableNames.remove(itemName);
        this.contents.clear();
        if (contentItem instanceof ContentComposite) {
            for (Content c : ((ContentComposite)contentItem).listContent()) {
                this.contents.add(c);
            }
        } else if (contentItem != null) {
            this.contents.add(contentItem);
        }
        this.setMediaProvider(mediaProvider);
    }

    public String getItemName() {
        return this.itemName;
    }

    public Content getContentItem() {
        if (this.contents.isEmpty()) {
            return null;
        }
        if (this.contents.size() == 1) {
            return (Content)this.contents.get(0);
        }
        ContentComposite composite = new ContentComposite();
        for (Content c : this.contents) {
            composite.addContent(c);
        }
        return composite;
    }

    protected boolean isContentValid() {
        return this.itemName.length() != 0 && !this.unavailableNames.contains(this.itemName) && !this.contents.isEmpty();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Item Name:");
        label.setLayoutData((Object)new GridData(1, 2, false, false));
        this.itemNameField = new Text(composite, 2048);
        this.itemNameField.setText(this.itemName);
        this.itemNameField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.itemNameField.addModifyListener((ModifyListener)this);
        Control child = super.createDialogArea(composite);
        child.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        return composite;
    }

    public void modifyText(ModifyEvent e) {
        this.itemName = this.itemNameField.getText();
        if (this.itemName == null) {
            this.itemName = "";
        }
        this.contentChanged();
    }
}

