/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.voice.editor;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.vtp.desktop.editors.voice.editor.SharedContentPage;
import org.eclipse.vtp.desktop.model.interactive.voice.internal.VoiceModel;

public class VoiceEditor
extends MultiPageEditorPart
implements Runnable,
IResourceChangeListener {
    private SharedContentPage sharedContentPage = new SharedContentPage();
    private VoiceModel model = null;
    private boolean dirty = false;

    public VoiceEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
        IFile descriptor = ((IFileEditorInput)editorInput).getFile();
        this.model = new VoiceModel(descriptor);
        try {
            this.model.load();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.model.addChangeObserver((Runnable)this);
    }

    public void dispose() {
        if (this.model != null) {
            this.model.removeChangeObserver((Runnable)this);
        }
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        finally {
            super.dispose();
        }
    }

    protected void createPages() {
        this.setPageText(this.addPage(this.sharedContentPage.initialize(this.getContainer(), this.model)), "Shared Content");
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.model.save(monitor);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        throw new IllegalStateException("Save as is not supported.");
    }

    @Override
    public void run() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = VoiceEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        ++i;
                    }
                }
            });
        }
    }
}

