/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.export.internal;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.vtp.desktop.export.internal.ExportAgent;
import org.eclipse.vtp.desktop.export.internal.ExportCore;
import org.eclipse.vtp.desktop.export.internal.MediaExporter;
import org.eclipse.vtp.desktop.export.internal.WorkflowExporter;

public class Exporter {
    private final Collection<ExportAgent> agents;
    private File archiveLocation = null;
    private boolean usingArchiveFile = false;
    private final Collection<MediaExporter> mediaSelection = new LinkedList<MediaExporter>();
    private final Collection<WorkflowExporter> workflowSelection = new LinkedList<WorkflowExporter>();
    private File mediaLocation = null;
    private boolean separateMedia = false;

    public Exporter(Collection<ExportAgent> agents) {
        this.agents = agents;
    }

    public File getArchiveLocation() {
        return this.archiveLocation;
    }

    public boolean isUsingArchiveFile() {
        return this.usingArchiveFile;
    }

    public boolean hasSeparateMedia() {
        return this.separateMedia;
    }

    public File getMediaLocation() {
        return this.mediaLocation;
    }

    public void setArchiveLocation(File archiveLocation, boolean usingArchiveFile) {
        this.archiveLocation = archiveLocation;
        this.usingArchiveFile = usingArchiveFile;
        this.reloadSettings();
    }

    public void setMediaLocation(File mediaLocation) {
        this.separateMedia = mediaLocation != null;
        this.mediaLocation = mediaLocation;
    }

    public Collection<MediaExporter> getMediaSelection() {
        return Collections.unmodifiableCollection(this.mediaSelection);
    }

    public Collection<WorkflowExporter> getWorkflowSelection() {
        return Collections.unmodifiableCollection(this.workflowSelection);
    }

    public void setProjectSelection(Collection<MediaExporter> mediaSelection, Collection<WorkflowExporter> workflowSelection) {
        this.mediaSelection.clear();
        this.workflowSelection.clear();
        this.mediaSelection.addAll(mediaSelection);
        this.workflowSelection.addAll(workflowSelection);
        this.reloadSettings();
        Collection<MediaExporter> ms = this.getMediaSelection();
        Collection<WorkflowExporter> ws = this.getWorkflowSelection();
        for (ExportAgent agent : this.agents) {
            agent.getValue().setProjects(ws, ms);
        }
    }

    public void reloadSettings() {
        for (WorkflowExporter workflowExporter : this.workflowSelection) {
            workflowExporter.loadSettings(this);
        }
        for (MediaExporter mediaExporter : this.mediaSelection) {
            mediaExporter.loadSettings(this);
        }
    }

    public Map<String, String> loadSettings(String projectName) {
        return ExportCore.loadSettings(this.preferencePrefix(), projectName);
    }

    public void saveSettings(String projectName, Map<String, String> settings) {
        ExportCore.saveSettings(this.preferencePrefix(), projectName, settings);
    }

    private String preferencePrefix() {
        return this.archiveLocation == null ? "" : this.archiveLocation.getAbsolutePath();
    }
}

