/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.export.internal.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.vtp.desktop.export.IConfigurationExporter;
import org.eclipse.vtp.desktop.export.IDefinitionBuilder;
import org.eclipse.vtp.desktop.export.IFlowElement;
import org.eclipse.vtp.desktop.export.IFlowModel;
import org.eclipse.vtp.desktop.export.internal.ExportCore;
import org.eclipse.vtp.desktop.export.internal.main.DesignReference;
import org.eclipse.vtp.desktop.media.core.FormatterRegistration;
import org.eclipse.vtp.desktop.media.core.FormatterRegistrationManager;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IWorkflowEntry;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.IDesignElementConnectionPoint;
import org.eclipse.vtp.desktop.model.core.design.IExitBroadcastReceiver;
import org.eclipse.vtp.desktop.model.interactive.core.content.ContentLoadingManager;
import org.eclipse.vtp.desktop.model.interactive.core.input.InputLoadingManager;
import org.eclipse.vtp.desktop.model.interactive.core.internal.mediadefaults.WorkspaceMediaDefaultSettings;
import org.eclipse.vtp.framework.common.configurations.BrandConfiguration;
import org.eclipse.vtp.framework.common.configurations.DataTypeConfiguration;
import org.eclipse.vtp.framework.common.configurations.FieldConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.LanguageConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaProviderBindingConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaProviderConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataItemConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputCase;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputContent;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputNode;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputSwitch;
import org.eclipse.vtp.framework.interactions.core.configurations.PropertyConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SharedContentConfiguration;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IInputGrammarFactory;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;
import org.eclipse.vtp.framework.util.Guid;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefinitionBuilder
implements IDefinitionBuilder {
    private final DesignReference[] callDesigns;
    private final DocumentBuilder builder;
    private final Document definition;
    private final Element servicesElement;
    private final Element actionsElement;
    private final Element observersElement;
    private final Element transitionsElement;
    private FlowModel mainModel = null;
    private Map<String, FlowModel> dialogModels = new HashMap<String, FlowModel>();
    private IWorkflowProject project;

    public DefinitionBuilder(DesignReference[] callDesigns, DocumentBuilder builder, IWorkflowProject project, Map<String, String> formatterIDsByLanguage, Map<String, String> resourceManagerIDsByLanguage, Map<String, List<String>> languageMapping) throws Exception {
        this.project = project;
        this.callDesigns = callDesigns;
        this.builder = builder;
        this.definition = builder.newDocument();
        Element definitionElement = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:definition");
        this.definition.appendChild(definitionElement);
        this.servicesElement = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:services");
        this.actionsElement = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:actions");
        this.observersElement = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:observers");
        this.transitionsElement = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:transitions");
        definitionElement.appendChild(this.servicesElement);
        definitionElement.appendChild(this.actionsElement);
        definitionElement.appendChild(this.observersElement);
        definitionElement.appendChild(this.transitionsElement);
        this.buildServices(project.getUnderlyingProject(), project.getBrandManager().getDefaultBrand(), formatterIDsByLanguage, resourceManagerIDsByLanguage, languageMapping);
        this.buildFlow(project.getWorkflowEntries());
    }

    public Document getDefinition() {
        return this.definition;
    }

    private void buildServices(IProject project, IBrand defaultBrand, Map<String, String> formatterIDsByLanguage, Map<String, String> resourceManagerIDsByLanguage, Map<String, List<String>> languageMapping) throws Exception {
        Element brandRegistryElement = this.newServiceElement("org.eclipse.vtp.framework.common.services.brand-registry");
        Element defaultBrandElement = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", "common:brand");
        BrandConfiguration defaultBrandConfiguration = new BrandConfiguration();
        defaultBrandConfiguration.setId(defaultBrand.getId());
        defaultBrandConfiguration.setName(defaultBrand.getName());
        this.buildBrandConfigurations(defaultBrand, defaultBrandConfiguration);
        defaultBrandConfiguration.save(defaultBrandElement);
        brandRegistryElement.appendChild(defaultBrandElement);
        Element dataTypeRegistryElement = this.newServiceElement("org.eclipse.vtp.framework.common.services.data-type-registry");
        IResource[] dataTypeFiles = project.getFolder("Business Objects").members();
        int i = 0;
        while (i < dataTypeFiles.length) {
            Document dataTypeDoc = this.builder.parse(dataTypeFiles[i].getLocation().toFile());
            Element dataTypeElement = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", "common:data-type");
            DataTypeConfiguration dataType = new DataTypeConfiguration();
            dataType.setName(dataTypeDoc.getDocumentElement().getAttribute("name"));
            if (dataTypeDoc.getDocumentElement().hasAttribute("primary")) {
                dataType.setPrimaryField(dataTypeDoc.getDocumentElement().getAttribute("primary"));
            }
            NodeList list = ((Element)dataTypeDoc.getDocumentElement().getElementsByTagName("fields").item(0)).getElementsByTagName("field");
            int j = 0;
            while (j < list.getLength()) {
                FieldConfiguration field = new FieldConfiguration();
                Element fieldElement = (Element)list.item(j);
                field.setName(fieldElement.getAttribute("name"));
                Element fieldTypeElement = (Element)fieldElement.getElementsByTagName("data-type").item(0);
                if (fieldTypeElement.getAttributeNode("type") == null) {
                    String style = ((Element)fieldTypeElement.getElementsByTagName("style").item(0)).getAttribute("value");
                    int styleBits = 0;
                    try {
                        styleBits = Integer.parseInt(style);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ((styleBits & 1) == 1) {
                        field.setType("Array");
                    } else {
                        String typeStr = XMLUtilities.getElementTextData((Element)((Element)fieldTypeElement.getElementsByTagName("type").item(0)), (boolean)true);
                        if ("DateTime".equals(typeStr)) {
                            typeStr = "Date";
                        }
                        field.setType(typeStr);
                    }
                } else {
                    String typeStr = fieldTypeElement.getAttribute("type");
                    if (typeStr.indexOf(58) != -1) {
                        typeStr = typeStr.substring(typeStr.indexOf(58) + 1);
                    }
                    if ("DateTime".equals(typeStr)) {
                        typeStr = "Date";
                    }
                    field.setType(typeStr);
                }
                if (fieldElement.getAttribute("initialValue").length() > 0) {
                    field.setInitialValue(fieldElement.getAttribute("initialValue"));
                }
                field.setSecured(Boolean.parseBoolean(fieldElement.getAttribute("secured")));
                dataType.addField(field);
                ++j;
            }
            dataType.save(dataTypeElement);
            dataTypeRegistryElement.appendChild(dataTypeElement);
            ++i;
        }
        Element languageRegistryElement = this.newServiceElement("org.eclipse.vtp.framework.interactions.core.services.language-registry");
        for (Map.Entry<String, List<String>> entry : languageMapping.entrySet()) {
            for (String lang : entry.getValue()) {
                Element languageElement = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "interactions:language");
                LanguageConfiguration language = new LanguageConfiguration();
                language.setID(lang);
                language.setInteractionType(entry.getKey());
                language.save(languageElement);
                languageRegistryElement.appendChild(languageElement);
            }
        }
        Element mediaProviderRegistryElement = this.newServiceElement("org.eclipse.vtp.framework.interactions.core.services.media-provider-registry");
        for (Map.Entry<String, String> entry : formatterIDsByLanguage.entrySet()) {
            String languageID = entry.getKey();
            String formatterID = entry.getValue();
            String resourceManagerID = resourceManagerIDsByLanguage.get(languageID);
            IFormatter formatter = null;
            FormatterRegistration reg = FormatterRegistrationManager.getInstance().getFormatter(formatterID);
            if (reg != null) {
                formatter = reg.getFormatter();
            }
            Element mediaProviderElement = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "interactions:media-provider");
            MediaProviderConfiguration mediaProvider = new MediaProviderConfiguration((IContentFactory)ContentLoadingManager.getInstance());
            mediaProvider.setID(resourceManagerID);
            mediaProvider.setFormatterID(formatterID);
            mediaProvider.setResourceManagerID(resourceManagerID);
            this.loadSharedContent(project, mediaProvider);
            mediaProvider.save(mediaProviderElement);
            mediaProviderRegistryElement.appendChild(mediaProviderElement);
            Element mediaProviderBindingElement = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "interactions:media-provider-binding");
            MediaProviderBindingConfiguration mediaProviderBinding = new MediaProviderBindingConfiguration();
            mediaProviderBinding.setKey(languageID);
            mediaProviderBinding.setMediaProviderID(mediaProvider.getID());
            mediaProviderBinding.save(mediaProviderBindingElement);
            mediaProviderRegistryElement.appendChild(mediaProviderBindingElement);
        }
    }

    private void loadSharedContent(IProject processProject, MediaProviderConfiguration mediaProvider) throws Exception {
        IProject voiceProject = processProject.getWorkspace().getRoot().getProject(mediaProvider.getResourceManagerID());
        IFile xmlFile = voiceProject.getFile("Voice.xml");
        String uri = "http://eclipse.org/vtp/xml/media/voice#1.0";
        if (!xmlFile.exists()) {
            xmlFile = voiceProject.getFile("Author.xml");
            uri = "http://eclipse.org/vtp/xml/media/author#1.0";
        }
        Document voiceDocument = this.builder.parse(xmlFile.getLocation().toFile());
        NodeList list = ((Element)voiceDocument.getDocumentElement().getElementsByTagNameNS(uri, "shared-content").item(0)).getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                Element element = (Element)list.item(i);
                ContentLoadingManager contentFactory = ContentLoadingManager.getInstance();
                SharedContentConfiguration sharedContent = new SharedContentConfiguration((IContentFactory)contentFactory);
                sharedContent.setName(element.getAttributeNS(uri, "item-name"));
                sharedContent.setContent(contentFactory.loadContent(element));
                mediaProvider.addSharedContent(sharedContent);
            }
            ++i;
        }
    }

    private void buildBrandConfigurations(IBrand brand, BrandConfiguration config) {
        for (IBrand child : brand.getChildBrands()) {
            BrandConfiguration childConfig = new BrandConfiguration();
            childConfig.setId(child.getId());
            childConfig.setName(child.getName());
            config.addChild(childConfig);
            this.buildBrandConfigurations(child, childConfig);
        }
    }

    private void buildFlow(List<IWorkflowEntry> entries) throws Exception {
        this.mainModel = new FlowModel();
        DesignReference[] designReferenceArray = this.callDesigns;
        int n = this.callDesigns.length;
        int n2 = 0;
        while (n2 < n) {
            DesignReference callDesign = designReferenceArray[n2];
            Element documentElement = callDesign.getXMLDocument().getDocumentElement();
            String xmlVersion = documentElement.getAttribute("xml-version");
            if (!xmlVersion.equals("4.0.0")) {
                throw new Exception("Incorrect model xml version.");
            }
            this.buildFlowModel(this.mainModel, (Element)((Element)documentElement.getElementsByTagName("workflow").item(0)).getElementsByTagName("model").item(0), 1, null);
            NodeList dialogs = ((Element)documentElement.getElementsByTagName("dialogs").item(0)).getElementsByTagName("workflow");
            int i = 0;
            while (i < dialogs.getLength()) {
                Element dialog = (Element)dialogs.item(i);
                FlowModel dialogModel = new FlowModel();
                this.buildFlowModel(dialogModel, (Element)dialog.getElementsByTagName("model").item(0), 3, dialog.getAttribute("id"));
                this.dialogModels.put(dialog.getAttribute("id"), dialogModel);
                ++i;
            }
            List<IDesignElement> receiverElements = this.gatherReceivers(callDesign.getDesignDocument());
            this.bindBroadcastReceivers(callDesign.getDesignDocument(), receiverElements);
            ++n2;
        }
        StringBuilder entryIds = new StringBuilder();
        for (IWorkflowEntry entry : entries) {
            this.mainModel.addEntry((FlowElement)this.mainModel.getElementsById().get(entry.getId()));
            entryIds.append(entry.getId()).append(',');
        }
        if (entryIds.length() > 0) {
            entryIds.setLength(entryIds.length() - 1);
        }
        this.definition.getDocumentElement().setAttribute("start", entryIds.toString());
        LinkedList<FlowElement> toProcess = new LinkedList<FlowElement>(this.mainModel.getEntryList());
        while (!toProcess.isEmpty()) {
            for (FlowElement element : toProcess.removeFirst().process()) {
                toProcess.addLast(element);
            }
        }
    }

    private FlowModel buildFlowModel(FlowModel flowModel, Element modelElement, int context, String dialogID) throws Exception {
        NodeList elements = ((Element)modelElement.getElementsByTagName("elements").item(0)).getChildNodes();
        int i = 0;
        while (i < elements.getLength()) {
            if (elements.item(i) instanceof Element) {
                NodeList propertiesElementList;
                Element element = (Element)elements.item(i);
                String id = element.getAttribute("id");
                String name = element.getAttribute("name");
                FlowElement flowElement = null;
                String elementType = element.getAttribute("type");
                Properties elementProperties = new Properties();
                if (context == 3) {
                    id = String.valueOf(dialogID) + ":" + id;
                    elementProperties.setProperty("DIALOG_ID", dialogID);
                }
                if ((propertiesElementList = element.getElementsByTagName("properties")).getLength() > 0) {
                    Element propertiesElement = (Element)propertiesElementList.item(0);
                    NodeList propertyElementList = propertiesElement.getElementsByTagName("property");
                    int pe = 0;
                    while (pe < propertyElementList.getLength()) {
                        Element propertyElement = (Element)propertyElementList.item(pe);
                        elementProperties.setProperty(propertyElement.getAttribute("name"), propertyElement.getAttribute("value"));
                        ++pe;
                    }
                }
                Element elementConfigurationElement = (Element)element.getElementsByTagName("configuration").item(0);
                System.err.println("Adding flow element: " + elementType);
                elementProperties.store(System.err, "");
                System.err.println();
                flowElement = new FlowElement(context, id, name, elementType, elementProperties, elementConfigurationElement);
                flowModel.addElement(flowElement);
            }
            ++i;
        }
        NodeList connectors = ((Element)modelElement.getElementsByTagName("connectors").item(0)).getElementsByTagName("connector");
        int i2 = 0;
        while (i2 < connectors.getLength()) {
            FlowElement origin;
            Element connector = (Element)connectors.item(i2);
            String originID = connector.getAttribute("origin");
            if (context == 3) {
                originID = String.valueOf(dialogID) + ":" + originID;
            }
            if ((origin = (FlowElement)flowModel.getElementsById().get(originID)) != null) {
                FlowElement destination;
                String destinationID = connector.getAttribute("destination");
                if (context == 3) {
                    destinationID = String.valueOf(dialogID) + ":" + destinationID;
                }
                if ((destination = (FlowElement)flowModel.getElementsById().get(destinationID)) != null) {
                    NodeList records = connector.getElementsByTagName("record");
                    int j = 0;
                    while (j < records.getLength()) {
                        origin.addResultPath(((Element)records.item(j)).getAttribute("sourcename"), destination);
                        ++j;
                    }
                }
            }
            ++i2;
        }
        return flowModel;
    }

    private List<IDesignElement> gatherReceivers(IDesignDocument document) {
        ArrayList<IDesignElement> list = new ArrayList<IDesignElement>();
        document.becomeWorkingCopy();
        for (IDesignElement element : document.getMainDesign().getDesignElements()) {
            if (element.getExitBroadcastReceivers().isEmpty()) continue;
            list.add(element);
            System.err.println("has receivers: " + element.getId() + ":" + element.getName());
        }
        return list;
    }

    private void bindBroadcastReceivers(IDesignDocument document, List<IDesignElement> elements) {
        document.becomeWorkingCopy();
        for (IDesignElement element : document.getMainDesign().getDesignElements()) {
            List records = element.getConnectorRecords();
            for (IDesignElementConnectionPoint point : records) {
                if (point.getDesignConnector() != null) continue;
                System.err.println("Disconnected exit: " + element.getId() + ":" + element.getName() + ":" + point.getName());
                for (IDesignElement receiverElement : elements) {
                    if (element.getId().equals(receiverElement.getId())) continue;
                    for (IExitBroadcastReceiver receiver : receiverElement.getExitBroadcastReceivers()) {
                        System.err.print("Matching: " + point.getName() + "->" + receiver.getExitPattern() + "...");
                        if (receiver.getExitPattern().equals(point.getName())) {
                            System.err.println("true");
                            IFlowElement origin = (IFlowElement)this.mainModel.flowElementsById.get(element.getId());
                            IFlowElement target = (IFlowElement)this.mainModel.flowElementsById.get(receiverElement.getId());
                            if (origin == null || target == null) continue;
                            ((FlowElement)origin).addResultPath(point.getName(), (FlowElement)target);
                            continue;
                        }
                        System.err.println("false");
                    }
                }
            }
        }
    }

    private Element newServiceElement(String serviceID) {
        Element element = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:service");
        element.setAttribute("id", serviceID);
        this.servicesElement.appendChild(element);
        return element;
    }

    private Element newActionElement(String actionID, String actionName, String actionDescriptorID) {
        Element element = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:action");
        element.setAttribute("id", actionID);
        element.setAttribute("name", actionName);
        element.setAttribute("descriptor-id", actionDescriptorID);
        this.actionsElement.appendChild(element);
        return element;
    }

    private Element newObserverElement(String observerID, String observerDescriptorID) {
        Element element = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:observer");
        element.setAttribute("id", observerID);
        element.setAttribute("descriptor-id", observerDescriptorID);
        this.observersElement.appendChild(element);
        return element;
    }

    private Element newAfterTransitionElement(String actionID, String path) {
        Element element = this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:after");
        element.setAttribute("action", actionID);
        element.setAttribute("path", path);
        this.transitionsElement.appendChild(element);
        return element;
    }

    @Override
    public FlowModel getDialogModel(String dialogId) {
        return this.dialogModels.get(dialogId);
    }

    @Override
    public FlowModel getMainModel() {
        return this.mainModel;
    }

    public class FlowElement
    implements IFlowElement {
        final String id;
        final String name;
        final Element configuration;
        final Map<String, FlowElement> resultPaths = new HashMap<String, FlowElement>();
        boolean processed = false;
        Properties properties = null;
        private int context = 0;
        private FlowModel model = null;
        private String elementType = null;
        IConfigurationExporter exporter = null;

        FlowElement(int context, String id, String name, String type, Properties properties, Element configuration) {
            this.context = context;
            this.id = id;
            this.name = name;
            this.properties = properties;
            this.configuration = configuration;
            this.elementType = type;
            this.exporter = ExportCore.getConfigurationExporter(this.elementType);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getContext() {
            return this.context;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public Element getConfiguration() {
            return this.configuration;
        }

        @Override
        public FlowModel getModel() {
            return this.model;
        }

        void setModel(FlowModel model) {
            this.model = model;
        }

        void addResultPath(String path, FlowElement next) {
            this.resultPaths.put(path, next);
        }

        @Override
        public FlowElement getResultPath(String path) {
            return this.resultPaths.get(path);
        }

        @Override
        public String getTargetID(Element afterTransitionElement) {
            if (this.exporter != null) {
                return this.exporter.getTargetId(this, afterTransitionElement);
            }
            return this.getDefaultTargetId(afterTransitionElement);
        }

        @Override
        public String getDefaultTargetId(Element afterTansitionElement) {
            return this.id;
        }

        final List<FlowElement> process() {
            if (this.processed) {
                return Collections.emptyList();
            }
            this.processed = true;
            this.buildAction();
            ArrayList<FlowElement> nextElements = new ArrayList<FlowElement>(this.resultPaths.size());
            for (Map.Entry<String, FlowElement> entry : this.resultPaths.entrySet()) {
                String designPath = entry.getKey();
                String processPath = this.mapResultPath(designPath);
                Element afterTrasition = DefinitionBuilder.this.newAfterTransitionElement(this.id, processPath);
                this.buildObservers(designPath, afterTrasition);
                String target = entry.getValue().getTargetID(afterTrasition);
                if (target == null) {
                    DefinitionBuilder.this.transitionsElement.removeChild(afterTrasition);
                    continue;
                }
                afterTrasition.setAttribute("target", target);
                Map<String, IFlowElement> flowElementsById = DefinitionBuilder.this.mainModel.getElementsById();
                if (target.indexOf(58) != -1) {
                    flowElementsById = ((FlowModel)DefinitionBuilder.this.dialogModels.get(target.substring(0, target.indexOf(58)))).getElementsById();
                }
                nextElements.add((FlowElement)flowElementsById.get(target));
            }
            return nextElements;
        }

        void buildAction() {
            String actionId;
            if (this.exporter != null && (actionId = this.exporter.getActionId(this)) != null) {
                Element actionElement = DefinitionBuilder.this.newActionElement(this.id, this.name, actionId);
                this.exporter.exportConfiguration(this, actionElement);
            }
        }

        public boolean isEntryPoint() {
            if (this.exporter != null) {
                return this.exporter.isEntryPoint(this);
            }
            return false;
        }

        @Override
        public void buildObservers(String designPath, Element afterTrasition) {
            NodeList itemList;
            String uri = "http://eclipse.org/vtp/xml/configuration/attacheddata";
            NodeList bindingsList = this.configuration.getElementsByTagName("managed-config");
            Element attachedData = null;
            int i = 0;
            while (attachedData == null && i < bindingsList.getLength()) {
                Element bindings = (Element)bindingsList.item(i);
                if (bindings.getAttribute("type").equals("org.eclipse.vtp.configuration.attacheddata")) {
                    itemList = bindings.getElementsByTagNameNS(uri, "attached-data-binding");
                    int j = 0;
                    while (attachedData == null && j < itemList.getLength()) {
                        Element item = (Element)itemList.item(j);
                        if (designPath.equals(item.getAttribute("name"))) {
                            attachedData = item;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (attachedData == null) {
                return;
            }
            String observerID = Guid.createGUID();
            MetaDataConfiguration config = new MetaDataConfiguration();
            itemList = attachedData.getElementsByTagNameNS(uri, "item");
            int count = 0;
            int i2 = 0;
            while (i2 < itemList.getLength()) {
                Element item = (Element)itemList.item(i2);
                NodeList entryList = item.getElementsByTagNameNS(uri, "entry");
                if (entryList.getLength() > 0) {
                    MetaDataItemConfiguration[] metaDataItems = new MetaDataItemConfiguration[entryList.getLength()];
                    int j = 0;
                    while (j < entryList.getLength()) {
                        Element entry = (Element)entryList.item(j);
                        MetaDataItemConfiguration metaDataItem = new MetaDataItemConfiguration();
                        metaDataItem.setName(entry.getAttribute("name"));
                        if ("variable".equalsIgnoreCase(entry.getAttribute("type"))) {
                            metaDataItem.setVariableValue(entry.getAttribute("value"));
                        } else if ("expression".equalsIgnoreCase(entry.getAttribute("type"))) {
                            metaDataItem.setExpressionValue(entry.getAttribute("value"), "JavaScript");
                        } else {
                            metaDataItem.setStaticValue(entry.getAttribute("value"));
                        }
                        metaDataItems[j] = metaDataItem;
                        ++j;
                    }
                    config.setItem(item.getAttribute("key"), metaDataItems);
                    ++count;
                }
                ++i2;
            }
            if (count == 0) {
                return;
            }
            Element observerElement = DefinitionBuilder.this.newObserverElement(observerID, "org.eclipse.vtp.framework.interactions.core.observers.meta-data-message");
            Element configElement = DefinitionBuilder.this.definition.createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "interactions:meta-data");
            config.save(configElement);
            observerElement.appendChild(configElement);
            Element notify = afterTrasition.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "process:notify");
            notify.setAttribute("observer", observerID);
            afterTrasition.appendChild(notify);
        }

        String mapResultPath(String input) {
            if (this.exporter != null) {
                if (input.equals(this.exporter.getDefaultPath(this))) {
                    return "default";
                }
                return this.exporter.translatePath(this, input);
            }
            return "Continue".equals(input) ? "default" : input;
        }

        @Override
        public MediaConfiguration loadMediaBindings(String elementTypeId) {
            NodeList managedConfigList = this.configuration.getElementsByTagName("managed-config");
            Element genericConfigElement = null;
            int i = 0;
            while (i < managedConfigList.getLength()) {
                Element managedConfigElement = (Element)managedConfigList.item(i);
                if (managedConfigElement.getAttribute("type").equals("org.eclipse.vtp.configuration.generic")) {
                    genericConfigElement = managedConfigElement;
                    break;
                }
                ++i;
            }
            if (genericConfigElement == null) {
                return null;
            }
            return this.loadMediaBindings(elementTypeId, genericConfigElement);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MediaConfiguration loadMediaBindings(String elementTypeId, Element genericConfigElement) {
            void var8_13;
            String interactionType;
            Object interactionBinding;
            void var8_9;
            MediaConfiguration result = new MediaConfiguration((IContentFactory)ContentLoadingManager.getInstance(), (IInputGrammarFactory)InputLoadingManager.getInstance());
            HashMap<String, OutputConfiguration> outputConfigurations = new HashMap<String, OutputConfiguration>();
            HashMap<String, InputConfiguration> inputConfigurations = new HashMap<String, InputConfiguration>();
            HashMap<String, PropertyConfiguration> propertyConfigurations = new HashMap<String, PropertyConfiguration>();
            NodeList interactionBindingList = genericConfigElement.getElementsByTagName("interaction-binding");
            boolean bl = false;
            while (var8_9 < interactionBindingList.getLength()) {
                interactionBinding = (Element)interactionBindingList.item((int)var8_9);
                interactionType = interactionBinding.getAttribute("type");
                NodeList namedBindingList = interactionBinding.getElementsByTagName("named-binding");
                int nb = 0;
                while (nb < namedBindingList.getLength()) {
                    Element namedBinding = (Element)namedBindingList.item(nb);
                    String bindingName = namedBinding.getAttribute("name");
                    NodeList languageBindingList = namedBinding.getElementsByTagName("language-binding");
                    int lb = 0;
                    while (lb < languageBindingList.getLength()) {
                        Element languageBinding = (Element)languageBindingList.item(lb);
                        String languageName = languageBinding.getAttribute("language");
                        NodeList brandBindingList = languageBinding.getElementsByTagName("brand-binding");
                        int bb = 0;
                        while (bb < brandBindingList.getLength()) {
                            Element brandBinding = (Element)brandBindingList.item(bb);
                            String brandName = brandBinding.getAttribute("name");
                            NodeList bindingItemList = brandBinding.getElementsByTagName("binding-item");
                            if (bindingItemList.getLength() > 0) {
                                Element bindingItemElement = (Element)bindingItemList.item(0);
                                String bindingItemType = bindingItemElement.getAttribute("type");
                                if ("org.eclipse.vtp.configuration.generic.items.prompt".equals(bindingItemType)) {
                                    OutputConfiguration outputConfig = (OutputConfiguration)outputConfigurations.get(bindingName);
                                    if (outputConfig == null) {
                                        outputConfig = new OutputConfiguration((IContentFactory)ContentLoadingManager.getInstance());
                                        outputConfigurations.put(bindingName, outputConfig);
                                    }
                                    outputConfig.setItem(String.valueOf(brandName) + interactionType + languageName, this.loadOutputNodesFrom(bindingItemElement));
                                }
                                if ("org.eclipse.vtp.configuration.generic.items.grammar".equals(bindingItemType)) {
                                    InputConfiguration inputConfig = (InputConfiguration)inputConfigurations.get(bindingName);
                                    if (inputConfig == null) {
                                        inputConfig = new InputConfiguration((IInputGrammarFactory)InputLoadingManager.getInstance());
                                        inputConfigurations.put(bindingName, inputConfig);
                                    }
                                    InputGrammar grammar = null;
                                    NodeList contents = bindingItemElement.getChildNodes();
                                    int k = 0;
                                    while (grammar == null && k < contents.getLength()) {
                                        if (contents.item(k) instanceof Element) {
                                            grammar = InputLoadingManager.getInstance().loadInput((Element)contents.item(k));
                                        }
                                        ++k;
                                    }
                                    if (grammar != null) {
                                        inputConfig.setItem(String.valueOf(brandName) + interactionType + languageName, grammar);
                                    }
                                }
                                if ("org.eclipse.vtp.configuration.generic.items.property".equals(bindingItemType)) {
                                    NodeList propertyValueList;
                                    PropertyConfiguration propertyConfig = (PropertyConfiguration)propertyConfigurations.get(bindingName);
                                    if (propertyConfig == null) {
                                        propertyConfig = new PropertyConfiguration();
                                        propertyConfigurations.put(bindingName, propertyConfig);
                                    }
                                    if ((propertyValueList = bindingItemElement.getElementsByTagName("property-value")).getLength() > 0) {
                                        Element propertyValueElement = (Element)propertyValueList.item(0);
                                        try {
                                            propertyConfig.setItem(String.valueOf(brandName) + interactionType + languageName, propertyValueElement.getAttribute("value-type"), XMLUtilities.getElementTextData((Element)propertyValueElement, (boolean)true));
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }
                            ++bb;
                        }
                        ++lb;
                    }
                    ++nb;
                }
                ++var8_9;
            }
            for (Map.Entry entry : outputConfigurations.entrySet()) {
                result.setOutputConfiguration((String)entry.getKey(), (OutputConfiguration)entry.getValue());
            }
            for (Map.Entry entry : inputConfigurations.entrySet()) {
                result.setInputConfiguration((String)entry.getKey(), (InputConfiguration)entry.getValue());
            }
            boolean bl2 = false;
            while (var8_13 < interactionBindingList.getLength()) {
                interactionBinding = (Element)interactionBindingList.item((int)var8_13);
                interactionType = interactionBinding.getAttribute("type");
                List names = WorkspaceMediaDefaultSettings.getInstance().getDefaultSettingNames(elementTypeId, interactionType);
                for (String name : names) {
                    System.err.print("Checking default value: " + name + "...");
                    String defaultSetting = WorkspaceMediaDefaultSettings.getInstance().getDefaultSetting(interactionType, elementTypeId, name).getValue();
                    System.err.println(defaultSetting);
                    if (defaultSetting == null) continue;
                    PropertyConfiguration propertyConfig = (PropertyConfiguration)propertyConfigurations.get(name);
                    System.err.println("Current property config: " + propertyConfig);
                    if (propertyConfig == null) {
                        propertyConfig = new PropertyConfiguration();
                        propertyConfigurations.put(name, propertyConfig);
                    }
                    PropertyConfiguration.Value item = propertyConfig.getItem("Default", interactionType);
                    System.err.println("Current property value: " + (item == null ? "null" : String.valueOf(item.getType()) + ":" + item.getValue()));
                    if (item != null) continue;
                    propertyConfig.setItem("Default", interactionType, "static", defaultSetting);
                }
                ++var8_13;
            }
            for (Map.Entry entry : propertyConfigurations.entrySet()) {
                result.setPropertyConfiguration((String)entry.getKey(), (PropertyConfiguration)entry.getValue());
            }
            return result;
        }

        private OutputNode[] loadOutputNodesFrom(Element element) {
            NodeList childElements = element.getChildNodes();
            LinkedList<Content> content = new LinkedList<Content>();
            LinkedList<Object> nodes = new LinkedList<Object>();
            int i = 0;
            while (i < childElements.getLength()) {
                if (childElements.item(i) instanceof Element) {
                    Element childElement = (Element)childElements.item(i);
                    if ("binding-branch".equals(childElement.getTagName())) {
                        if (!content.isEmpty()) {
                            OutputContent node = new OutputContent();
                            node.setContent(content.toArray(new Content[content.size()]));
                            content.clear();
                            nodes.add(node);
                        }
                        OutputSwitch switchNode = new OutputSwitch();
                        NodeList caseElements = childElement.getChildNodes();
                        ArrayList<OutputCase> cases = new ArrayList<OutputCase>(caseElements.getLength());
                        int j = 0;
                        while (j < caseElements.getLength()) {
                            if (caseElements.item(j) instanceof Element) {
                                Element caseElement = (Element)caseElements.item(j);
                                OutputCase caseNode = new OutputCase();
                                caseNode.setScript(caseElement.getAttribute("condition"));
                                caseNode.setScriptingLanguage("JavaScript");
                                caseNode.setNodes(this.loadOutputNodesFrom(caseElement));
                                cases.add(caseNode);
                            }
                            ++j;
                        }
                        switchNode.setCases(cases.toArray(new OutputCase[cases.size()]));
                        nodes.add(switchNode);
                    } else {
                        content.add(ContentLoadingManager.getInstance().loadContent(childElement));
                    }
                }
                ++i;
            }
            if (!content.isEmpty()) {
                OutputContent node = new OutputContent();
                node.setContent(content.toArray(new Content[content.size()]));
                content.clear();
                nodes.add(node);
            }
            return nodes.toArray(new OutputNode[nodes.size()]);
        }
    }

    public class FlowModel
    implements IFlowModel {
        private List<FlowElement> entries = new ArrayList<FlowElement>();
        private Map<String, IFlowElement> flowElementsById = new HashMap<String, IFlowElement>();
        private List<FlowElement> flowElements = new ArrayList<FlowElement>();

        public List<IFlowElement> getEntries() {
            return new ArrayList<IFlowElement>(this.entries);
        }

        public List<FlowElement> getEntryList() {
            return this.entries;
        }

        public void addEntry(FlowElement entry) {
            this.entries.add(entry);
        }

        @Override
        public Map<String, IFlowElement> getElementsById() {
            return this.flowElementsById;
        }

        public List<FlowElement> getElements() {
            return this.flowElements;
        }

        public void addElement(IFlowElement flowElement) {
            FlowElement old = null;
            old = (FlowElement)this.flowElementsById.put(flowElement.getId(), flowElement);
            if (old != null) {
                this.flowElements.remove(old);
                old.setModel(null);
            }
            FlowElement theFlowElement = (FlowElement)flowElement;
            this.flowElements.add(theFlowElement);
            theFlowElement.setModel(this);
            if (theFlowElement.isEntryPoint()) {
                this.entries.add(theFlowElement);
            }
        }

        @Override
        public DefinitionBuilder getDefinitionBuilder() {
            return DefinitionBuilder.this;
        }
    }
}

