/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.export.internal.main;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public abstract class ExportWriter
implements Closeable,
Flushable {
    private final byte[] buffer = new byte[10240];

    public static ExportWriter create(File file) throws IOException {
        if (file.isDirectory()) {
            return new DirectoryWriter(file);
        }
        return new ArchiveWriter(file);
    }

    public abstract OutputStream write(String var1) throws IOException;

    public abstract void writeStream(String var1, InputStream var2) throws IOException;

    public abstract void writeURL(String var1, URL var2) throws IOException;

    public abstract void writeFile(String var1, File var2, FilenameFilter var3) throws IOException;

    protected void copy(InputStream input, OutputStream output) throws IOException {
        int i = input.read(this.buffer);
        while (i >= 0) {
            output.write(this.buffer, 0, i);
            i = input.read(this.buffer);
        }
    }

    private static final class ArchiveWriter
    extends ExportWriter {
        private final ZipOutputStream output;
        private final Set<String> writtenEntries = new HashSet<String>();

        public ArchiveWriter(File archive) throws IOException {
            FileOutputStream fileOutput = new FileOutputStream(archive);
            boolean failed = true;
            try {
                this.output = new ZipOutputStream(new BufferedOutputStream(fileOutput));
                failed = false;
            }
            finally {
                if (failed) {
                    fileOutput.close();
                }
            }
        }

        @Override
        public OutputStream write(String entryName) throws IOException {
            this.writeParentEntries(entryName);
            this.startEntry(entryName, true);
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    ArchiveWriter.this.output.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    ArchiveWriter.this.output.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    ArchiveWriter.this.output.write(b, off, len);
                }

                @Override
                public void close() throws IOException {
                    ArchiveWriter.this.output.closeEntry();
                }
            };
        }

        @Override
        public void writeStream(String entryName, InputStream stream) throws IOException {
            this.writeParentEntries(entryName);
            this.startEntry(entryName, true);
            try {
                this.copy(stream, this.output);
            }
            finally {
                this.output.closeEntry();
            }
        }

        @Override
        public void writeURL(String entryName, URL url) throws IOException {
            this.writeParentEntries(entryName);
            this.startEntry(entryName, true);
            try {
                InputStream stream = url.openStream();
                try {
                    this.copy(new BufferedInputStream(stream), this.output);
                }
                finally {
                    stream.close();
                }
            }
            finally {
                this.output.closeEntry();
            }
        }

        @Override
        public void writeFile(String entryName, File file, FilenameFilter filter) throws IOException {
            block9: {
                File[] children;
                File canonical = file.getCanonicalFile();
                if (canonical.isFile()) {
                    this.writeParentEntries(entryName);
                    this.startEntry(entryName, true);
                    try {
                        FileInputStream stream = new FileInputStream(canonical);
                        try {
                            this.copy(new BufferedInputStream(stream), this.output);
                            break block9;
                        }
                        finally {
                            stream.close();
                        }
                    }
                    finally {
                        this.output.closeEntry();
                    }
                }
                File[] fileArray = children = filter == null ? canonical.listFiles() : canonical.listFiles(filter);
                if (children != null) {
                    File[] fileArray2 = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray2[n2];
                        this.writeFile(String.valueOf(entryName) + (child.isFile() ? child.getName() : String.valueOf(child.getName()) + "/"), child, filter);
                        ++n2;
                    }
                }
            }
        }

        @Override
        public void flush() throws IOException {
            this.output.flush();
        }

        @Override
        public void close() throws IOException {
            this.output.close();
        }

        private void writeParentEntries(String entryName) throws IOException {
            int lastSlash = entryName.lastIndexOf(47);
            if (lastSlash == entryName.length() - 1) {
                lastSlash = entryName.lastIndexOf(47, lastSlash - 1);
            }
            if (lastSlash < 0) {
                return;
            }
            String parentEntryName = entryName.substring(0, lastSlash + 1);
            this.writeParentEntries(parentEntryName);
            if (this.startEntry(parentEntryName, false)) {
                this.output.closeEntry();
            }
        }

        private boolean startEntry(String entryName, boolean failOnDuplicate) throws IOException {
            this.writeParentEntries(entryName);
            if (!this.writtenEntries.add(entryName)) {
                if (failOnDuplicate) {
                    throw new ZipException(String.format("An entry with the name \"%s\" already exisits.", entryName));
                }
                return false;
            }
            this.output.putNextEntry(new ZipEntry(entryName));
            return true;
        }
    }

    private static final class DirectoryWriter
    extends ExportWriter {
        private File directory;

        public DirectoryWriter(File directory) throws IOException {
            this.directory = directory;
        }

        @Override
        public OutputStream write(String entryName) throws IOException {
            File target = new File(this.directory, entryName).getCanonicalFile();
            File parent = target.getParentFile().getCanonicalFile();
            if (!parent.isDirectory() & !parent.mkdirs()) {
                throw new FileNotFoundException(parent.getAbsolutePath());
            }
            return new BufferedOutputStream(new FileOutputStream(target));
        }

        @Override
        public void writeStream(String entryName, InputStream stream) throws IOException {
            OutputStream output = this.write(entryName);
            try {
                this.copy(stream, output);
            }
            finally {
                output.close();
            }
        }

        @Override
        public void writeURL(String entryName, URL url) throws IOException {
            OutputStream output = this.write(entryName);
            try {
                InputStream stream = url.openStream();
                try {
                    this.copy(new BufferedInputStream(stream), output);
                }
                finally {
                    stream.close();
                }
            }
            finally {
                output.close();
            }
        }

        @Override
        public void writeFile(String entryName, File file, FilenameFilter filter) throws IOException {
            block9: {
                File[] children;
                File canonical = file.getCanonicalFile();
                if (canonical.isFile()) {
                    OutputStream output = this.write(entryName);
                    try {
                        FileInputStream stream = new FileInputStream(canonical);
                        try {
                            this.copy(new BufferedInputStream(stream), output);
                            break block9;
                        }
                        finally {
                            stream.close();
                        }
                    }
                    finally {
                        output.close();
                    }
                }
                File[] fileArray = children = filter == null ? canonical.listFiles() : canonical.listFiles(filter);
                if (children != null) {
                    File[] fileArray2 = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray2[n2];
                        this.writeFile(String.valueOf(entryName) + (child.isFile() ? child.getName() : String.valueOf(child.getName()) + "/"), child, filter);
                        ++n2;
                    }
                }
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
            this.directory = null;
        }
    }
}

