/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.export.internal.main;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.export.internal.ExportAgent;
import org.eclipse.vtp.desktop.export.internal.ExportCore;
import org.eclipse.vtp.desktop.export.internal.MediaExporter;
import org.eclipse.vtp.desktop.export.internal.ProjectExporter;
import org.eclipse.vtp.desktop.export.internal.WorkflowExporter;
import org.eclipse.vtp.desktop.export.internal.main.BundleExporter;
import org.eclipse.vtp.desktop.export.internal.main.DefinitionBuilder;
import org.eclipse.vtp.desktop.export.internal.main.DesignReference;
import org.eclipse.vtp.desktop.export.internal.main.ExportWriter;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.framework.util.ConfigurationDictionary;
import org.eclipse.vtp.framework.util.Guid;
import org.eclipse.vtp.framework.util.StaticConfigurationAdmin;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebApplicationExporter {
    private static final List<String> REQUIRED_BUNDLES = Collections.unmodifiableList(Arrays.asList("org.eclipse.osgi", "org.eclipse.osgi.services", "org.eclipse.core.contenttype", "org.eclipse.core.jobs", "org.eclipse.core.runtime", "org.eclipse.core.runtime.compatibility.auth", "org.eclipse.equinox.app", "org.eclipse.equinox.common", "org.eclipse.equinox.http.servlet", "org.eclipse.equinox.http.servletbridge", "org.eclipse.equinox.preferences", "org.eclipse.equinox.registry", "org.eclipse.equinox.servletbridge", "org.eclipse.update.configurator", "javax.activation", "javax.mail", "javax.xml.soap", "javax.xml.rpc", "javax.wsdl", "org.apache.ant", "org.apache.axis", "org.apache.commons.discovery", "org.apache.commons.io", "org.apache.commons.fileupload", "org.apache.commons.logging", "org.apache.commons.pool", "org.apache.log4j", "org.apache.xerces", "org.apache.xml.resolver", "org.mozilla.javascript", "org.eclipse.vtp.framework.core", "org.eclipse.vtp.framework.engine", "org.eclipse.vtp.framework.spi", "org.eclipse.vtp.framework.util"));
    private static final List<String> OPTIONAL_BUNDLES = Collections.unmodifiableList(Arrays.asList("javax.xml", "org.apache.xml.serializer"));
    private static final List<String> EXTENSION_POINTS = Collections.unmodifiableList(Arrays.asList("org.eclipse.vtp.framework.core.actions", "org.eclipse.vtp.framework.core.configurations", "org.eclipse.vtp.framework.core.observers", "org.eclipse.vtp.framework.core.services"));
    private static final Map<String, Integer> START_LEVELS;
    private final Collection<ExportAgent> agents;
    private String uniqueToken = null;
    private ExportWriter output = null;
    private ExportWriter mediaOutput = null;
    private Collection<WorkflowExporter> workflowExporters = null;
    private Collection<MediaExporter> mediaExporters = null;
    private Map<String, BundleExporter> bundleExporters = null;
    private IProgressMonitor monitor = null;
    private DocumentBuilder documentBuilder = null;
    private Transformer transformer = null;
    private boolean separateMedia;

    static {
        HashMap<String, Integer> startLevels = new HashMap<String, Integer>(4);
        startLevels.put("org.eclipse.equinox.servletbridge", -1);
        startLevels.put("org.eclipse.osgi", 0);
        startLevels.put("org.eclipse.osgi.services", 1);
        startLevels.put("org.eclipse.equinox.app", 2);
        startLevels.put("org.eclipse.equinox.common", 2);
        START_LEVELS = Collections.unmodifiableMap(startLevels);
    }

    public WebApplicationExporter(Collection<ExportAgent> agents) {
        this.agents = agents;
    }

    public final synchronized boolean export(File archive, Collection<WorkflowExporter> workflowProjects, Collection<MediaExporter> mediaProjects, boolean separateMedia, File mediaDestination, IProgressMonitor monitor) throws Exception {
        this.separateMedia = separateMedia;
        File canonical = archive.getCanonicalFile();
        boolean completed = false;
        try {
            this.uniqueToken = Guid.createGUID();
            if (canonical.isFile()) {
                this.delete(canonical);
            }
            if (canonical.isDirectory()) {
                this.deleteChildren(canonical);
            }
            this.mediaOutput = this.output = ExportWriter.create(canonical);
            if (separateMedia) {
                File mediaCanonical = mediaDestination.getCanonicalFile();
                if (mediaCanonical.isFile()) {
                    this.delete(mediaCanonical);
                }
                if (mediaCanonical.isDirectory()) {
                    this.deleteChildren(mediaCanonical);
                }
                this.mediaOutput = ExportWriter.create(mediaCanonical);
            }
            this.workflowExporters = workflowProjects;
            this.mediaExporters = mediaProjects;
            this.bundleExporters = new LinkedHashMap<String, BundleExporter>();
            this.monitor = monitor;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            this.documentBuilder = dbf.newDocumentBuilder();
            this.transformer = TransformerFactory.newInstance().newTransformer();
            boolean bl = completed = this.run();
            return bl;
        }
        finally {
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            finally {
                this.uniqueToken = null;
                this.output = null;
                this.workflowExporters = null;
                this.mediaExporters = null;
                this.bundleExporters = null;
                this.monitor = null;
                this.documentBuilder = null;
                this.transformer = null;
                if (!completed) {
                    this.delete(canonical);
                }
            }
        }
    }

    private void delete(File file) throws IOException {
        File canonical = file.getCanonicalFile();
        if (canonical.isDirectory()) {
            this.deleteChildren(canonical);
        }
        canonical.delete();
    }

    private void deleteChildren(File canonical) throws IOException {
        File[] children = canonical.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.delete(child);
                ++n2;
            }
        }
    }

    private boolean run() throws Exception {
        if (this.monitor.isCanceled()) {
            return false;
        }
        this.monitor.beginTask("Constructing runtime...", this.workflowExporters.size() + this.mediaExporters.size() + 3);
        this.constructRuntime();
        this.monitor.worked(1);
        if (this.monitor.isCanceled()) {
            return false;
        }
        this.monitor.setTaskName("Exporting framework...");
        this.exportFramework();
        this.monitor.worked(1);
        for (WorkflowExporter workflowExporter : this.workflowExporters) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            this.monitor.setTaskName(String.format("Exporting workflow project %s...", workflowExporter.getProject().getName()));
            this.exportWorkflow(workflowExporter);
            this.monitor.worked(1);
        }
        for (MediaExporter mediaExporter : this.mediaExporters) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            this.monitor.setTaskName(String.format("Exporting media project %s...", mediaExporter.getProject().getName()));
            if (!this.separateMedia) {
                this.exportMedia(mediaExporter);
            } else {
                this.exportExternalMedia(mediaExporter);
            }
            this.monitor.worked(1);
        }
        if (this.monitor.isCanceled()) {
            return false;
        }
        this.monitor.setTaskName("Finializing web application...");
        this.finalizeWebApplication();
        this.monitor.worked(1);
        this.monitor.done();
        return true;
    }

    private void constructRuntime() {
        for (String name : REQUIRED_BUNDLES) {
            this.bundleExporters.put(name, null);
        }
        for (String name : OPTIONAL_BUNDLES) {
            this.bundleExporters.put(name, null);
        }
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        for (String extensionPoint : EXTENSION_POINTS) {
            IExtension[] iExtensionArray = extensionRegistry.getExtensionPoint(extensionPoint).getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                this.bundleExporters.put(extension.getContributor().getName(), null);
                ++n2;
            }
        }
        Object[] objectArray = ExportCore.getBundles();
        int n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            block15: {
                BundleExporter exporter;
                String symbolicName;
                Bundle bundle;
                block16: {
                    bundle = objectArray[n3];
                    System.err.println("Bundle: " + bundle.getSymbolicName());
                    if (bundle.getState() == 1) break block15;
                    symbolicName = bundle.getSymbolicName();
                    if ("system.bundle".equals(symbolicName)) {
                        symbolicName = REQUIRED_BUNDLES.get(0);
                    }
                    if (this.bundleExporters.containsKey(symbolicName)) break block16;
                    String hostSymbolicName = (String)bundle.getHeaders().get("Fragment-Host");
                    if (hostSymbolicName == null) break block15;
                    if (hostSymbolicName.indexOf(59) >= 0) {
                        hostSymbolicName = hostSymbolicName.substring(0, hostSymbolicName.indexOf(59));
                    }
                    if (!this.bundleExporters.containsKey(hostSymbolicName = hostSymbolicName.trim())) break block15;
                }
                if ((exporter = this.bundleExporters.get(symbolicName)) == null) {
                    this.bundleExporters.put(symbolicName, new BundleExporter(bundle));
                } else {
                    Version oldVersion = new Version((String)exporter.getHeaders().get("Bundle-Version"));
                    Version newVersion = new Version((String)bundle.getHeaders().get("Bundle-Version"));
                    if (newVersion.compareTo((Object)oldVersion) > 0) {
                        this.bundleExporters.put(symbolicName, exporter);
                    }
                }
            }
            ++n3;
        }
        objectArray = this.bundleExporters.keySet().toArray(new String[this.bundleExporters.size()]);
        n = objectArray.length;
        n3 = 0;
        while (n3 < n) {
            Bundle name = objectArray[n3];
            if (this.bundleExporters.get(name) == null) {
                System.err.println("Missing bundle import: " + (String)name);
                this.bundleExporters.remove(name);
            }
            ++n3;
        }
    }

    private void exportFramework() throws Exception {
        this.output.writeURL("WEB-INF/eclipse/launch.ini", this.getClass().getResource("/launch.ini"));
        PrintStream frameworkConfig = new PrintStream(this.output.write("WEB-INF/eclipse/configuration/config.ini"));
        frameworkConfig.println("#Eclipse Runtime Configuration File");
        frameworkConfig.println("#Generated by the VoiceTools export wizard.");
        frameworkConfig.print("osgi.bundles=");
        frameworkConfig.println("org.eclipse.equinox.servletbridge.extensionbundle,\\");
        frameworkConfig.print("javax.servlet");
        for (String symbolicName : this.bundleExporters.keySet()) {
            Integer n = START_LEVELS.get(symbolicName);
            if (n != null && n <= 0) continue;
            frameworkConfig.println(",\\");
            frameworkConfig.print("  ");
            frameworkConfig.print(symbolicName);
            if (this.bundleExporters.get(symbolicName).isFragment()) continue;
            if (n == null) {
                frameworkConfig.print("@start");
                continue;
            }
            frameworkConfig.print("@");
            frameworkConfig.print(n);
            frameworkConfig.print(":start");
        }
        frameworkConfig.println();
        frameworkConfig.println("osgi.bundles.defaultStartLevel=4");
        frameworkConfig.close();
        for (BundleExporter exporter : this.bundleExporters.values()) {
            Integer n = START_LEVELS.get(exporter.getSymbolicName());
            if (n != null && n < 0) continue;
            exporter.export(this.output, "WEB-INF/eclipse/plugins/");
        }
        this.output.writeURL("WEB-INF/eclipse/plugins/javax.servlet_2.4.0/META-INF/MANIFEST.MF", this.getClass().getResource("/servletManifest.mf"));
        this.output.writeURL("WEB-INF/eclipse/plugins/static.configuration_0.0.0/META-INF/MANIFEST.MF", this.getClass().getResource("/staticConfigManifest.mf"));
        LinkedList<ConfigurationDictionary> dictionaries = new LinkedList<ConfigurationDictionary>();
        ConfigurationDictionary httpDictionary = new ConfigurationDictionary("org.eclipse.vtp.framework.engine.http");
        httpDictionary.put((Object)"path", (Object)"/");
        httpDictionary.put((Object)"mime.type.grxml", (Object)"application/srgs+xml");
        httpDictionary.put((Object)"mime.type.vox", (Object)"audio/basic");
        httpDictionary.put((Object)"mime.type.wav", (Object)"audio/x-wav");
        dictionaries.add(httpDictionary);
        for (WorkflowExporter workflowExporter : this.workflowExporters) {
            dictionaries.addAll(workflowExporter.getConfigurationDictionaries(this.uniqueToken));
        }
        for (MediaExporter mediaExporter : this.mediaExporters) {
            dictionaries.addAll(mediaExporter.getConfigurationDictionaries(this.uniqueToken));
        }
        Document document = this.documentBuilder.newDocument();
        document.appendChild(ConfigurationDictionary.saveAll((Document)document, (ConfigurationDictionary[])dictionaries.toArray(new ConfigurationDictionary[dictionaries.size()])));
        OutputStream staticConfig = this.output.write("WEB-INF/eclipse/plugins/static.configuration_0.0.0/META-INF/services/" + StaticConfigurationAdmin.class.getName());
        this.transformer.transform(new DOMSource(document), new XMLWriter(staticConfig).toXMLResult());
        staticConfig.close();
    }

    private String exportProject(ProjectExporter project) throws Exception {
        return this.exportProject(project, null);
    }

    private String exportProject(ProjectExporter project, FilenameFilter filter) throws Exception {
        String symbolicName = String.valueOf(project.getProject().getName()) + "." + this.uniqueToken;
        String path = "WEB-INF/eclipse/plugins/" + symbolicName + "_0.0.0/";
        PrintStream manifest = new PrintStream(this.output.write(String.valueOf(path) + "META-INF/MANIFEST.MF"));
        manifest.println("Manifest-Version: 1.0");
        manifest.println("Bundle-ManifestVersion: 2");
        manifest.print("Bundle-Name: ");
        manifest.println(project.getProject().getName());
        manifest.print("Bundle-SymbolicName: ");
        manifest.print(symbolicName);
        manifest.println(";singleton:=true");
        manifest.println("Bundle-Version: 0.0.0");
        manifest.println("Bundle-Localization: plugin");
        manifest.print("Bundle-ClassPath: .,project/Dependencies");
        IFolder dependencyFolder = project.getProject().getFolder("Dependencies");
        if (dependencyFolder.exists()) {
            IResource[] members;
            IResource[] iResourceArray = members = dependencyFolder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IResource dep = iResourceArray[n2];
                if (dep.exists() && dep instanceof IFile && (file = (IFile)dep).getFileExtension().toLowerCase().equals("jar")) {
                    manifest.print(",project/Dependencies/" + file.getName());
                }
                ++n2;
            }
            manifest.println();
        }
        manifest.print("Require-Bundle:");
        boolean printed = false;
        for (String name : this.bundleExporters.keySet()) {
            if (printed) {
                manifest.println(",");
            }
            manifest.print(" ");
            manifest.print(name);
            manifest.print(";resolution:=optional");
            printed = true;
        }
        manifest.println();
        manifest.close();
        this.output.writeFile(String.valueOf(path) + "project/", project.getProject().getLocation().toFile(), filter);
        return path;
    }

    private void exportExternalMedia(MediaExporter project) throws Exception {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.endsWith(".wav") && !name.endsWith(".au") && !name.endsWith(".vox");
            }
        };
        File file = project.getMediaProject().getMediaFilesFolder().getUnderlyingFolder().getLocation().toFile();
        this.mediaOutput.writeFile(String.valueOf(project.getMediaProject().getName()) + "/", file, null);
        String path = this.exportProject(project, filter);
        Document pluginXmlDoc = this.documentBuilder.newDocument();
        pluginXmlDoc.appendChild(pluginXmlDoc.createProcessingInstruction("eclipse", "version=\"3.2\""));
        Element pluginElement = pluginXmlDoc.createElement("plugins");
        Element extensionElement = pluginXmlDoc.createElement("extension");
        extensionElement.setAttribute("point", "org.eclipse.vtp.framework.engine.resources");
        Element resourcesElement = pluginXmlDoc.createElement("resources");
        resourcesElement.setAttribute("id", project.getProject().getName());
        resourcesElement.setAttribute("name", project.getProject().getName());
        resourcesElement.setAttribute("path", "project/Media Files");
        extensionElement.appendChild(resourcesElement);
        pluginElement.appendChild(extensionElement);
        pluginXmlDoc.appendChild(pluginElement);
        OutputStream stream = this.output.write(String.valueOf(path) + "plugin.xml");
        this.transformer.transform(new DOMSource(pluginXmlDoc), new XMLWriter(stream).toXMLResult());
        stream.close();
        StringBuilder fileIndex = new StringBuilder();
        this.indexMedia(fileIndex, project.getMediaProject().getMediaFilesFolder().getUnderlyingFolder());
        stream = this.output.write(String.valueOf(path) + "files.index");
        stream.write(fileIndex.toString().getBytes());
        stream.close();
    }

    private void indexMedia(StringBuilder index, IFolder toIndex) {
        try {
            IResource[] iResourceArray = toIndex.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (r instanceof IFolder) {
                    this.indexMedia(index, (IFolder)r);
                } else {
                    index.append(r.getProjectRelativePath().toString());
                    index.append("\r\n");
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void exportWorkflow(WorkflowExporter project) throws Exception {
        String path = this.exportProject(project);
        Document pluginXmlDoc = this.documentBuilder.newDocument();
        pluginXmlDoc.appendChild(pluginXmlDoc.createProcessingInstruction("eclipse", "version=\"3.2\""));
        Element pluginElement = pluginXmlDoc.createElement("plugins");
        Element extensionElement = pluginXmlDoc.createElement("extension");
        extensionElement.setAttribute("point", "org.eclipse.vtp.framework.engine.definitions");
        Element resourcesElement = pluginXmlDoc.createElement("definition");
        resourcesElement.setAttribute("id", String.valueOf(project.getProject().getName()) + "." + this.uniqueToken);
        resourcesElement.setAttribute("name", project.getProject().getName());
        resourcesElement.setAttribute("path", "process.xml");
        extensionElement.appendChild(resourcesElement);
        pluginElement.appendChild(extensionElement);
        pluginXmlDoc.appendChild(pluginElement);
        OutputStream stream = this.output.write(String.valueOf(path) + "plugin.xml");
        this.transformer.transform(new DOMSource(pluginXmlDoc), new XMLWriter(stream).toXMLResult());
        stream.close();
        Map<String, MediaExporter> mediaProjects = project.getMediaDependencyMap();
        HashMap<String, String> formatterIDsByLanguage = new HashMap<String, String>(mediaProjects.size());
        HashMap<String, String> resourceManagerIDsByLanguage = new HashMap<String, String>(mediaProjects.size());
        for (Map.Entry<String, MediaExporter> entry : mediaProjects.entrySet()) {
            formatterIDsByLanguage.put(entry.getKey(), entry.getValue().getFormatter());
            resourceManagerIDsByLanguage.put(entry.getKey(), entry.getValue().getProject().getName());
        }
        LinkedList<DesignReference> callDesigns = new LinkedList<DesignReference>();
        for (IDesignDocument document : project.getDesignDocuments()) {
            callDesigns.add(new DesignReference(document, this.documentBuilder.parse(document.getUnderlyingFile().getLocation().toFile().getCanonicalFile())));
        }
        Document definition = new DefinitionBuilder(callDesigns.toArray(new DesignReference[callDesigns.size()]), this.documentBuilder, project.getWorkflowProject(), formatterIDsByLanguage, resourceManagerIDsByLanguage, project.getLanguageMapping()).getDefinition();
        Element servicesElement = (Element)definition.getDocumentElement().getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/engine/process-definition", "services").item(0);
        for (ExportAgent agent : this.agents) {
            agent.getValue().configureServices(project, servicesElement);
        }
        OutputStream fileEntryStream = this.output.write(String.valueOf(path) + "process.xml");
        this.transformer.transform(new DOMSource(definition), new XMLWriter(fileEntryStream).toXMLResult());
        fileEntryStream.close();
    }

    private void exportMedia(MediaExporter project) throws Exception {
        String path = this.exportProject(project);
        Document pluginXmlDoc = this.documentBuilder.newDocument();
        pluginXmlDoc.appendChild(pluginXmlDoc.createProcessingInstruction("eclipse", "version=\"3.2\""));
        Element pluginElement = pluginXmlDoc.createElement("plugins");
        Element extensionElement = pluginXmlDoc.createElement("extension");
        extensionElement.setAttribute("point", "org.eclipse.vtp.framework.engine.resources");
        Element resourcesElement = pluginXmlDoc.createElement("resources");
        resourcesElement.setAttribute("id", project.getProject().getName());
        resourcesElement.setAttribute("name", project.getProject().getName());
        resourcesElement.setAttribute("path", "project/Media Files");
        extensionElement.appendChild(resourcesElement);
        pluginElement.appendChild(extensionElement);
        pluginXmlDoc.appendChild(pluginElement);
        OutputStream stream = this.output.write(String.valueOf(path) + "plugin.xml");
        this.transformer.transform(new DOMSource(pluginXmlDoc), new XMLWriter(stream).toXMLResult());
        stream.close();
    }

    private void finalizeWebApplication() throws Exception {
        this.output.writeURL("WEB-INF/classes/org/eclipse/vtp/framework/webapp/HttpSessionListenerManager.class", this.getClass().getResource("/org/eclipse/vtp/framework/webapp/HttpSessionListenerManager.class"));
        this.output.writeURL("WEB-INF/web.xml", this.getClass().getResource("/web.xml"));
        this.output.writeURL("WEB-INF/lib/servletbridge.jar", this.getClass().getResource("/servletbridge.jar"));
    }
}

