/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.export.internal.pages;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.export.internal.ExportCore;
import org.eclipse.vtp.desktop.export.internal.Exporter;

public final class ArchiveSelectionPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    private final Exporter exporter;
    private Button archiveRadio = null;
    private Combo archiveCombo = null;
    private Button archiveBrowse = null;
    private Button directoryRadio = null;
    private Combo directoryCombo = null;
    private Button directoryBrowse = null;
    private Button mediaCheckbox = null;
    private Combo mediaCombo = null;
    private Button mediaBrowse = null;
    private boolean hasNonMediaError = false;
    private boolean hasMediaError = false;

    private static String getLastArchivePath() {
        return ExportCore.getPreference("lastArchivePath");
    }

    private static String[] getAllArchivePaths() {
        String names = ExportCore.getPreference("allArchivePaths");
        if (names == null || names.length() == 0) {
            return new String[0];
        }
        return names.split(File.pathSeparator);
    }

    public ArchiveSelectionPage(Exporter exporter) {
        super(ArchiveSelectionPage.class.getSimpleName(), "Select an Archive File or a Directory", null);
        this.exporter = exporter;
    }

    public void saveArchivePath() {
        String path = this.exporter.getArchiveLocation().getAbsolutePath();
        if (!this.exporter.isUsingArchiveFile() && !path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        TreeSet<String> paths = new TreeSet<String>(Arrays.asList(ArchiveSelectionPage.getAllArchivePaths()));
        paths.add(path);
        StringBuilder joined = new StringBuilder();
        Iterator iter = paths.iterator();
        joined.append((String)iter.next());
        while (iter.hasNext()) {
            joined.append(File.pathSeparator).append((String)iter.next());
        }
        ExportCore.setPreference("lastArchivePath", path);
        ExportCore.setPreference("allArchivePaths", joined.toString());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.archiveRadio = new Button(composite, 16);
        this.archiveRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.archiveRadio.setText("Archive file:");
        this.archiveRadio.addSelectionListener((SelectionListener)this);
        this.archiveCombo = new Combo(composite, 4);
        this.archiveCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.archiveCombo.addModifyListener((ModifyListener)this);
        this.archiveCombo.addSelectionListener((SelectionListener)this);
        this.archiveBrowse = new Button(composite, 8);
        this.archiveBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.archiveBrowse.setText("Browse...");
        this.archiveBrowse.addSelectionListener((SelectionListener)this);
        this.directoryRadio = new Button(composite, 16);
        this.directoryRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.directoryRadio.setText("Directory:");
        this.directoryRadio.addSelectionListener((SelectionListener)this);
        this.directoryCombo = new Combo(composite, 4);
        this.directoryCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.directoryCombo.addModifyListener((ModifyListener)this);
        this.directoryCombo.addSelectionListener((SelectionListener)this);
        this.directoryBrowse = new Button(composite, 8);
        this.directoryBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.directoryBrowse.setText("Browse...");
        this.directoryBrowse.addSelectionListener((SelectionListener)this);
        this.mediaCheckbox = new Button(composite, 32);
        this.mediaCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mediaCheckbox.setText("Export media to separate directory");
        this.mediaCheckbox.addSelectionListener((SelectionListener)this);
        this.mediaCombo = new Combo(composite, 4);
        this.mediaCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mediaCombo.addModifyListener((ModifyListener)this);
        this.mediaCombo.addSelectionListener((SelectionListener)this);
        this.mediaBrowse = new Button(composite, 8);
        this.mediaBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.mediaBrowse.setText("Browse...");
        this.mediaBrowse.addSelectionListener((SelectionListener)this);
        String lastPath = ArchiveSelectionPage.getLastArchivePath();
        Object[] paths = ArchiveSelectionPage.getAllArchivePaths();
        Arrays.sort(paths);
        int i = 0;
        while (i < paths.length) {
            if (((String)paths[i]).endsWith(File.separator)) {
                this.directoryCombo.add((String)paths[i]);
                if (((String)paths[i]).equals(lastPath)) {
                    this.directoryRadio.setSelection(true);
                    this.directoryCombo.select(this.directoryCombo.getItemCount() - 1);
                }
            } else {
                this.archiveCombo.add((String)paths[i]);
                if (((String)paths[i]).equals(lastPath)) {
                    this.archiveRadio.setSelection(true);
                    this.archiveCombo.select(this.archiveCombo.getItemCount() - 1);
                }
            }
            ++i;
        }
        this.setControl((Control)composite);
        if (this.isArchive()) {
            this.archiveCombo.setFocus();
        } else {
            this.directoryCombo.setFocus();
        }
        this.evaluate(lastPath, false);
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.mediaCombo) {
            this.evaluateMedia(((Combo)e.getSource()).getText(), true);
        } else {
            this.evaluate(((Combo)e.getSource()).getText(), true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source instanceof Button) {
            Button button = (Button)source;
            if (button == this.archiveRadio) {
                this.evaluate(this.archiveCombo.getText(), true);
            } else if (button == this.directoryRadio) {
                this.evaluate(this.directoryCombo.getText(), true);
            } else if (button == this.archiveBrowse) {
                String path = new FileDialog(this.getShell()).open();
                if (path == null) {
                    return;
                }
                this.archiveCombo.setText(path);
                this.evaluate(path, true);
            } else if (button == this.mediaCheckbox) {
                this.evaluateMedia(this.mediaCombo.getText(), true);
            } else if (button == this.mediaBrowse) {
                String path = new DirectoryDialog(this.getShell()).open();
                if (path == null) {
                    return;
                }
                this.mediaCombo.setText(path);
                this.evaluateMedia(path, true);
            } else {
                String path = new DirectoryDialog(this.getShell()).open();
                if (path == null) {
                    return;
                }
                this.directoryCombo.setText(path);
                this.evaluate(path, true);
            }
        } else if (source == this.mediaCombo) {
            this.evaluateMedia(((Combo)source).getText(), true);
        } else {
            this.evaluate(((Combo)source).getText(), true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private boolean isArchive() {
        return this.archiveRadio.getSelection();
    }

    private void evaluate(String path, boolean showErrorMessage) {
        File file = null;
        String msg = null;
        if (path == null || path.length() == 0) {
            msg = this.isArchive() ? "Select an archive file to export to." : "Select a directory to export to.";
        } else {
            try {
                file = new File(path).getCanonicalFile();
                if (this.isArchive()) {
                    if (file.isDirectory()) {
                        msg = "Select a file, not a directory.";
                    } else if (!file.getName().endsWith(".war") && !file.getName().endsWith(".zip")) {
                        msg = "Archive file name must end with \".war\" or \".zip\".";
                    }
                } else if (file.isFile()) {
                    msg = "Select a directory, not a file.";
                }
            }
            catch (IOException e) {
                msg = "Error resolving archive: " + e.getMessage();
            }
        }
        if (msg != null) {
            file = null;
        }
        if (showErrorMessage) {
            this.setErrorMessage(msg);
        }
        this.hasNonMediaError = msg != null;
        System.err.println("media error: " + this.hasMediaError);
        System.err.println("non media error: " + this.hasNonMediaError);
        this.setPageComplete(!this.hasMediaError && !this.hasNonMediaError);
        this.exporter.setArchiveLocation(file, this.isArchive());
    }

    private void evaluateMedia(String path, boolean showErrorMessage) {
        File file = null;
        String msg = null;
        if (this.mediaCheckbox.getSelection()) {
            if (path == null || path.length() == 0) {
                msg = "Select a directory to export the media to.";
            } else {
                try {
                    file = new File(path).getCanonicalFile();
                    if (file.isFile()) {
                        msg = "Select a directory, not a file.";
                    }
                }
                catch (IOException e) {
                    msg = "Error resolving directory: " + e.getMessage();
                }
            }
            if (msg != null) {
                file = null;
            }
        }
        if (showErrorMessage) {
            this.setErrorMessage(msg);
        }
        this.hasMediaError = msg != null;
        System.err.println("media error: " + this.hasMediaError);
        System.err.println("non media error: " + this.hasNonMediaError);
        this.setPageComplete(!this.hasMediaError && !this.hasNonMediaError);
        this.exporter.setMediaLocation(file);
    }
}

