/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.export.internal.pages;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.export.internal.Exporter;
import org.eclipse.vtp.desktop.export.internal.MediaExporter;
import org.eclipse.vtp.desktop.export.internal.WorkflowExporter;

public final class ProjectSelectionPage
extends WizardPage
implements IStructuredContentProvider,
ICheckStateListener,
SelectionListener {
    private final Exporter exporter;
    private final Collection<WorkflowExporter> projects;
    private final Set<WorkflowExporter> initialSelection;
    private CheckboxTableViewer viewer = null;
    private Button selectAll = null;
    private Button deselectAll = null;
    private boolean ignoreProjectSelectionChanged = false;

    public ProjectSelectionPage(Exporter exporter, Collection<WorkflowExporter> projects, Set<WorkflowExporter> initialSelection) {
        super(ProjectSelectionPage.class.getSimpleName(), "Select the Projects to Export", null);
        this.exporter = exporter;
        this.projects = projects;
        this.initialSelection = initialSelection;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput(this.projects);
        this.viewer.setCheckedElements(this.initialSelection.toArray());
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.selectAll = new Button(composite, 8);
        this.selectAll.setText("Select All");
        this.selectAll.setLayoutData((Object)new GridData(4, 128, false, false));
        this.selectAll.addSelectionListener((SelectionListener)this);
        this.deselectAll = new Button(composite, 8);
        this.deselectAll.setText("Deselect All");
        this.deselectAll.setLayoutData((Object)new GridData(4, 128, false, false));
        this.deselectAll.addSelectionListener((SelectionListener)this);
        Label extra = new Label(composite, 0);
        extra.setLayoutData((Object)new GridData(4, 4, false, true));
        this.setControl((Control)composite);
        this.projectSelectionChanged(false);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.projects.toArray();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.projectSelectionChanged(true);
    }

    private void projectSelectionChanged(boolean showErrorMessage) {
        if (this.viewer == null || this.ignoreProjectSelectionChanged) {
            return;
        }
        HashSet<MediaExporter> mediaSelection = new HashSet<MediaExporter>();
        HashMap<WorkflowExporter, Boolean> workflowSelection = new HashMap<WorkflowExporter, Boolean>();
        boolean dirty = false;
        for (WorkflowExporter exporter : this.projects) {
            if (!this.viewer.getChecked((Object)exporter)) continue;
            dirty |= this.workflowSelected(mediaSelection, workflowSelection, exporter, true);
        }
        if (dirty) {
            MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Unsaved Projects", (String)"One or more of the projects to be exported contains unsaved resources.");
        }
        this.exporter.setProjectSelection(mediaSelection, workflowSelection.keySet());
        this.setPageComplete(!workflowSelection.isEmpty());
        if (workflowSelection.isEmpty() && showErrorMessage) {
            this.setErrorMessage("Select at least one project to export.");
        } else {
            this.setErrorMessage(null);
        }
        this.ignoreProjectSelectionChanged = true;
        try {
            Iterator<WorkflowExporter> iterator = this.projects.iterator();
            while (iterator.hasNext()) {
                WorkflowExporter exporter;
                Boolean state = workflowSelection.get(exporter = iterator.next());
                this.viewer.setChecked((Object)exporter, state != null);
                this.viewer.setGrayed((Object)exporter, state != null && state == false);
            }
        }
        finally {
            this.ignoreProjectSelectionChanged = false;
        }
    }

    private boolean workflowSelected(Collection<MediaExporter> mediaSelection, Map<WorkflowExporter, Boolean> workflowSelection, WorkflowExporter exporter, boolean enabled) {
        if (workflowSelection.containsKey(exporter)) {
            workflowSelection.put(exporter, workflowSelection.get(exporter) != false && enabled);
            return false;
        }
        workflowSelection.put(exporter, enabled);
        boolean dirty = exporter.isDirty();
        for (MediaExporter media : exporter.getMediaDependencies()) {
            if (!mediaSelection.add(media)) continue;
            dirty |= media.isDirty();
        }
        for (WorkflowExporter other : exporter.getWorkflowDependencies()) {
            dirty |= this.workflowSelected(mediaSelection, workflowSelection, other, false);
        }
        return dirty;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.selectAll) {
            this.viewer.setCheckedElements(this.projects.toArray());
        } else if (e.getSource() == this.deselectAll) {
            this.viewer.setCheckedElements(new Object[0]);
        }
        this.projectSelectionChanged(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

