/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.media.core.ContentCreatorPanel;
import org.eclipse.vtp.desktop.media.core.ContentCreatorPanelManager;
import org.eclipse.vtp.desktop.media.core.ContentPlaceholder;
import org.eclipse.vtp.desktop.media.core.DynamicContentCreatorPanel;
import org.eclipse.vtp.desktop.media.core.PlaceholderContentCreatorPanel;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.interactive.core.content.ContentType;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IContentType;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;

public class ContentEntryDialog
extends Dialog {
    private IMediaProvider mediaProvider = null;
    List<IContentType> supportedTypes;
    List<ContentPlaceholder> placeholders = Collections.emptyList();
    List<Variable> variables;
    List<ContentCreatorPanel> creatorControls = new ArrayList<ContentCreatorPanel>();
    StackLayout stackLayout;
    Combo typeCombo = null;
    Content content;
    Composite creatorComp;

    public ContentEntryDialog(Shell parentShell) {
        super(parentShell);
    }

    public ContentEntryDialog(IShellProvider parentShellProvider) {
        super(parentShellProvider);
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public void setPlaceholders(List<ContentPlaceholder> placeholders) {
        this.placeholders = placeholders;
    }

    public void setMediaProvider(IMediaProvider mediaProvider) {
        this.mediaProvider = mediaProvider;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Prompt Entry");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Label typeLabel = new Label(comp, 0);
        typeLabel.setText("Content Type");
        typeLabel.setLayoutData((Object)new GridData());
        this.typeCombo = new Combo(comp, 12);
        this.typeCombo.setLayoutData((Object)new GridData(768));
        this.supportedTypes = this.mediaProvider.getSupportedContentTypes();
        if (this.placeholders.size() > 0) {
            boolean inserted = false;
            ContentType placeholderType = new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.placeholder", "Placeholder");
            int i = 0;
            while (i < this.supportedTypes.size()) {
                if (this.supportedTypes.get(i).getName().compareToIgnoreCase("Placeholder") > 0) {
                    inserted = true;
                    this.supportedTypes.set(i, (IContentType)placeholderType);
                    break;
                }
                ++i;
            }
            if (!inserted) {
                this.supportedTypes.add((IContentType)placeholderType);
            }
        }
        this.creatorComp = new Composite(comp, 0);
        this.creatorComp.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        this.creatorComp.setLayout((Layout)this.stackLayout);
        int i = 0;
        while (i < this.supportedTypes.size()) {
            ContentType ct = (ContentType)this.supportedTypes.get(i);
            this.typeCombo.add(ct.getName());
            ContentCreatorPanel ccp = ContentCreatorPanelManager.getInstance().getCreatorPanel(ct);
            ccp.setMediaProvider(this.mediaProvider);
            if (ccp instanceof DynamicContentCreatorPanel) {
                ((DynamicContentCreatorPanel)ccp).setVariables(this.variables);
            }
            if (ccp instanceof PlaceholderContentCreatorPanel) {
                ((PlaceholderContentCreatorPanel)ccp).setPlaceholders(this.placeholders);
            }
            this.creatorControls.add(ccp);
            ccp.createControls(this.creatorComp);
            if (this.content != null && this.content.getContentType().equals(ct.getId())) {
                this.typeCombo.select(i);
                this.stackLayout.topControl = ccp.getControl();
                ccp.setInitialContent(this.content);
            }
            ++i;
        }
        if (this.content == null) {
            this.stackLayout.topControl = this.creatorControls.get(0).getControl();
            this.typeCombo.select(0);
        }
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ContentEntryDialog.this.stackLayout.topControl = ContentEntryDialog.this.creatorControls.get(ContentEntryDialog.this.typeCombo.getSelectionIndex()).getControl();
                ContentEntryDialog.this.creatorComp.layout(true, true);
            }
        });
        return comp;
    }

    protected void okPressed() {
        ContentCreatorPanel ccp = this.creatorControls.get(this.typeCombo.getSelectionIndex());
        this.content = ccp.createContent();
        super.okPressed();
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }
}

