/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.core.custom.ToggleButton;
import org.eclipse.vtp.desktop.media.core.ValueControl;
import org.eclipse.vtp.desktop.model.interactive.core.mediadefaults.IMediaDefaultSetting;
import org.eclipse.vtp.desktop.model.interactive.core.mediadefaults.IMediaDefaultSettings;

public class DefaultValueStack
implements ToggleButton.ToggleButtonListener {
    private String settingName = null;
    private StackLayout stackLayout = null;
    private Composite mainComp = null;
    private Composite stackComp = null;
    private Composite staticComp = null;
    private Label staticValue = null;
    private Composite valueComp = null;
    private Composite buttonComp = null;
    private ToggleButton defaultButton = null;
    private ToggleButton staticButton = null;
    private IMediaDefaultSetting setting = null;
    private ValueControl valueControl = null;
    private String interactionType = null;
    private String elementType = null;

    public DefaultValueStack(String interactionType, String elementType, String settingName) {
        this.interactionType = interactionType;
        this.elementType = elementType;
        this.settingName = settingName;
    }

    public void createControls(Composite parent) {
        this.mainComp = new Composite(parent, 0);
        this.mainComp.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.mainComp.setLayout((Layout)gridLayout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        this.mainComp.setLayoutData((Object)gd);
        this.stackComp = new Composite(this.mainComp, 0);
        this.stackComp.setBackground(parent.getBackground());
        this.stackLayout = new StackLayout();
        this.stackComp.setLayout((Layout)this.stackLayout);
        this.stackComp.setLayoutData((Object)new GridData(768));
        this.staticComp = new Composite(this.stackComp, 0);
        this.staticComp.setBackground(parent.getBackground());
        gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 4;
        this.staticComp.setLayout((Layout)gridLayout);
        this.staticValue = new Label(this.staticComp, 0);
        this.staticValue.setBackground(parent.getBackground());
        gd = new GridData(1808);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 4;
        this.staticValue.setLayoutData((Object)gd);
        this.staticValue.setAlignment(131072);
        this.staticValue.setText("null");
        this.valueComp = new Composite(this.stackComp, 0);
        this.valueComp.setBackground(parent.getBackground());
        gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 4;
        this.valueComp.setLayout((Layout)gridLayout);
        this.stackLayout.topControl = this.staticComp;
        this.buttonComp = new Composite(this.mainComp, 0);
        this.buttonComp.setBackground(parent.getBackground());
        gridLayout = new GridLayout(2, true);
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.buttonComp.setLayout((Layout)gridLayout);
        this.buttonComp.setLayoutData((Object)new GridData());
        this.staticButton = new ToggleButton(this.buttonComp);
        this.staticButton.setBackground(parent.getBackground());
        this.staticButton.setText("S");
        GridData gridData = new GridData();
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        this.staticButton.setLayoutData((Object)gridData);
        this.staticButton.setToggleDownOnly(true);
        this.staticButton.addSelectionListener((ToggleButton.ToggleButtonListener)this);
        this.defaultButton = new ToggleButton(this.buttonComp);
        this.defaultButton.setBackground(parent.getBackground());
        this.defaultButton.setText("D");
        gridData = new GridData();
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        this.defaultButton.setLayoutData((Object)gridData);
        this.defaultButton.setSelected(true);
        this.defaultButton.setToggleDownOnly(true);
        this.defaultButton.addSelectionListener((ToggleButton.ToggleButtonListener)this);
        this.mainComp.layout(true, true);
        this.stackComp.layout(true, true);
    }

    public Composite getValueComposite() {
        return this.valueComp;
    }

    public void setValueControl(ValueControl valueControl) {
        this.valueControl = valueControl;
    }

    public void setSetting(IMediaDefaultSettings settings) {
        this.setting = settings.getDefaultSetting(this.interactionType, this.elementType, this.settingName);
        this.staticValue.setText(this.setting.isValueInherited() ? this.setting.getValue() : "");
        if (this.setting.isValueInherited()) {
            this.stackLayout.topControl = this.staticComp;
            this.defaultButton.setSelected(true);
            this.staticButton.setSelected(false);
        } else {
            this.stackLayout.topControl = this.valueComp;
            this.defaultButton.setSelected(false);
            this.staticButton.setSelected(true);
        }
        this.valueControl.setValue(this.setting.getValue());
        this.mainComp.layout(true, true);
        this.stackComp.layout(true, true);
    }

    public void save() {
        if (this.defaultButton.isSelected()) {
            this.setting.setValue(null);
        } else {
            this.setting.setValue(this.valueControl.getValue());
        }
    }

    public void toggleButtonSelected(ToggleButton button) {
        if (button == this.defaultButton) {
            String currentSetting = this.setting.getValue();
            this.setting.setValue(null);
            this.staticValue.setText(this.setting.getValue());
            this.setting.setValue(currentSetting);
            this.stackLayout.topControl = this.staticComp;
            this.staticButton.setSelected(false);
        } else {
            this.stackLayout.topControl = this.valueComp;
            this.defaultButton.setSelected(false);
        }
        this.mainComp.layout(true, true);
        this.stackComp.layout(true, true);
    }
}

