/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.media.core.FormatterRegistration;
import org.osgi.framework.Bundle;

public class FormatterRegistrationManager {
    public static final String formatterTypeExtensionId = "org.eclipse.vtp.framework.interactions.core.formatterTypes";
    private static final FormatterRegistrationManager INSTANCE = new FormatterRegistrationManager();
    private Map<String, List<FormatterRegistration>> formattersByInteractionType = new HashMap<String, List<FormatterRegistration>>();
    private Map<String, FormatterRegistration> formattersById = new HashMap<String, FormatterRegistration>();

    public static FormatterRegistrationManager getInstance() {
        return INSTANCE;
    }

    private FormatterRegistrationManager() {
        IConfigurationElement[] formatterExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(formatterTypeExtensionId);
        int i = 0;
        while (i < formatterExtensions.length) {
            block4: {
                FormatterRegistration ftr = new FormatterRegistration();
                ftr.id = formatterExtensions[i].getAttribute("id");
                ftr.name = formatterExtensions[i].getAttribute("name");
                ftr.vendor = formatterExtensions[i].getAttribute("vendor-name");
                ftr.interactionType = formatterExtensions[i].getAttribute("interaction-type");
                String className = formatterExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)formatterExtensions[i].getContributor().getName());
                try {
                    ftr.formatterClass = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block4;
                }
                List<FormatterRegistration> formatters = this.formattersByInteractionType.get(ftr.interactionType);
                if (formatters == null) {
                    formatters = new ArrayList<FormatterRegistration>();
                    this.formattersByInteractionType.put(ftr.interactionType, formatters);
                }
                formatters.add(ftr);
                this.formattersById.put(ftr.id, ftr);
            }
            ++i;
        }
    }

    public List<FormatterRegistration> getFormattersForInteractionType(String interactionType) {
        List<FormatterRegistration> formatters = this.formattersByInteractionType.get(interactionType);
        if (formatters == null) {
            formatters = new ArrayList<FormatterRegistration>();
        }
        return formatters;
    }

    public FormatterRegistration getFormatter(String id) {
        FormatterRegistration ftr = this.formattersById.get(id);
        return ftr;
    }
}

