/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.media.core.GrammarEntryDialog;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.interactive.core.IInteractiveWorkflowProject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProviderManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BindingItem;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BrandBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.GrammarBindingItem;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.LanguageBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.NamedBinding;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;

public class GrammarBindingViewer
implements MouseListener {
    NamedBinding grammarBinding;
    IBrand currentBrand;
    String currentLanguage;
    Label contents;
    String interactionType;
    private IDesignElement designElement = null;

    public GrammarBindingViewer(IDesignElement designElement, NamedBinding grammarBinding, String interactionType) {
        this.grammarBinding = grammarBinding;
        this.interactionType = interactionType;
        this.designElement = designElement;
    }

    public void createControls(Composite parent) {
        this.contents = new Label(parent, 64);
        this.contents.setBackground(parent.getBackground());
        this.contents.setText("Not Configured");
        this.contents.addMouseListener((MouseListener)this);
    }

    public Control getControl() {
        return this.contents;
    }

    public void setCurrentBrand(IBrand brand) {
        this.currentBrand = brand;
        if (this.currentLanguage != null) {
            this.setContents();
        }
    }

    private void setContents() {
        LanguageBinding languageBinding = this.grammarBinding.getLanguageBinding(this.currentLanguage);
        BrandBinding brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        GrammarBindingItem pbi = (GrammarBindingItem)brandBinding.getBindingItem();
        if (pbi == null) {
            pbi = new GrammarBindingItem();
        }
        this.contents.setText(pbi.getGrammar() == null ? "Not Configured" : pbi.getGrammar().toString());
        this.contents.getParent().layout();
    }

    public void setCurrentLanguage(String language) {
        this.currentLanguage = language;
        if (this.currentBrand != null) {
            this.setContents();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        try {
            Shell workbenchShell = Display.getCurrent().getActiveShell();
            GrammarEntryDialog pbd = new GrammarEntryDialog(workbenchShell);
            LanguageBinding languageBinding = this.grammarBinding.getLanguageBinding(this.currentLanguage);
            BrandBinding brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            GrammarBindingItem pbi = (GrammarBindingItem)brandBinding.getBindingItem();
            if (pbi == null) {
                pbi = new GrammarBindingItem();
            }
            IMediaProviderManager mediaProviderManager = ((IInteractiveWorkflowProject)this.designElement.getDesign().getDocument().getProject()).getMediaProviderManager();
            pbd.setMediaProvider(mediaProviderManager.getMediaProvider(this.interactionType, this.currentBrand, this.currentLanguage));
            pbd.setContent(pbi.getGrammar());
            int result = pbd.open();
            if (result == 0) {
                InputGrammar gram = pbd.getContent();
                pbi = (GrammarBindingItem)pbi.clone();
                pbi.setGrammar(gram);
                brandBinding.setBindingItem((BindingItem)pbi);
                this.setContents();
                Composite comp = this.contents.getParent();
                while (comp.getParent() != null && comp.getParent().getLayout() != null && comp.getParent().getLayout() instanceof GridLayout) {
                    comp = comp.getParent();
                }
                comp.layout(true, true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }
}

