/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.media.core.EmptyInputGrammarCreatorPanel;
import org.eclipse.vtp.desktop.media.core.InputGrammarCreatorPanel;
import org.eclipse.vtp.desktop.media.core.InputGrammarCreatorPanelManager;
import org.eclipse.vtp.desktop.model.interactive.core.input.InputType;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;

public class GrammarEntryDialog
extends Dialog {
    private IMediaProvider mediaProvider = null;
    InputGrammar content;
    Combo typeCombo = null;
    InputGrammarCreatorPanel ecp = null;
    StackLayout stackLayout = new StackLayout();
    List<InputGrammarCreatorPanelManager.ContentCreatorRecord> typeRecords = new ArrayList<InputGrammarCreatorPanelManager.ContentCreatorRecord>();
    List<InputGrammarCreatorPanel> panels = new ArrayList<InputGrammarCreatorPanel>();

    public GrammarEntryDialog(Shell parentShell) {
        super(parentShell);
    }

    public GrammarEntryDialog(IShellProvider parentShellProvider) {
        super(parentShellProvider);
    }

    public void setMediaProvider(IMediaProvider mediaProvider) {
        this.mediaProvider = mediaProvider;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Grammar Entry");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(1808));
        this.typeCombo = new Combo(comp, 12);
        this.typeCombo.setLayoutData((Object)new GridData(768));
        this.typeCombo.add("Not Configured");
        final Composite stackComp = new Composite(comp, 0);
        stackComp.setBackground(comp.getBackground());
        stackComp.setLayout((Layout)this.stackLayout);
        stackComp.setLayoutData((Object)new GridData(1808));
        this.ecp = new EmptyInputGrammarCreatorPanel();
        this.ecp.createControls(stackComp);
        this.ecp.setInitialInput(this.content);
        this.ecp.getControl().setLayoutData((Object)new GridData(1808));
        List<InputGrammarCreatorPanelManager.ContentCreatorRecord> types = InputGrammarCreatorPanelManager.getInstance().getInputTypes();
        for (InputGrammarCreatorPanelManager.ContentCreatorRecord typeRecord : types) {
            this.typeRecords.add(typeRecord);
            this.typeCombo.add(typeRecord.contentName);
            InputGrammarCreatorPanel ccp = InputGrammarCreatorPanelManager.getInstance().getCreatorPanel(new InputType(typeRecord.contentType, ""));
            ccp.setMediaProvider(this.mediaProvider);
            ccp.createControls(stackComp);
            ccp.setInitialInput(this.content);
            ccp.getControl().setLayoutData((Object)new GridData(1808));
            this.panels.add(ccp);
        }
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GrammarEntryDialog.this.stackLayout.topControl = GrammarEntryDialog.this.typeCombo.getSelectionIndex() == 0 ? GrammarEntryDialog.this.ecp.getControl() : GrammarEntryDialog.this.panels.get(GrammarEntryDialog.this.typeCombo.getSelectionIndex() - 1).getControl();
                stackComp.layout();
            }
        });
        if (this.content == null) {
            this.typeCombo.select(0);
            this.stackLayout.topControl = this.ecp.getControl();
        } else {
            int i = 0;
            while (i < this.typeRecords.size()) {
                InputGrammarCreatorPanelManager.ContentCreatorRecord record = this.typeRecords.get(i);
                if (this.content.getInputGrammarType().equals(record.contentType)) {
                    this.typeCombo.select(i + 1);
                    this.stackLayout.topControl = this.panels.get(i).getControl();
                }
                ++i;
            }
        }
        stackComp.layout();
        return comp;
    }

    protected void okPressed() {
        this.content = this.typeCombo.getSelectionIndex() == 0 ? this.ecp.createGrammar() : this.panels.get(this.typeCombo.getSelectionIndex() - 1).createGrammar();
        super.okPressed();
    }

    public InputGrammar getContent() {
        return this.content;
    }

    public void setContent(InputGrammar content) {
        this.content = content;
    }
}

