/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.media.core.IMediaDefaultPanel;
import org.osgi.framework.Bundle;

public class MediaDefaultsPanelManager {
    public static final String mediaDefaultPanelExtensionId = "org.eclipse.vtp.desktop.media.core.mediaDefaultPanel";
    private static final MediaDefaultsPanelManager INSTANCE = new MediaDefaultsPanelManager();
    Map<String, Map<String, DefaultsPanelRecord>> configurationScreens = new HashMap<String, Map<String, DefaultsPanelRecord>>();

    public static MediaDefaultsPanelManager getInstance() {
        return INSTANCE;
    }

    public MediaDefaultsPanelManager() {
        IConfigurationElement[] screenExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(mediaDefaultPanelExtensionId);
        int i = 0;
        while (i < screenExtensions.length) {
            block4: {
                DefaultsPanelRecord dpr = new DefaultsPanelRecord();
                dpr.primitiveTypeId = screenExtensions[i].getAttribute("primitive-id");
                dpr.interactionType = screenExtensions[i].getAttribute("interaction-type");
                String className = screenExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)screenExtensions[i].getContributor().getName());
                try {
                    dpr.screenClass = contributor.loadClass(className);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block4;
                }
                Map<String, DefaultsPanelRecord> byInteraction = this.configurationScreens.get(dpr.interactionType);
                if (byInteraction == null) {
                    byInteraction = new HashMap<String, DefaultsPanelRecord>();
                    this.configurationScreens.put(dpr.interactionType, byInteraction);
                }
                byInteraction.put(dpr.primitiveTypeId, dpr);
            }
            ++i;
        }
    }

    public IMediaDefaultPanel getMediaDefaultsPanel(String primitiveTypeId, String interactionType) {
        DefaultsPanelRecord csr;
        IMediaDefaultPanel ret = null;
        Map<String, DefaultsPanelRecord> byInteraction = this.configurationScreens.get(interactionType);
        if (byInteraction != null && (csr = byInteraction.get(primitiveTypeId)) != null) {
            try {
                ret = csr.screenClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public Map<String, IMediaDefaultPanel> getIndexedMediaDefaultsPanels(String interactionType) {
        HashMap<String, IMediaDefaultPanel> ret = new HashMap<String, IMediaDefaultPanel>();
        Map<String, DefaultsPanelRecord> byInteraction = this.configurationScreens.get(interactionType);
        if (byInteraction != null) {
            for (Map.Entry<String, DefaultsPanelRecord> entry : byInteraction.entrySet()) {
                DefaultsPanelRecord csr = entry.getValue();
                if (csr == null) continue;
                try {
                    ret.put(entry.getKey(), csr.screenClass.newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private class DefaultsPanelRecord {
        String primitiveTypeId;
        String interactionType;
        Class<IMediaDefaultPanel> screenClass;

        private DefaultsPanelRecord() {
        }
    }
}

