/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.media.core.ContentCreatorPanel;
import org.eclipse.vtp.desktop.media.core.ContentPlaceholder;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.PlaceholderContent;

public class PlaceholderContentCreatorPanel
extends ContentCreatorPanel {
    private List<ContentPlaceholder> placeholders = null;
    Combo placeholderCombo = null;

    protected PlaceholderContentCreatorPanel() {
    }

    public void setPlaceholders(List<ContentPlaceholder> placeholders) {
        this.placeholders = new ArrayList<ContentPlaceholder>(placeholders);
        Collections.sort(this.placeholders, new Comparator<ContentPlaceholder>(){

            @Override
            public int compare(ContentPlaceholder o1, ContentPlaceholder o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public String getFormat() {
        return "Default";
    }

    @Override
    public final void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Label formatLabel = new Label(composite, 0);
        formatLabel.setText("Please select a placeholder:");
        formatLabel.setLayoutData((Object)new GridData(768));
        this.placeholderCombo = new Combo(composite, 12);
        for (ContentPlaceholder cp : this.placeholders) {
            this.placeholderCombo.add(cp.getName());
        }
        this.placeholderCombo.setLayoutData((Object)new GridData(768));
        this.placeholderCombo.select(0);
        final Text descText = new Text(composite, 72);
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 200;
        descText.setLayoutData((Object)layoutData);
        descText.setText(this.placeholders.get(0).getDescription());
        descText.setBackground(composite.getBackground());
        this.placeholderCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PlaceholderContentCreatorPanel.this.placeholderCombo.getSelectionIndex() > -1) {
                    descText.setText(((ContentPlaceholder)PlaceholderContentCreatorPanel.this.placeholders.get(PlaceholderContentCreatorPanel.this.placeholderCombo.getSelectionIndex())).getDescription());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)composite);
    }

    @Override
    public void setInitialContent(Content content) {
        if (content instanceof PlaceholderContent) {
            int i = 0;
            while (i < this.placeholders.size()) {
                if (this.placeholders.get(i).getName().equals(((PlaceholderContent)content).getPlaceholder())) {
                    this.placeholderCombo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public Content createContent() {
        PlaceholderContent content = new PlaceholderContent();
        content.setPlaceholder(this.placeholderCombo.getItem(this.placeholderCombo.getSelectionIndex() == -1 ? 0 : this.placeholderCombo.getSelectionIndex()));
        return content;
    }
}

