/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.media.core.ContentPlaceholder;
import org.eclipse.vtp.desktop.media.core.PromptBindingDialog;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewerListener;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.design.Variable;
import org.eclipse.vtp.desktop.model.interactive.core.IInteractiveWorkflowProject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProviderManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BindingItem;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BrandBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.LanguageBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.NamedBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingCase;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingEntry;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingItem;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingNode;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PromptBindingSwitch;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FileContent;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.PlaceholderContent;
import org.eclipse.vtp.framework.interactions.core.media.ReferencedContent;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;

public class PromptBindingViewer
implements MouseListener {
    NamedBinding namedBinding;
    BrandBinding brandBinding = null;
    IBrand currentBrand;
    String currentLanguage;
    Label contents;
    String interactionType;
    List<Variable> variables;
    List<ContentPlaceholder> placeholders = Collections.emptyList();
    List<PromptBindingViewerListener> listeners = new ArrayList<PromptBindingViewerListener>();
    private IDesignElement designElement = null;

    public PromptBindingViewer(IDesignElement designElement, NamedBinding namedBinding, String interactionType, List<Variable> variables) {
        this.namedBinding = namedBinding;
        this.interactionType = interactionType;
        this.variables = variables;
        this.designElement = designElement;
    }

    public void createControls(Composite parent) {
        this.contents = new Label(parent, 64);
        this.contents.setBackground(parent.getBackground());
        this.contents.setText("Not Configured");
        this.contents.addMouseListener((MouseListener)this);
    }

    public Control getControl() {
        return this.contents;
    }

    public void setCurrentLanguage(String language) {
        this.currentLanguage = language;
        if (this.currentBrand != null) {
            this.setContents();
        }
    }

    public void setCurrentBrand(IBrand brand) {
        this.currentBrand = brand;
        if (this.currentLanguage != null) {
            this.setContents();
        }
    }

    public void setPlaceholders(List<ContentPlaceholder> placeholders) {
        this.placeholders = placeholders;
    }

    private void setContents() {
        StringBuffer buf = new StringBuffer();
        LanguageBinding languageBinding = this.namedBinding.getLanguageBinding(this.currentLanguage);
        this.brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        PromptBindingItem pbi = (PromptBindingItem)this.brandBinding.getBindingItem();
        if (pbi != null) {
            List entries = pbi.getEntries();
            for (PromptBindingNode pbie : entries) {
                this.calculateContents(buf, pbie);
            }
        }
        this.contents.setText(buf.length() < 1 ? "Not Configured" : buf.toString());
        this.contents.getParent().layout();
    }

    private void calculateContents(StringBuffer buf, PromptBindingNode node) {
        if (node instanceof PromptBindingSwitch) {
            PromptBindingSwitch branch = (PromptBindingSwitch)node;
            boolean first = true;
            for (PromptBindingCase child : branch.getChildren()) {
                if (child.getCondition() == null) {
                    if (!first) {
                        buf.append("ELSE { ");
                    }
                    for (PromptBindingNode c : child.getChildren()) {
                        this.calculateContents(buf, c);
                    }
                    if (!first) {
                        buf.append(" } ");
                    }
                } else if (first) {
                    buf.append("IF (");
                    buf.append(child.getCondition());
                    buf.append(") { ");
                    for (PromptBindingNode c : child.getChildren()) {
                        this.calculateContents(buf, c);
                    }
                    buf.append(" } ");
                } else {
                    buf.append("ELSE IF (");
                    buf.append(child.getCondition());
                    buf.append(") { ");
                    for (PromptBindingNode c : child.getChildren()) {
                        this.calculateContents(buf, c);
                    }
                    buf.append(" } ");
                }
                first = false;
            }
        } else if (node instanceof PromptBindingCase) {
            for (PromptBindingNode c : ((PromptBindingCase)node).getChildren()) {
                this.calculateContents(buf, c);
            }
        } else if (node instanceof PromptBindingEntry) {
            PromptBindingEntry pbie = (PromptBindingEntry)node;
            Content content = pbie.getContent();
            if (content instanceof FormattableContent) {
                FormattableContent fc = (FormattableContent)content;
                buf.append(String.valueOf(fc.getContentTypeName()) + "(" + fc.getFormatName() + ", " + fc.getValue() + ")");
            } else if (content instanceof TextContent) {
                String tc = ((TextContent)content).getText();
                boolean allWhite = true;
                char[] chars = tc.toCharArray();
                int ic = 0;
                while (ic < chars.length) {
                    if (!Character.isWhitespace(chars[ic])) {
                        allWhite = false;
                    }
                    ++ic;
                }
                buf.append(allWhite ? "TEXT(" + tc + ")" : tc);
            } else if (content instanceof ReferencedContent) {
                buf.append("REFERENCE(" + ((ReferencedContent)content).getReferencedName() + ")");
            } else if (content instanceof FileContent) {
                FileContent fc = (FileContent)content;
                buf.append(String.valueOf(fc.getFileTypeName()) + "(" + fc.getPath() + ")");
            } else if (content instanceof PlaceholderContent) {
                buf.append("Placeholder(");
                buf.append(((PlaceholderContent)content).getPlaceholder());
                buf.append(")");
            }
            buf.append(' ');
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        try {
            IMediaProviderManager mediaProviderManager = ((IInteractiveWorkflowProject)this.designElement.getDesign().getDocument().getProject()).getMediaProviderManager();
            IMediaProvider mediaProvider = mediaProviderManager.getMediaProvider(this.interactionType, this.currentBrand, this.currentLanguage);
            if (mediaProvider == null) {
                this.fireInvalidAttempt();
                return;
            }
            Shell workbenchShell = Display.getCurrent().getActiveShell();
            PromptBindingDialog pbd = new PromptBindingDialog(workbenchShell);
            pbd.setPlaceholders(this.placeholders);
            PromptBindingItem pbi = (PromptBindingItem)this.brandBinding.getBindingItem();
            pbi = pbi == null ? new PromptBindingItem() : (PromptBindingItem)pbi.clone();
            pbd.setPromptBinding(pbi, mediaProviderManager.getMediaProvider(this.interactionType, this.currentBrand, this.currentLanguage));
            pbd.setMediaProvider(mediaProvider);
            pbd.setVariables(this.variables);
            int result = pbd.open();
            if (result == 0) {
                pbi = pbd.getPromptBindingItem();
                this.brandBinding.setBindingItem((BindingItem)(pbi.getEntries().size() < 1 ? null : pbi));
                this.setContents();
                this.fireChange();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void addListener(PromptBindingViewerListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(PromptBindingViewerListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChange() {
        for (PromptBindingViewerListener listener : this.listeners) {
            listener.valueChanged(this);
        }
    }

    private void fireInvalidAttempt() {
        for (PromptBindingViewerListener listener : this.listeners) {
            listener.invalidConfigurationAttempt(this);
        }
    }
}

