/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.voice.mediascreens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.media.core.GrammarBindingViewer;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreenContainer;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewer;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewerListener;
import org.eclipse.vtp.desktop.media.core.ValueControl;
import org.eclipse.vtp.desktop.media.core.ValueStack;
import org.eclipse.vtp.desktop.media.core.ValueStackListener;
import org.eclipse.vtp.desktop.media.voice.mediascreens.NewMenuChoiceWizard;
import org.eclipse.vtp.desktop.media.voice.mediascreens.RenameMenuChoiceWizard;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.elements.core.internal.PrimitiveElement;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BindingItem;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BrandBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.GenericBindingManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.InteractionBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.LanguageBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.NamedBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.PropertyBindingItem;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MenuChoice;
import org.eclipse.vtp.modules.interactive.ui.OptionSetInformationProvider;
import org.eclipse.vtp.modules.interactive.ui.dialogs.MenuOptionScriptDialog;
import org.eclipse.vtp.modules.interactive.ui.properties.MenuChoiceBindingManager;

public class OptionSetMediaScreen
extends MediaConfigurationScreen
implements PromptBindingViewerListener {
    private static final String elementType = "org.eclipse.vtp.modules.interactive.optionSet";
    private FormToolkit toolkit;
    MenuChoiceBindingManager mcBindingManager;
    GenericBindingManager genericManager;
    InteractionBinding interactionBinding = null;
    OptionSetInformationProvider info = null;
    Section contentSection = null;
    Composite comp = null;
    Composite mediaComposite = null;
    ScrolledComposite sc = null;
    Control addOptionComposite;
    Font boldFont = null;
    Color dividerColor;
    List<Control> dtmfWidgets = new ArrayList<Control>();
    List<Control> voiceWidgets = new ArrayList<Control>();
    Map<MenuChoice, ToolItem> moveUpButtons = new HashMap<MenuChoice, ToolItem>();
    Map<MenuChoice, ToolItem> moveDownButtons = new HashMap<MenuChoice, ToolItem>();
    Map<MenuChoice, List<Control>> optionControlMap = new HashMap<MenuChoice, List<Control>>();
    Map<MenuChoice, PromptBindingViewer> optionPromptMap = new HashMap<MenuChoice, PromptBindingViewer>();
    Map<MenuChoice, GrammarBindingViewer> optionGrammarMap = new HashMap<MenuChoice, GrammarBindingViewer>();
    MouseListener focusMaster = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            OptionSetMediaScreen.this.comp.forceFocus();
        }

        public void mouseUp(MouseEvent e) {
        }
    };
    Map<String, ValueStack> valueStacks = new HashMap<String, ValueStack>();
    IBrand currentBrand = null;
    String currentLanguage = null;

    public OptionSetMediaScreen(MediaConfigurationScreenContainer container) {
        super(container);
        this.mcBindingManager = (MenuChoiceBindingManager)this.getElement().getConfigurationManager("org.eclipse.vtp.configuration.menuchoice");
        this.genericManager = (GenericBindingManager)this.getElement().getConfigurationManager("org.eclipse.vtp.configuration.generic");
        this.interactionBinding = this.genericManager.getInteractionBinding(this.getInteractionType());
        this.info = (OptionSetInformationProvider)((PrimitiveElement)container.getDesignElement()).getInformationProvider();
    }

    public void save() {
        for (ValueStack dvs : this.valueStacks.values()) {
            dvs.save();
        }
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.genericManager);
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.mcBindingManager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.genericManager);
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.mcBindingManager);
    }

    public void createControls(Composite parent) {
        GridData gd;
        GridData gd2;
        this.boldFont = new Font((Device)parent.getDisplay(), parent.getFont().getFontData()[0].getName(), parent.getFont().getFontData()[0].getHeight(), 1);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.getVerticalBar().setIncrement(30);
        this.sc.getVerticalBar().setPageIncrement(275);
        this.comp = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)this.comp);
        this.comp.addMouseListener(this.focusMaster);
        this.comp.setBackground(parent.getBackground());
        this.comp.setLayout((Layout)new GridLayout(1, false));
        this.mediaComposite = new Composite(this.comp, 0);
        this.mediaComposite.setBackground(this.comp.getBackground());
        this.mediaComposite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 1;
        this.mediaComposite.setLayout((Layout)gridLayout);
        this.contentSection = this.toolkit.createSection(this.mediaComposite, 256);
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        this.contentSection.setLayoutData((Object)gridData);
        this.contentSection.setText("Options");
        this.addOptionComposite = this.createPropertyLabel(this.mediaComposite, "");
        Composite containerComp = this.createWrapperComposite(this.mediaComposite);
        Button addOptionButton = new Button(containerComp, 8);
        addOptionButton.setText("Add Option");
        addOptionButton.setLayoutData((Object)new GridData());
        addOptionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewMenuChoiceWizard nmo = new NewMenuChoiceWizard(OptionSetMediaScreen.this.currentBrand, OptionSetMediaScreen.this.info, OptionSetMediaScreen.this.mcBindingManager);
                WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)nmo);
                if (wd.open() == 0) {
                    OptionSetMediaScreen.this.setBrand(OptionSetMediaScreen.this.currentBrand);
                    OptionSetMediaScreen.this.setLanguage(OptionSetMediaScreen.this.currentLanguage);
                }
            }
        });
        Composite spacerComp = new Composite(this.mediaComposite, 0);
        spacerComp.setBackground(this.mediaComposite.getBackground());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 15;
        spacerComp.setLayoutData((Object)gridData);
        Composite settingsComposite = new Composite(this.comp, 0);
        settingsComposite.setBackground(this.comp.getBackground());
        settingsComposite.setLayoutData((Object)new GridData(768));
        settingsComposite.setLayout((Layout)new GridLayout(2, false));
        Section settingsSection = this.toolkit.createSection(settingsComposite, 256);
        gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        settingsSection.setLayoutData((Object)gridData);
        settingsSection.setText("Settings");
        Label inputModeLabel = this.createPropertyLabel(settingsComposite, "User Input Style");
        inputModeLabel.setToolTipText("This property selects the valid ways\r\na caller can provide input:\r\n\t*DTMF - Touchtone keypad only\t*Voice - Speech recognition only\t*Hybrid - Touchtone or speech accepted");
        containerComp = this.createWrapperComposite(settingsComposite);
        ValueStack lastStack = new ValueStack("input-mode", this.getInteractionType(), elementType, "Dtmf Only", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("input-mode", lastStack);
        final Combo inputModeCombo = this.createValueDropDown(containerComp);
        inputModeCombo.add("Dtmf Only");
        inputModeCombo.add("Voice Only");
        inputModeCombo.add("Hybrid");
        inputModeCombo.select(0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return inputModeCombo.getItem(inputModeCombo.getSelectionIndex());
            }

            public void setValue(String value) {
                if (value == null) {
                    inputModeCombo.select(0);
                } else if ("Voice Only".equals(value)) {
                    inputModeCombo.select(1);
                } else if ("Hybrid".equals(value)) {
                    inputModeCombo.select(2);
                } else {
                    inputModeCombo.select(0);
                }
                OptionSetMediaScreen.this.updateInputMode();
            }
        });
        lastStack.addListener(new ValueStackListener(){

            public void valueTypeChanged(ValueStack valueStack) {
                OptionSetMediaScreen.this.updateInputMode();
            }
        });
        inputModeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OptionSetMediaScreen.this.updateInputMode();
            }
        });
        Label bargeLabel = this.createPropertyLabel(settingsComposite, "Barge-in Enabled");
        bargeLabel.setToolTipText("Determines whether the caller can\r\ninterrupt the prompt to begin entry");
        containerComp = this.createWrapperComposite(settingsComposite);
        lastStack = new ValueStack("barge-in", this.getInteractionType(), elementType, "true", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("barge-in", lastStack);
        final Combo barginCombo = this.createValueDropDown(containerComp);
        barginCombo.add("true");
        barginCombo.add("false");
        barginCombo.select(0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return barginCombo.getItem(barginCombo.getSelectionIndex());
            }

            public void setValue(String value) {
                if (value == null) {
                    barginCombo.select(0);
                } else if ("true".equals(value)) {
                    barginCombo.select(0);
                } else if ("false".equals(value)) {
                    barginCombo.select(1);
                } else {
                    barginCombo.select(0);
                }
            }
        });
        Label initialTimeoutLabel = this.createPropertyLabel(settingsComposite, "Initial Input Timeout (Seconds)");
        initialTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor the caller to begin input before\r\na NoInput event.");
        containerComp = this.createWrapperComposite(settingsComposite);
        lastStack = new ValueStack("initial-timeout", this.getInteractionType(), elementType, "3", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("initial-timeout", lastStack);
        final Spinner initialTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(initialTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                initialTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label interdigitTimeoutLabel = this.createPropertyLabel(settingsComposite, "Interdigit Timeout (Seconds)");
        interdigitTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional touchtone if the current\r\ninput does not match the grammar before\r\na NoMatch event.");
        this.dtmfWidgets.add((Control)interdigitTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.dtmfWidgets.add((Control)containerComp);
        lastStack = new ValueStack("interdigit-timeout", this.getInteractionType(), elementType, "2", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("interdigit-timeout", lastStack);
        final Spinner interdigitTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(interdigitTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                interdigitTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label terminationTimeoutLabel = this.createPropertyLabel(settingsComposite, "Termination Timeout (Seconds)");
        terminationTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input after a selection\r\nhas been matched.");
        this.dtmfWidgets.add((Control)terminationTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.dtmfWidgets.add((Control)containerComp);
        lastStack = new ValueStack("termination-timeout", this.getInteractionType(), elementType, "3", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("termination-timeout", lastStack);
        final Spinner terminationTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(terminationTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                terminationTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label speechIncompleteTimeoutLabel = this.createPropertyLabel(settingsComposite, "Speech Incomplete Timeout (Seconds)");
        speechIncompleteTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input if the current entry\r\ndoes not match the provided grammar.");
        this.voiceWidgets.add((Control)speechIncompleteTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("speech-incomplete-timeout", this.getInteractionType(), elementType, "1", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("speech-incomplete-timeout", lastStack);
        final Spinner speechIncompleteTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(speechIncompleteTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                speechIncompleteTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label speechCompleteTimeoutLabel = this.createPropertyLabel(settingsComposite, "Speech Completion Timeout (Seconds)");
        speechCompleteTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input if the current entry\r\nalready matches the provided grammar.");
        this.voiceWidgets.add((Control)speechCompleteTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("speech-complete-timeout", this.getInteractionType(), elementType, "1", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("speech-complete-timeout", lastStack);
        final Spinner speechCompleteTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(speechCompleteTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                speechCompleteTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label maxSpeechTimeoutLabel = this.createPropertyLabel(settingsComposite, "Maximum Speech Length (Seconds)");
        maxSpeechTimeoutLabel.setToolTipText("The maximum length of speech input\r\nin seconds that will be accepted.");
        this.voiceWidgets.add((Control)maxSpeechTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("max-speech-timeout", this.getInteractionType(), elementType, "300", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("max-speech-timeout", lastStack);
        final Spinner maxSpeechTimeoutSpinner = this.createValueSpinner(containerComp, 10, 300, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(maxSpeechTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                maxSpeechTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label confidenceLevelLabel = this.createPropertyLabel(settingsComposite, "Confidence Level Accepted");
        confidenceLevelLabel.setToolTipText("The minimum level of confidence accepted\r\nby the speech recognition provider.");
        this.voiceWidgets.add((Control)confidenceLevelLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("confidence-level", this.getInteractionType(), elementType, "50", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("confidence-level", lastStack);
        final Spinner confidenceLevelSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(confidenceLevelSpinner.getSelection());
            }

            public void setValue(String value) {
                confidenceLevelSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label sensitivityLabel = this.createPropertyLabel(settingsComposite, "Caller Environment");
        sensitivityLabel.setToolTipText("Determines how sensitive the speech recognition\r\nwill be to background noise.  The lower the number,\r\nthe less senitive the system will be");
        this.voiceWidgets.add((Control)sensitivityLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("sensitivity-level", this.getInteractionType(), elementType, "50", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("sensitivity-level", lastStack);
        final Spinner sensitivitySpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(sensitivitySpinner.getSelection());
            }

            public void setValue(String value) {
                sensitivitySpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label speedVsAccuracyLabel = this.createPropertyLabel(settingsComposite, "Speed Vs Accuracy");
        speedVsAccuracyLabel.setToolTipText("A hint to the speech recognition platform indicating\r\nrelative focus between the speed in which the result\r\nis returned and the accuracy of that result.  The\r\nlower the number, the faster the entry is processed\r\nbut accuracy may be reduced.");
        this.voiceWidgets.add((Control)speedVsAccuracyLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add((Control)containerComp);
        lastStack = new ValueStack("speed-vs-accuracy", this.getInteractionType(), elementType, "50", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("speed-vs-accuracy", lastStack);
        final Spinner speedVsAccuracySpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(speedVsAccuracySpinner.getSelection());
            }

            public void setValue(String value) {
                speedVsAccuracySpinner.setSelection(Integer.parseInt(value));
            }
        });
        this.comp.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                OptionSetMediaScreen.this.comp.removeControlListener((ControlListener)this);
                OptionSetMediaScreen.this.sc.setAlwaysShowScrollBars(true);
                Rectangle clientArea = OptionSetMediaScreen.this.sc.getClientArea();
                OptionSetMediaScreen.this.sc.setAlwaysShowScrollBars(false);
                if (OptionSetMediaScreen.this.sc.getVerticalBar() != null) {
                    OptionSetMediaScreen.this.sc.getVerticalBar().setVisible(false);
                }
                OptionSetMediaScreen.this.sc.setMinSize(new Point(clientArea.width, clientArea.height));
                OptionSetMediaScreen.this.sc.layout(true, true);
                OptionSetMediaScreen.this.sc.redraw();
            }
        });
        this.sc.setMinWidth(this.comp.computeSize((int)-1, (int)-1, (boolean)true).x);
        for (Control control : this.dtmfWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        for (Control control : this.voiceWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        int sel = inputModeCombo.getSelectionIndex();
        if (sel == 2 || sel == 0) {
            for (Control control : this.dtmfWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        if (sel == 2 || sel == 1) {
            for (Control control : this.voiceWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        this.sc.setMinHeight(this.comp.computeSize((int)-1, (int)-1, (boolean)true).y);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.setControl((Control)this.sc);
        this.sc.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GridData gd;
                GridData gd2;
                for (Control control : OptionSetMediaScreen.this.dtmfWidgets) {
                    gd2 = (GridData)control.getLayoutData();
                    control.setVisible(false);
                    gd2.exclude = true;
                }
                for (Control control : OptionSetMediaScreen.this.voiceWidgets) {
                    gd2 = (GridData)control.getLayoutData();
                    control.setVisible(false);
                    gd2.exclude = true;
                }
                int sel = inputModeCombo.getSelectionIndex();
                if (sel == 2 || sel == 0) {
                    for (Control control : OptionSetMediaScreen.this.dtmfWidgets) {
                        gd = (GridData)control.getLayoutData();
                        control.setVisible(true);
                        gd.exclude = false;
                    }
                }
                if (sel == 2 || sel == 1) {
                    for (Control control : OptionSetMediaScreen.this.voiceWidgets) {
                        gd = (GridData)control.getLayoutData();
                        control.setVisible(true);
                        gd.exclude = false;
                    }
                }
                Point preferred = OptionSetMediaScreen.this.comp.computeSize(OptionSetMediaScreen.this.sc.getMinWidth(), -1, true);
                OptionSetMediaScreen.this.sc.setMinSize(preferred);
                OptionSetMediaScreen.this.comp.layout();
                if (preferred.y > OptionSetMediaScreen.this.sc.getClientArea().height) {
                    preferred = OptionSetMediaScreen.this.comp.computeSize(OptionSetMediaScreen.this.sc.getClientArea().width, -1, true);
                    OptionSetMediaScreen.this.sc.setMinSize(preferred);
                    OptionSetMediaScreen.this.comp.layout();
                }
            }
        });
    }

    public String getInteractionType() {
        return "org.eclipse.vtp.framework.interactions.voice.interaction";
    }

    public void setLanguage(String language) {
        this.currentLanguage = language;
        if (this.currentBrand != null) {
            this.updateValues();
        }
    }

    public void setBrand(IBrand brand) {
        this.currentBrand = brand;
        if (this.currentLanguage != null) {
            this.updateValues();
        }
    }

    private void updateValues() {
        try {
            for (List<Control> controls : this.optionControlMap.values()) {
                for (Control control : controls) {
                    control.dispose();
                    this.dtmfWidgets.remove(control);
                    this.voiceWidgets.remove(control);
                }
            }
            this.moveUpButtons = new HashMap<MenuChoice, ToolItem>();
            this.moveDownButtons = new HashMap<MenuChoice, ToolItem>();
            this.optionControlMap = new HashMap<MenuChoice, List<Control>>();
            this.optionPromptMap = new HashMap<MenuChoice, PromptBindingViewer>();
            this.optionGrammarMap = new HashMap<MenuChoice, GrammarBindingViewer>();
            List options = this.mcBindingManager.getChoicesByBrand(this.currentBrand);
            int i = 0;
            while (i < options.size()) {
                MenuChoice mc = (MenuChoice)options.get(i);
                List<Control> createOptionControls = this.createOptionControls(this.mediaComposite, mc);
                for (Control control : createOptionControls) {
                    control.moveAbove(this.addOptionComposite);
                }
                this.optionControlMap.put(mc, createOptionControls);
                ++i;
            }
            for (PromptBindingViewer viewer : this.optionPromptMap.values()) {
                viewer.setCurrentBrand(this.currentBrand);
                viewer.setCurrentLanguage(this.currentLanguage);
            }
            for (GrammarBindingViewer viewer : this.optionGrammarMap.values()) {
                viewer.setCurrentBrand(this.currentBrand);
                viewer.setCurrentLanguage(this.currentLanguage);
            }
            NamedBinding namedBinding = this.interactionBinding.getNamedBinding("input-mode");
            LanguageBinding languageBinding = namedBinding.getLanguageBinding("");
            BrandBinding brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            ValueStack valueStack = this.valueStacks.get(namedBinding.getName());
            valueStack.setSetting(this.genericManager.getMediaDefaults(), brandBinding);
            namedBinding = this.interactionBinding.getNamedBinding("barge-in");
            languageBinding = namedBinding.getLanguageBinding("");
            brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            valueStack = this.valueStacks.get(namedBinding.getName());
            valueStack.setSetting(this.genericManager.getMediaDefaults(), brandBinding);
            namedBinding = this.interactionBinding.getNamedBinding("initial-timeout");
            languageBinding = namedBinding.getLanguageBinding("");
            brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            valueStack = this.valueStacks.get(namedBinding.getName());
            valueStack.setSetting(this.genericManager.getMediaDefaults(), brandBinding);
            namedBinding = this.interactionBinding.getNamedBinding("interdigit-timeout");
            languageBinding = namedBinding.getLanguageBinding("");
            brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            valueStack = this.valueStacks.get(namedBinding.getName());
            valueStack.setSetting(this.genericManager.getMediaDefaults(), brandBinding);
            namedBinding = this.interactionBinding.getNamedBinding("termination-timeout");
            languageBinding = namedBinding.getLanguageBinding("");
            brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            valueStack = this.valueStacks.get(namedBinding.getName());
            valueStack.setSetting(this.genericManager.getMediaDefaults(), brandBinding);
            namedBinding = this.interactionBinding.getNamedBinding("speech-incomplete-timeout");
            languageBinding = namedBinding.getLanguageBinding("");
            brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            valueStack = this.valueStacks.get(namedBinding.getName());
            valueStack.setSetting(this.genericManager.getMediaDefaults(), brandBinding);
            namedBinding = this.interactionBinding.getNamedBinding("speech-complete-timeout");
            languageBinding = namedBinding.getLanguageBinding("");
            brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            valueStack = this.valueStacks.get(namedBinding.getName());
            valueStack.setSetting(this.genericManager.getMediaDefaults(), brandBinding);
            namedBinding = this.interactionBinding.getNamedBinding("max-speech-timeout");
            languageBinding = namedBinding.getLanguageBinding("");
            brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            valueStack = this.valueStacks.get(namedBinding.getName());
            valueStack.setSetting(this.genericManager.getMediaDefaults(), brandBinding);
            namedBinding = this.interactionBinding.getNamedBinding("confidence-level");
            languageBinding = namedBinding.getLanguageBinding("");
            brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            valueStack = this.valueStacks.get(namedBinding.getName());
            valueStack.setSetting(this.genericManager.getMediaDefaults(), brandBinding);
            namedBinding = this.interactionBinding.getNamedBinding("sensitivity-level");
            languageBinding = namedBinding.getLanguageBinding("");
            brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            valueStack = this.valueStacks.get(namedBinding.getName());
            valueStack.setSetting(this.genericManager.getMediaDefaults(), brandBinding);
            namedBinding = this.interactionBinding.getNamedBinding("speed-vs-accuracy");
            languageBinding = namedBinding.getLanguageBinding("");
            brandBinding = languageBinding.getBrandBinding(this.currentBrand);
            valueStack = this.valueStacks.get(namedBinding.getName());
            valueStack.setSetting(this.genericManager.getMediaDefaults(), brandBinding);
            this.updateButtons();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateInputMode() {
        GridData gd;
        GridData gd2;
        for (Control control : this.dtmfWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        for (Control control : this.voiceWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        String sel = this.valueStacks.get("input-mode").getValue();
        if (sel.equals("Hybrid") || sel.equals("Dtmf Only")) {
            for (Control control : this.dtmfWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        if (sel.equals("Hybrid") || sel.equals("Voice Only")) {
            for (Control control : this.voiceWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        Point preferred = this.comp.computeSize(this.sc.getMinWidth(), -1, true);
        this.sc.setMinSize(preferred);
        this.comp.layout();
        if (preferred.y > this.sc.getClientArea().height) {
            preferred = this.comp.computeSize(this.sc.getClientArea().width, -1, true);
            this.sc.setMinSize(preferred);
            this.comp.layout();
        }
        this.comp.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                OptionSetMediaScreen.this.comp.layout(true, true);
            }
        });
    }

    public Composite createWrapperComposite(Composite parent) {
        return this.createWrapperComposite(parent, 20);
    }

    public Composite createWrapperComposite(Composite parent, int indent) {
        Composite containerComp = new Composite(parent, 0);
        containerComp.addMouseListener(this.focusMaster);
        containerComp.setBackground(parent.getBackground());
        GridData gridData = new GridData(802);
        gridData.horizontalIndent = indent;
        gridData.widthHint = 175;
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        containerComp.setLayout((Layout)gl);
        containerComp.setLayoutData((Object)gridData);
        return containerComp;
    }

    public Label createOptionLabel(Composite parent, final MenuChoice option) {
        Label ret = new Label(parent, 0);
        ret.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                String oldName = option.getOptionName();
                RenameMenuChoiceWizard rmo = new RenameMenuChoiceWizard(OptionSetMediaScreen.this.currentBrand, option, OptionSetMediaScreen.this.mcBindingManager);
                WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)rmo);
                if (wd.open() == 0) {
                    OptionSetMediaScreen.this.setBrand(OptionSetMediaScreen.this.currentBrand);
                    OptionSetMediaScreen.this.setLanguage(OptionSetMediaScreen.this.currentLanguage);
                }
                if (!oldName.equals(option.getOptionName())) {
                    OptionSetMediaScreen.this.info.updateChoice(option, oldName);
                    String[] bindingTypes = new String[]{"-dtmf", "-grammar", "-prompt", "-silent"};
                    int b = 0;
                    while (b < bindingTypes.length) {
                        OptionSetMediaScreen.this.genericManager.renameNamedBinding(OptionSetMediaScreen.this.getInteractionType(), String.valueOf(oldName) + bindingTypes[b], String.valueOf(option.getOptionName()) + bindingTypes[b]);
                        OptionSetMediaScreen.this.updateValues();
                        ++b;
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
                OptionSetMediaScreen.this.comp.forceFocus();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        ret.setText(option.getOptionName());
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 10;
        gd.minimumHeight = 21;
        gd.heightHint = 21;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.addMouseListener(this.focusMaster);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 30;
        gd.minimumHeight = 21;
        gd.heightHint = 21;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public RowDivider createRowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    private Combo createValueDropDown(Composite parent) {
        Combo ret = new Combo(parent, 2060);
        GridData gd = new GridData();
        gd.verticalIndent = 1;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 2048);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 1;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public List<Control> createOptionControls(final Composite canvas, final MenuChoice option) {
        ArrayList<Control> controlList = new ArrayList<Control>();
        Label option1Label = this.createOptionLabel(canvas, option);
        option1Label.setFont(this.boldFont);
        controlList.add((Control)option1Label);
        Composite optHeaderComp = new Composite(canvas, 0);
        FillLayout fl = new FillLayout();
        optHeaderComp.setLayout((Layout)fl);
        optHeaderComp.setBackground(canvas.getBackground());
        if (this.moveUpButtons == null) {
            this.moveUpButtons = new HashMap<MenuChoice, ToolItem>();
            this.moveDownButtons = new HashMap<MenuChoice, ToolItem>();
        }
        ToolBar tb = new ToolBar(optHeaderComp, 0x800000);
        tb.setBackground(optHeaderComp.getBackground());
        ToolItem guardScriptButton = new ToolItem(tb, 8);
        if (!"".equals(option.getScriptText()) || option.getScriptText() == null) {
            guardScriptButton.setImage(Activator.getDefault().getImageRegistry().get("ICON_SCRIPT"));
        } else {
            guardScriptButton.setImage(Activator.getDefault().getImageRegistry().get("ICON_NOSCRIPT"));
        }
        guardScriptButton.setToolTipText("Edit Guard Condition");
        guardScriptButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MenuOptionScriptDialog mosd = new MenuOptionScriptDialog(Display.getCurrent().getActiveShell());
                    mosd.setMenuChoice(option);
                    mosd.open();
                    OptionSetMediaScreen.this.updateValues();
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem moveUpButton = new ToolItem(tb, 8);
        moveUpButton.setImage(Activator.getDefault().getImageRegistry().get("ICON_MOVE_UP"));
        moveUpButton.setToolTipText("Move Option Up");
        this.moveUpButtons.put(option, moveUpButton);
        moveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List currentOptions = OptionSetMediaScreen.this.mcBindingManager.getChoicesByBrand(OptionSetMediaScreen.this.currentBrand);
                MenuChoice targetOption = null;
                int i = 0;
                while (i < currentOptions.size()) {
                    if (currentOptions.get(i) == option && i != 0) {
                        targetOption = (MenuChoice)currentOptions.get(i - 1);
                    }
                    ++i;
                }
                if (targetOption != null) {
                    List<Control> targetControlList = OptionSetMediaScreen.this.optionControlMap.get(targetOption);
                    List<Control> mobileControlList = OptionSetMediaScreen.this.optionControlMap.get(option);
                    int i2 = 0;
                    while (i2 < mobileControlList.size()) {
                        mobileControlList.get(i2).moveAbove(targetControlList.get(0));
                        ++i2;
                    }
                    OptionSetMediaScreen.this.mcBindingManager.moveChoiceUp(OptionSetMediaScreen.this.currentBrand.getName(), option);
                    OptionSetMediaScreen.this.updateButtons();
                    canvas.layout(true, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem moveDownButton = new ToolItem(tb, 8);
        moveDownButton.setImage(Activator.getDefault().getImageRegistry().get("ICON_MOVE_DOWN"));
        moveDownButton.setToolTipText("Move Option Down");
        this.moveDownButtons.put(option, moveDownButton);
        moveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List currentOptions = OptionSetMediaScreen.this.mcBindingManager.getChoicesByBrand(OptionSetMediaScreen.this.currentBrand);
                MenuChoice targetOption = option;
                MenuChoice mobileOption = null;
                int i = 0;
                while (i < currentOptions.size()) {
                    if (currentOptions.get(i) == option && i < currentOptions.size() - 1) {
                        mobileOption = (MenuChoice)currentOptions.get(i + 1);
                    }
                    ++i;
                }
                if (mobileOption != null) {
                    List<Control> targetControlList = OptionSetMediaScreen.this.optionControlMap.get(targetOption);
                    List<Control> mobileControlList = OptionSetMediaScreen.this.optionControlMap.get(mobileOption);
                    int i2 = 0;
                    while (i2 < mobileControlList.size()) {
                        mobileControlList.get(i2).moveAbove(targetControlList.get(0));
                        ++i2;
                    }
                    OptionSetMediaScreen.this.mcBindingManager.moveChoiceDown(OptionSetMediaScreen.this.currentBrand.getName(), option);
                    OptionSetMediaScreen.this.updateButtons();
                    canvas.layout(true, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem deleteButton = new ToolItem(tb, 8);
        deleteButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        deleteButton.setToolTipText("Remove Option");
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List<Control> controlList = OptionSetMediaScreen.this.optionControlMap.get(option);
                OptionSetMediaScreen.this.moveUpButtons.remove(option);
                OptionSetMediaScreen.this.moveDownButtons.remove(option);
                OptionSetMediaScreen.this.optionPromptMap.remove(option);
                OptionSetMediaScreen.this.optionGrammarMap.remove(option);
                for (Control control : controlList) {
                    control.dispose();
                    OptionSetMediaScreen.this.dtmfWidgets.remove(control);
                    OptionSetMediaScreen.this.voiceWidgets.remove(control);
                }
                OptionSetMediaScreen.this.optionControlMap.remove(option);
                OptionSetMediaScreen.this.info.removeChoice(OptionSetMediaScreen.this.currentBrand.getName(), option, OptionSetMediaScreen.this.mcBindingManager.removeChoice(OptionSetMediaScreen.this.currentBrand.getName(), option));
                OptionSetMediaScreen.this.updateButtons();
                canvas.layout(true, true);
                OptionSetMediaScreen.this.comp.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        optHeaderComp.setLayoutData((Object)gd);
        controlList.add((Control)optHeaderComp);
        this.dividerColor = new Color((Device)Display.getCurrent(), 231, 233, 240);
        this.comp.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OptionSetMediaScreen.this.dividerColor.dispose();
                OptionSetMediaScreen.this.boldFont.dispose();
            }
        });
        RowDivider ord1 = this.createRowDivider(canvas, this.dividerColor);
        controlList.add((Control)ord1);
        Label optionPromptLabel = this.createPropertyLabel(canvas, "Prompt");
        controlList.add((Control)optionPromptLabel);
        NamedBinding promptBinding = this.interactionBinding.getNamedBinding(String.valueOf(option.getOptionName()) + "-prompt");
        PromptBindingViewer optionPromptText = new PromptBindingViewer(this.getElement(), promptBinding, this.getInteractionType(), this.getElement().getDesign().getVariablesFor(this.getElement()));
        Composite containerComp = this.createWrapperComposite(canvas, 100);
        optionPromptText.createControls(containerComp);
        optionPromptText.addListener((PromptBindingViewerListener)this);
        gd = new GridData(128);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        optionPromptText.getControl().setLayoutData((Object)gd);
        this.optionPromptMap.put(option, optionPromptText);
        controlList.add((Control)containerComp);
        ord1 = this.createRowDivider(canvas, this.dividerColor);
        controlList.add((Control)ord1);
        this.voiceWidgets.add((Control)ord1);
        Label optionGrammarLabel = this.createPropertyLabel(canvas, "Grammar");
        controlList.add((Control)optionGrammarLabel);
        this.voiceWidgets.add((Control)optionGrammarLabel);
        NamedBinding grammarBinding = this.interactionBinding.getNamedBinding(String.valueOf(option.getOptionName()) + "-grammar");
        GrammarBindingViewer grammarPromptText = new GrammarBindingViewer(this.getElement(), grammarBinding, this.getInteractionType());
        gd = new GridData(768);
        gd.horizontalAlignment = 131072;
        grammarPromptText.createControls(canvas);
        grammarPromptText.getControl().setLayoutData((Object)gd);
        this.optionGrammarMap.put(option, grammarPromptText);
        controlList.add(grammarPromptText.getControl());
        this.voiceWidgets.add(grammarPromptText.getControl());
        ord1 = this.createRowDivider(canvas, this.dividerColor);
        controlList.add((Control)ord1);
        this.dtmfWidgets.add((Control)ord1);
        Label optionDTMFLabel = this.createPropertyLabel(canvas, "DTMF Value");
        controlList.add((Control)optionDTMFLabel);
        this.dtmfWidgets.add((Control)optionDTMFLabel);
        final Combo dtmfCombo = this.createValueDropDown(canvas);
        dtmfCombo.add("0");
        dtmfCombo.add("1");
        dtmfCombo.add("2");
        dtmfCombo.add("3");
        dtmfCombo.add("4");
        dtmfCombo.add("5");
        dtmfCombo.add("6");
        dtmfCombo.add("7");
        dtmfCombo.add("8");
        dtmfCombo.add("9");
        dtmfCombo.add("*");
        dtmfCombo.add("#");
        NamedBinding dtmfNamedBinding = this.interactionBinding.getNamedBinding(String.valueOf(option.getOptionName()) + "-dtmf");
        LanguageBinding dtmfLanguageBinding = dtmfNamedBinding.getLanguageBinding("");
        BrandBinding dtmfBrandBinding = dtmfLanguageBinding.getBrandBinding(this.currentBrand);
        PropertyBindingItem pbi = (PropertyBindingItem)dtmfBrandBinding.getBindingItem();
        if (pbi == null) {
            pbi = new PropertyBindingItem();
        }
        if (pbi.getValue() == null) {
            dtmfCombo.select(0);
        } else if (pbi.getValue().equals("#")) {
            dtmfCombo.select(11);
        } else if (pbi.getValue().equals("*")) {
            dtmfCombo.select(10);
        } else {
            dtmfCombo.select(Integer.parseInt(pbi.getValue()));
        }
        dtmfCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NamedBinding dtmfNamedBinding = OptionSetMediaScreen.this.interactionBinding.getNamedBinding(String.valueOf(option.getOptionName()) + "-dtmf");
                LanguageBinding dtmfLanguageBinding = dtmfNamedBinding.getLanguageBinding("");
                BrandBinding dtmfBrandBinding = dtmfLanguageBinding.getBrandBinding(OptionSetMediaScreen.this.currentBrand);
                PropertyBindingItem pbi = (PropertyBindingItem)dtmfBrandBinding.getBindingItem();
                pbi = pbi == null ? new PropertyBindingItem() : (PropertyBindingItem)pbi.clone();
                pbi.setValue(dtmfCombo.getItem(dtmfCombo.getSelectionIndex()));
                dtmfBrandBinding.setBindingItem((BindingItem)pbi);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        controlList.add((Control)dtmfCombo);
        this.dtmfWidgets.add((Control)dtmfCombo);
        ord1 = this.createRowDivider(canvas, this.dividerColor);
        controlList.add((Control)ord1);
        Label optionSilentLabel = this.createPropertyLabel(canvas, "Option is Silent");
        controlList.add((Control)optionSilentLabel);
        final Combo silentCombo = this.createValueDropDown(canvas);
        silentCombo.add("true");
        silentCombo.add("false");
        NamedBinding silentNamedBinding = this.interactionBinding.getNamedBinding(String.valueOf(option.getOptionName()) + "-silent");
        LanguageBinding silentLanguageBinding = silentNamedBinding.getLanguageBinding("");
        BrandBinding silentBrandBinding = silentLanguageBinding.getBrandBinding(this.currentBrand);
        pbi = (PropertyBindingItem)silentBrandBinding.getBindingItem();
        if (pbi == null) {
            pbi = new PropertyBindingItem();
        }
        if (pbi.getValue() == null) {
            silentCombo.select(1);
        } else if (pbi.getValue().equals("true")) {
            silentCombo.select(0);
        } else {
            silentCombo.select(1);
        }
        silentCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NamedBinding silentNamedBinding = OptionSetMediaScreen.this.interactionBinding.getNamedBinding(String.valueOf(option.getOptionName()) + "-silent");
                LanguageBinding silentLanguageBinding = silentNamedBinding.getLanguageBinding("");
                BrandBinding silentBrandBinding = silentLanguageBinding.getBrandBinding(OptionSetMediaScreen.this.currentBrand);
                PropertyBindingItem pbi = (PropertyBindingItem)silentBrandBinding.getBindingItem();
                pbi = pbi == null ? new PropertyBindingItem() : (PropertyBindingItem)pbi.clone();
                pbi.setValue(silentCombo.getItem(silentCombo.getSelectionIndex()));
                silentBrandBinding.setBindingItem((BindingItem)pbi);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        controlList.add((Control)silentCombo);
        ord1 = this.createRowDivider(canvas, this.dividerColor);
        controlList.add((Control)ord1);
        return controlList;
    }

    public void updateButtons() {
        List currentOptions = this.mcBindingManager.getChoicesByBrand(this.currentBrand);
        int i = 0;
        while (i < currentOptions.size()) {
            MenuChoice lastOption = (MenuChoice)currentOptions.get(i);
            this.moveUpButtons.get(lastOption).setEnabled(i != 0);
            this.moveDownButtons.get(lastOption).setEnabled(i < currentOptions.size() - 1);
            ++i;
        }
    }

    public void valueChanged(PromptBindingViewer viewer) {
        GridData gd;
        GridData gd2;
        for (Control control : this.dtmfWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        for (Control control : this.voiceWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        String sel = this.valueStacks.get("input-mode").getValue();
        if (sel.equals("Hybrid") || sel.equals("Dtmf Only")) {
            for (Control control : this.dtmfWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        if (sel.equals("Hybrid") || sel.equals("Voice Only")) {
            for (Control control : this.voiceWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        Point preferred = this.comp.computeSize(this.sc.getMinWidth(), -1, true);
        this.sc.setMinSize(preferred);
        this.comp.layout();
        if (preferred.y > this.sc.getClientArea().height) {
            preferred = this.comp.computeSize(this.sc.getClientArea().width, -1, true);
            this.sc.setMinSize(preferred);
            this.comp.layout();
        }
        this.updateButtons();
    }

    public void invalidConfigurationAttempt(PromptBindingViewer viewer) {
        this.getContainer().cancelMediaConfiguration();
    }

    public class RowDivider
    extends Canvas
    implements PaintListener {
        public RowDivider(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
            this.addMouseListener(OptionSetMediaScreen.this.focusMaster);
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.drawLine(30, 1, size.x - 30, 1);
        }
    }
}

