/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.voice.mediascreens;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.vtp.desktop.media.core.DefaultValueStack;
import org.eclipse.vtp.desktop.media.core.IMediaDefaultPanel;
import org.eclipse.vtp.desktop.media.core.ValueControl;
import org.eclipse.vtp.desktop.model.interactive.core.mediadefaults.IMediaDefaultSettings;

public class PlayPromptMediaDefaultsPanel
implements IMediaDefaultPanel {
    private static final String interactionType = "org.eclipse.vtp.framework.interactions.voice.interaction";
    private static final String elementType = "org.eclipse.vtp.modules.interactive.playPrompt";
    IMediaDefaultSettings settings = null;
    Combo barginCombo = null;
    List<DefaultValueStack> valueStacks = new LinkedList<DefaultValueStack>();

    public Control createControls(Composite parent, boolean supportDefaults) {
        DefaultValueStack lastStack = null;
        Composite settingsComposite = new Composite(parent, 0);
        settingsComposite.setBackground(parent.getBackground());
        settingsComposite.setLayout((Layout)new GridLayout(2, false));
        Label panelLabel = new Label(settingsComposite, 0);
        panelLabel.setBackground(settingsComposite.getBackground());
        panelLabel.setText("Play Prompt");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        panelLabel.setLayoutData((Object)gridData);
        Label bargeLabel = this.createPropertyLabel(settingsComposite, "Barge-in Enabled");
        bargeLabel.setBackground(settingsComposite.getBackground());
        bargeLabel.setToolTipText("Determines whether the caller can\r\ninterrupt the prompt to begin entry");
        Composite containerComp = this.createWrapperComposite(settingsComposite);
        containerComp.setBackground(settingsComposite.getBackground());
        if (supportDefaults) {
            lastStack = new DefaultValueStack(interactionType, elementType, "barge-in");
            lastStack.createControls(containerComp);
            containerComp = lastStack.getValueComposite();
            this.valueStacks.add(lastStack);
        }
        this.barginCombo = this.createValueDropDown(containerComp);
        this.barginCombo.add("true");
        this.barginCombo.add("false");
        this.barginCombo.select(0);
        if (supportDefaults) {
            lastStack.setValueControl(new ValueControl(){

                public String getValue() {
                    return PlayPromptMediaDefaultsPanel.this.barginCombo.getItem(PlayPromptMediaDefaultsPanel.this.barginCombo.getSelectionIndex());
                }

                public void setValue(String value) {
                    if (value == null) {
                        PlayPromptMediaDefaultsPanel.this.barginCombo.select(0);
                    } else if ("true".equals(value)) {
                        PlayPromptMediaDefaultsPanel.this.barginCombo.select(0);
                    } else if ("false".equals(value)) {
                        PlayPromptMediaDefaultsPanel.this.barginCombo.select(1);
                    } else {
                        PlayPromptMediaDefaultsPanel.this.barginCombo.select(0);
                    }
                }
            });
        }
        return settingsComposite;
    }

    public String getTitle() {
        return "Play Prompt";
    }

    public void save() {
        if (this.settings.inheritanceSupported()) {
            for (DefaultValueStack dvs : this.valueStacks) {
                dvs.save();
            }
        } else {
            this.settings.getDefaultSetting(interactionType, elementType, "barge-in").setValue(this.barginCombo.getItem(this.barginCombo.getSelectionIndex()));
        }
    }

    public void setDefaultSettings(IMediaDefaultSettings defaultSettings) {
        this.settings = defaultSettings;
        if (this.settings.inheritanceSupported()) {
            for (DefaultValueStack dvs : this.valueStacks) {
                dvs.setSetting(this.settings);
            }
        } else if (this.barginCombo != null) {
            String bargein = this.settings.getDefaultSetting(interactionType, elementType, "barge-in").getValue();
            if (bargein == null) {
                this.barginCombo.select(0);
            } else if ("true".equals(bargein)) {
                this.barginCombo.select(0);
            } else if ("false".equals(bargein)) {
                this.barginCombo.select(1);
            } else {
                this.barginCombo.select(0);
            }
        }
    }

    public Composite createWrapperComposite(Composite parent) {
        return this.createWrapperComposite(parent, 20);
    }

    public Composite createWrapperComposite(Composite parent, int indent) {
        Composite containerComp = new Composite(parent, 0);
        containerComp.setBackground(parent.getBackground());
        GridData gridData = new GridData(802);
        gridData.horizontalIndent = indent;
        gridData.widthHint = 150;
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        containerComp.setLayout((Layout)gl);
        containerComp.setLayoutData((Object)gridData);
        return containerComp;
    }

    public Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 30;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public RowDivider createRjowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 50;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    private Combo createValueDropDown(Composite parent) {
        Combo ret = new Combo(parent, 2060);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 2048);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Slider createValueSlider(Composite parent, int min, int max, String leftName, String rightName) {
        Composite sliderComp = new Composite(parent, 0);
        sliderComp.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        sliderComp.setLayoutData((Object)gd);
        sliderComp.setLayout((Layout)new FormLayout());
        Label leftLabel = new Label(sliderComp, 0);
        leftLabel.setBackground(sliderComp.getBackground());
        leftLabel.setText(leftName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        leftLabel.setLayoutData((Object)fd);
        Label rightLabel = new Label(sliderComp, 0);
        rightLabel.setBackground(sliderComp.getBackground());
        rightLabel.setText(rightName);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        rightLabel.setLayoutData((Object)fd);
        Slider ret = new Slider(sliderComp, 256);
        ret.setMinimum(min);
        ret.setMaximum(max);
        fd = new FormData();
        fd.left = new FormAttachment((Control)leftLabel, 0, 16384);
        fd.right = new FormAttachment((Control)rightLabel, 0, 131072);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)leftLabel, -3);
        fd.width = 150;
        ret.setLayoutData((Object)fd);
        return ret;
    }

    public class RowDivider
    extends Canvas
    implements PaintListener {
        public RowDivider(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.drawLine(30, 1, size.x - 30, 1);
        }
    }
}

