/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.voice.mediascreens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.media.core.ContentPlaceholder;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreenContainer;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewer;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewerListener;
import org.eclipse.vtp.desktop.media.core.ValueControl;
import org.eclipse.vtp.desktop.media.core.ValueStack;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BrandBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.GenericBindingManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.InteractionBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.LanguageBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.NamedBinding;

public class PlayPromptMediaScreen
extends MediaConfigurationScreen
implements PromptBindingViewerListener {
    private static final String elementType = "org.eclipse.vtp.modules.interactive.playPrompt";
    PromptBindingViewer promptViewer;
    private FormToolkit toolkit;
    GenericBindingManager bindingManager;
    Combo barginCombo = null;
    Composite comp = null;
    ScrolledComposite sc = null;
    NamedBinding promptBinding = null;
    NamedBinding bargeinBinding = null;
    IBrand currentBrand = null;
    String currentLanguage = null;
    Map<String, ValueStack> valueStacks = new HashMap<String, ValueStack>();

    public PlayPromptMediaScreen(MediaConfigurationScreenContainer container) {
        super(container);
        this.bindingManager = (GenericBindingManager)this.getElement().getConfigurationManager("org.eclipse.vtp.configuration.generic");
        this.bindingManager.dumpContents(System.err);
        InteractionBinding interactionBinding = this.bindingManager.getInteractionBinding(this.getInteractionType());
        this.promptBinding = interactionBinding.getNamedBinding("Prompt");
        this.bargeinBinding = interactionBinding.getNamedBinding("barge-in");
        this.promptViewer = new PromptBindingViewer(this.getElement(), this.promptBinding, this.getInteractionType(), this.getElement().getDesign().getVariablesFor(this.getElement()));
    }

    public void save() {
        for (ValueStack dvs : this.valueStacks.values()) {
            dvs.save();
        }
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void createControls(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.sc = new ScrolledComposite(parent, 512);
        this.comp = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)this.comp);
        this.comp.setBackground(parent.getBackground());
        this.comp.setLayout((Layout)new GridLayout(2, false));
        Section contentSection = this.toolkit.createSection(this.comp, 256);
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        contentSection.setLayoutData((Object)gridData);
        contentSection.setText("Media");
        Label promptLabel = this.createPropertyLabel(this.comp, "Prompt:");
        Composite containerComp = this.createWrapperComposite(this.comp, 100);
        this.promptViewer.createControls(containerComp);
        ArrayList<ContentPlaceholder> placeholders = new ArrayList<ContentPlaceholder>();
        placeholders.add(new ContentPlaceholder("Test Placeholder", "This is the description kds jflj sfkl jlskfj lfkj sdlkfjsldkjf lksdj lfkjls"));
        this.promptViewer.setPlaceholders(placeholders);
        this.promptViewer.addListener((PromptBindingViewerListener)this);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.promptViewer.getControl().setLayoutData((Object)gridData);
        Composite spacerComp = new Composite(this.comp, 0);
        spacerComp.setBackground(this.comp.getBackground());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 15;
        spacerComp.setLayoutData((Object)gridData);
        Section settingsSection = this.toolkit.createSection(this.comp, 256);
        gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        settingsSection.setLayoutData((Object)gridData);
        settingsSection.setText("Settings");
        Label bargeLabel = this.createPropertyLabel(this.comp, "Barge-in Enabled");
        bargeLabel.setToolTipText("Determines whether the caller can\r\ninterrupt the prompt to begin entry");
        containerComp = this.createWrapperComposite(this.comp);
        ValueStack lastStack = new ValueStack("barge-in", this.getInteractionType(), elementType, "true", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("barge-in", lastStack);
        this.barginCombo = this.createValueDropDown(containerComp);
        this.barginCombo.add("true");
        this.barginCombo.add("false");
        this.barginCombo.select(0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return PlayPromptMediaScreen.this.barginCombo.getItem(PlayPromptMediaScreen.this.barginCombo.getSelectionIndex());
            }

            public void setValue(String value) {
                if (value == null) {
                    PlayPromptMediaScreen.this.barginCombo.select(0);
                } else if ("true".equals(value)) {
                    PlayPromptMediaScreen.this.barginCombo.select(0);
                } else if ("false".equals(value)) {
                    PlayPromptMediaScreen.this.barginCombo.select(1);
                } else {
                    PlayPromptMediaScreen.this.barginCombo.select(0);
                }
            }
        });
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setMinSize(this.comp.computeSize(-1, -1));
        this.setControl((Control)this.sc);
    }

    public String getInteractionType() {
        return "org.eclipse.vtp.framework.interactions.voice.interaction";
    }

    public void setBrand(IBrand brand) {
        this.currentBrand = brand;
        if (this.promptViewer != null) {
            this.promptViewer.setCurrentBrand(brand);
        }
        LanguageBinding languageBinding = this.bargeinBinding.getLanguageBinding("");
        BrandBinding brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        this.valueStacks.get(this.bargeinBinding.getName()).setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
    }

    public void setLanguage(String language) {
        this.currentLanguage = language;
        if (this.promptViewer != null) {
            this.promptViewer.setCurrentLanguage(language);
        }
    }

    public Composite createWrapperComposite(Composite parent) {
        return this.createWrapperComposite(parent, 20);
    }

    public Composite createWrapperComposite(Composite parent, int indent) {
        Composite containerComp = new Composite(parent, 0);
        containerComp.setBackground(parent.getBackground());
        GridData gridData = new GridData(802);
        gridData.horizontalIndent = indent;
        gridData.widthHint = 150;
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        containerComp.setLayout((Layout)gl);
        containerComp.setLayoutData((Object)gridData);
        return containerComp;
    }

    public Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 30;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public RowDivider createRowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 50;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    private Combo createValueDropDown(Composite parent) {
        Combo ret = new Combo(parent, 2060);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 2048);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public void valueChanged(PromptBindingViewer viewer) {
        Point preferred = this.comp.computeSize(this.sc.getMinWidth(), -1, true);
        this.sc.setMinSize(preferred);
        this.comp.layout();
        if (preferred.y > this.sc.getClientArea().height) {
            preferred = this.comp.computeSize(this.sc.getClientArea().width, -1, true);
            this.sc.setMinSize(preferred);
            this.comp.layout();
        }
    }

    public void invalidConfigurationAttempt(PromptBindingViewer viewer) {
        this.getContainer().cancelMediaConfiguration();
    }

    public class RowDivider
    extends Canvas
    implements PaintListener {
        public RowDivider(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.drawLine(30, 1, size.x - 30, 1);
        }
    }
}

