/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.voice.mediascreens;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.media.core.GrammarBindingViewer;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreenContainer;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewer;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewerListener;
import org.eclipse.vtp.desktop.media.core.ValueControl;
import org.eclipse.vtp.desktop.media.core.ValueStack;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.BrandBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.GenericBindingManager;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.InteractionBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.LanguageBinding;
import org.eclipse.vtp.desktop.model.interactive.core.configuration.generic.NamedBinding;

public class RecordMediaScreen
extends MediaConfigurationScreen
implements PromptBindingViewerListener {
    private static final String elementType = "org.eclipse.vtp.modules.interactive.record";
    PromptBindingViewer promptViewer;
    GrammarBindingViewer grammarViewer;
    private FormToolkit toolkit;
    GenericBindingManager bindingManager;
    InteractionBinding interactionBinding = null;
    Map<String, ValueStack> valueStacks = new HashMap<String, ValueStack>();
    Composite comp = null;
    ScrolledComposite sc = null;
    IBrand currentBrand = null;
    String currentLanguage = null;

    public RecordMediaScreen(MediaConfigurationScreenContainer container) {
        super(container);
        IDesignElement element = this.getElement();
        this.bindingManager = (GenericBindingManager)element.getConfigurationManager("org.eclipse.vtp.configuration.generic");
        this.interactionBinding = this.bindingManager.getInteractionBinding(this.getInteractionType());
        NamedBinding promptBinding = this.interactionBinding.getNamedBinding("Prompt");
        this.promptViewer = new PromptBindingViewer(element, promptBinding, this.getInteractionType(), this.getElement().getDesign().getVariablesFor(element));
        NamedBinding grammarBinding = this.interactionBinding.getNamedBinding("Grammar");
        this.grammarViewer = new GrammarBindingViewer(element, grammarBinding, this.getInteractionType());
    }

    public void save() {
        for (ValueStack dvs : this.valueStacks.values()) {
            dvs.save();
        }
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void createControls(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.getVerticalBar().setIncrement(30);
        this.sc.getVerticalBar().setPageIncrement(275);
        this.comp = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)this.comp);
        this.comp.setBackground(parent.getBackground());
        this.comp.setLayout((Layout)new GridLayout(1, false));
        Composite mediaComposite = new Composite(this.comp, 0);
        mediaComposite.setBackground(this.comp.getBackground());
        mediaComposite.setLayoutData((Object)new GridData(768));
        mediaComposite.setLayout((Layout)new GridLayout(2, false));
        Section contentSection = this.toolkit.createSection(mediaComposite, 256);
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        contentSection.setLayoutData((Object)gridData);
        contentSection.setText("Media");
        Label promptLabel = this.createPropertyLabel(mediaComposite, "Prompt:");
        Composite containerComp = this.createWrapperComposite(mediaComposite, 100);
        this.promptViewer.createControls(containerComp);
        this.promptViewer.addListener((PromptBindingViewerListener)this);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.promptViewer.getControl().setLayoutData((Object)gridData);
        Label grammarLabel = this.createPropertyLabel(mediaComposite, "Grammar:");
        Composite grammarComp = this.createWrapperComposite(mediaComposite, 100);
        this.grammarViewer.createControls(grammarComp);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.grammarViewer.getControl().setLayoutData((Object)gridData);
        Composite spacerComp = new Composite(mediaComposite, 0);
        spacerComp.setBackground(mediaComposite.getBackground());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 15;
        spacerComp.setLayoutData((Object)gridData);
        Composite settingsComposite = new Composite(this.comp, 0);
        settingsComposite.setBackground(this.comp.getBackground());
        settingsComposite.setLayoutData((Object)new GridData(768));
        settingsComposite.setLayout((Layout)new GridLayout(2, false));
        Section settingsSection = this.toolkit.createSection(settingsComposite, 256);
        gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        settingsSection.setLayoutData((Object)gridData);
        settingsSection.setText("Settings");
        Label bargeLabel = this.createPropertyLabel(settingsComposite, "Barge-in Enabled");
        bargeLabel.setToolTipText("Determines whether the caller can\r\ninterrupt the prompt to begin entry.");
        containerComp = this.createWrapperComposite(settingsComposite);
        ValueStack lastStack = new ValueStack("barge-in", this.getInteractionType(), elementType, "true", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("barge-in", lastStack);
        final Combo barginCombo = this.createValueDropDown(containerComp);
        barginCombo.add("true");
        barginCombo.add("false");
        barginCombo.select(0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return barginCombo.getItem(barginCombo.getSelectionIndex());
            }

            public void setValue(String value) {
                if (value == null) {
                    barginCombo.select(0);
                } else if ("true".equals(value)) {
                    barginCombo.select(0);
                } else if ("false".equals(value)) {
                    barginCombo.select(1);
                } else {
                    barginCombo.select(0);
                }
            }
        });
        Label beepLabel = this.createPropertyLabel(settingsComposite, "Play Beep?");
        beepLabel.setToolTipText("Tells the voice platform whether to\r\nplay a beep before recording.");
        containerComp = this.createWrapperComposite(settingsComposite);
        lastStack = new ValueStack("play-beep", this.getInteractionType(), elementType, "true", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("play-beep", lastStack);
        final Combo beepCombo = this.createValueDropDown(containerComp);
        beepCombo.add("true");
        beepCombo.add("false");
        beepCombo.select(0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return beepCombo.getItem(beepCombo.getSelectionIndex());
            }

            public void setValue(String value) {
                if (value == null) {
                    beepCombo.select(0);
                } else if ("true".equals(value)) {
                    beepCombo.select(0);
                } else if ("false".equals(value)) {
                    beepCombo.select(1);
                } else {
                    beepCombo.select(0);
                }
            }
        });
        Label terminationCharacterLabel = this.createPropertyLabel(settingsComposite, "Allow DTMF Termination?");
        terminationCharacterLabel.setToolTipText("Determines whether recording is ended\r\nby DTMF input.");
        containerComp = this.createWrapperComposite(settingsComposite);
        lastStack = new ValueStack("dtmf-termination", this.getInteractionType(), elementType, "true", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("dtmf-termination", lastStack);
        final Combo terminationCharacterCombo = this.createValueDropDown(containerComp);
        terminationCharacterCombo.add("true");
        terminationCharacterCombo.add("false");
        terminationCharacterCombo.select(0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return terminationCharacterCombo.getItem(terminationCharacterCombo.getSelectionIndex());
            }

            public void setValue(String value) {
                if (value == null) {
                    terminationCharacterCombo.select(0);
                } else if ("true".equals(value)) {
                    terminationCharacterCombo.select(0);
                } else if ("false".equals(value)) {
                    terminationCharacterCombo.select(1);
                } else {
                    terminationCharacterCombo.select(0);
                }
            }
        });
        Label initialTimeoutLabel = this.createPropertyLabel(settingsComposite, "Initial Input Timeout (Seconds)");
        initialTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor the caller to begin input before\r\na NoInput event.");
        containerComp = this.createWrapperComposite(settingsComposite);
        lastStack = new ValueStack("initial-timeout", this.getInteractionType(), elementType, "3", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("initial-timeout", lastStack);
        final Spinner initialTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(initialTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                initialTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label terminationTimeoutLabel = this.createPropertyLabel(settingsComposite, "Termination Timeout (Seconds)");
        terminationTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input after a selection\r\nhas been matched.");
        containerComp = this.createWrapperComposite(settingsComposite);
        lastStack = new ValueStack("final-silence-timeout", this.getInteractionType(), elementType, "1", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("final-silence-timeout", lastStack);
        final Spinner terminationTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(terminationTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                terminationTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        Label maxSpeechTimeoutLabel = this.createPropertyLabel(settingsComposite, "Maximum Recording Time (Seconds)");
        maxSpeechTimeoutLabel.setToolTipText("The maximum length of speech input\r\nin seconds that will be accepted.");
        containerComp = this.createWrapperComposite(settingsComposite);
        lastStack = new ValueStack("max-record-time", this.getInteractionType(), elementType, "300", 0);
        lastStack.createControls(containerComp);
        containerComp = lastStack.getValueComposite();
        this.valueStacks.put("max-record-time", lastStack);
        final Spinner maxSpeechTimeoutSpinner = this.createValueSpinner(containerComp, 10, 1740, 0, 0);
        lastStack.setValueControl(new ValueControl(){

            public String getValue() {
                return Integer.toString(maxSpeechTimeoutSpinner.getSelection());
            }

            public void setValue(String value) {
                maxSpeechTimeoutSpinner.setSelection(Integer.parseInt(value));
            }
        });
        this.comp.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                RecordMediaScreen.this.comp.removeControlListener((ControlListener)this);
                RecordMediaScreen.this.sc.setAlwaysShowScrollBars(true);
                Rectangle clientArea = RecordMediaScreen.this.sc.getClientArea();
                RecordMediaScreen.this.sc.setAlwaysShowScrollBars(false);
                if (RecordMediaScreen.this.sc.getVerticalBar() != null) {
                    RecordMediaScreen.this.sc.getVerticalBar().setVisible(false);
                }
                RecordMediaScreen.this.sc.setMinSize(new Point(clientArea.width, clientArea.height));
                RecordMediaScreen.this.sc.layout(true, true);
                RecordMediaScreen.this.sc.redraw();
            }
        });
        this.sc.setMinWidth(this.comp.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.sc.setMinHeight(this.comp.computeSize((int)-1, (int)-1, (boolean)true).y);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.setControl((Control)this.sc);
    }

    public String getInteractionType() {
        return "org.eclipse.vtp.framework.interactions.voice.interaction";
    }

    public void setLanguage(String language) {
        this.currentLanguage = language;
        if (this.promptViewer != null) {
            this.promptViewer.setCurrentLanguage(language);
            this.grammarViewer.setCurrentLanguage(language);
        }
    }

    public void setBrand(IBrand brand) {
        this.currentBrand = brand;
        if (this.promptViewer != null) {
            this.promptViewer.setCurrentBrand(brand);
            this.grammarViewer.setCurrentBrand(brand);
        }
        NamedBinding namedBinding = this.interactionBinding.getNamedBinding("barge-in");
        LanguageBinding languageBinding = namedBinding.getLanguageBinding("");
        BrandBinding brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        ValueStack valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("play-beep");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("initial-timeout");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("final-silence-timeout");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("dtmf-termination");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
        namedBinding = this.interactionBinding.getNamedBinding("max-record-time");
        languageBinding = namedBinding.getLanguageBinding("");
        brandBinding = languageBinding.getBrandBinding(this.currentBrand);
        valueStack = this.valueStacks.get(namedBinding.getName());
        valueStack.setSetting(this.bindingManager.getMediaDefaults(), brandBinding);
    }

    public Composite createWrapperComposite(Composite parent) {
        return this.createWrapperComposite(parent, 20);
    }

    public Composite createWrapperComposite(Composite parent, int indent) {
        Composite containerComp = new Composite(parent, 0);
        containerComp.setBackground(parent.getBackground());
        GridData gridData = new GridData(802);
        gridData.horizontalIndent = indent;
        gridData.widthHint = 150;
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        containerComp.setLayout((Layout)gl);
        containerComp.setLayoutData((Object)gridData);
        return containerComp;
    }

    public Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 30;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public RowDivider createRowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 50;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    private Combo createValueDropDown(Composite parent) {
        Combo ret = new Combo(parent, 2060);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 0);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Slider createValueSlider(Composite parent, int min, int max, String leftName, String rightName) {
        Composite sliderComp = new Composite(parent, 0);
        sliderComp.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        sliderComp.setLayoutData((Object)gd);
        sliderComp.setLayout((Layout)new FormLayout());
        Label leftLabel = new Label(sliderComp, 0);
        leftLabel.setBackground(sliderComp.getBackground());
        leftLabel.setText(leftName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        leftLabel.setLayoutData((Object)fd);
        Label rightLabel = new Label(sliderComp, 0);
        rightLabel.setBackground(sliderComp.getBackground());
        rightLabel.setText(rightName);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        rightLabel.setLayoutData((Object)fd);
        Slider ret = new Slider(sliderComp, 256);
        ret.setMinimum(min);
        ret.setMaximum(max);
        fd = new FormData();
        fd.left = new FormAttachment((Control)leftLabel, 0, 16384);
        fd.right = new FormAttachment((Control)rightLabel, 0, 131072);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)leftLabel, -3);
        fd.width = 150;
        ret.setLayoutData((Object)fd);
        return ret;
    }

    public void valueChanged(PromptBindingViewer viewer) {
        Point preferred = this.comp.computeSize(this.sc.getMinWidth(), -1, true);
        this.sc.setMinSize(preferred);
        this.comp.layout();
        if (preferred.y > this.sc.getClientArea().height) {
            preferred = this.comp.computeSize(this.sc.getClientArea().width, -1, true);
            this.sc.setMinSize(preferred);
            this.comp.layout();
        }
    }

    public void invalidConfigurationAttempt(PromptBindingViewer viewer) {
        this.getContainer().cancelMediaConfiguration();
    }

    public class RowDivider
    extends Canvas
    implements PaintListener {
        public RowDivider(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.drawLine(30, 1, size.x - 30, 1);
        }
    }
}

