/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.vtp.desktop.model.core.IWorkflowModel;
import org.eclipse.vtp.desktop.model.core.event.ObjectRefreshEvent;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowModel;
import org.eclipse.vtp.desktop.model.core.internal.event.ObjectEvent;
import org.eclipse.vtp.desktop.model.core.internal.event.ObjectListener;
import org.osgi.framework.BundleContext;

public class WorkflowCore
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.vtp.desktop.model.core";
    private static WorkflowCore plugin;
    private Map<String, List<WeakReference<ObjectListener>>> objectListeners = new HashMap<String, List<WeakReference<ObjectListener>>>();
    private Map<String, Object> deferredObjects = new HashMap<String, Object>();
    private List<ObjectEvent> eventBuffer = new LinkedList<ObjectEvent>();
    private boolean running = true;
    private IWorkflowModel model = null;

    public WorkflowCore() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (WorkflowCore.this.running) {
                    List list = WorkflowCore.this.eventBuffer;
                    synchronized (list) {
                        if (!WorkflowCore.this.eventBuffer.isEmpty()) {
                            List ls;
                            ObjectEvent oe = (ObjectEvent)WorkflowCore.this.eventBuffer.remove(0);
                            if (WorkflowCore.this.deferredObjects.get(oe.getObjectId()) == null && (ls = (List)WorkflowCore.this.objectListeners.get(oe.getObjectId())) != null) {
                                Iterator i = ls.iterator();
                                while (i.hasNext()) {
                                    WeakReference ref = (WeakReference)i.next();
                                    if (ref.get() == null) {
                                        i.remove();
                                        continue;
                                    }
                                    ((ObjectListener)ref.get()).processObjectEvent(oe);
                                }
                            }
                        } else {
                            try {
                                WorkflowCore.this.eventBuffer.wait();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }).start();
        this.model = new WorkflowModel();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.running = false;
        super.stop(context);
    }

    public static WorkflowCore getDefault() {
        return plugin;
    }

    public IWorkflowModel getWorkflowModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObjectListener(String objectId, ObjectListener l) {
        List<ObjectEvent> list = this.eventBuffer;
        synchronized (list) {
            List<WeakReference<ObjectListener>> ls = this.objectListeners.get(objectId);
            if (ls == null) {
                ls = new ArrayList<WeakReference<ObjectListener>>();
                this.objectListeners.put(objectId, ls);
            }
            Iterator<WeakReference<ObjectListener>> i = ls.iterator();
            while (i.hasNext()) {
                WeakReference<ObjectListener> ref = i.next();
                if (ref.get() == null) {
                    i.remove();
                    continue;
                }
                if (ref.get() != l) continue;
                i.remove();
            }
            ls.add(new WeakReference<ObjectListener>(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObjectListener(String objectId, ObjectListener l) {
        List<ObjectEvent> list = this.eventBuffer;
        synchronized (list) {
            List<WeakReference<ObjectListener>> ls = this.objectListeners.get(objectId);
            if (ls == null) {
                ls = new ArrayList<WeakReference<ObjectListener>>();
                this.objectListeners.put(objectId, ls);
            }
            Iterator<WeakReference<ObjectListener>> i = ls.iterator();
            while (i.hasNext()) {
                WeakReference<ObjectListener> ref = i.next();
                if (ref.get() == null) {
                    i.remove();
                    continue;
                }
                if (ref.get() != l) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postObjectEvent(ObjectEvent event) {
        List<ObjectEvent> list = this.eventBuffer;
        synchronized (list) {
            this.eventBuffer.add(event);
            this.eventBuffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferEvents(String objectId) {
        List<ObjectEvent> list = this.eventBuffer;
        synchronized (list) {
            this.deferredObjects.put(objectId, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeEvents(String objectId) {
        List<ObjectEvent> list = this.eventBuffer;
        synchronized (list) {
            this.deferredObjects.remove(objectId);
            this.postObjectEvent(new ObjectRefreshEvent(objectId));
        }
    }

    public String getTemplate(String name) {
        try {
            InputStream templateIn = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(name);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[10240];
            int len = templateIn.read(buf);
            while (len != -1) {
                baos.write(buf, 0, len);
                len = templateIn.read(buf);
            }
            templateIn.close();
            return baos.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

