/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.builders;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.vtp.desktop.model.core.IDesignDocument;
import org.eclipse.vtp.desktop.model.core.IDesignItemContainer;
import org.eclipse.vtp.desktop.model.core.IWebserviceDescriptor;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.IWorkflowReference;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowIndex;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowIndexService;
import org.eclipse.vtp.desktop.model.core.internal.design.Design;
import org.eclipse.vtp.desktop.model.core.schema.SchemaProblem;
import org.eclipse.vtp.desktop.model.core.wsdl.WSDL;
import org.eclipse.vtp.desktop.model.core.wsdl.WSDLProblem;

public class WorkflowProjectBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.vtp.desktop.model.core.WorkflowProjectBuilder";
    private WorkflowIndex index = null;
    private List<IDesignDocument> modifiedByBuilder = new LinkedList<IDesignDocument>();

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        int n;
        boolean isFirstTime;
        this.modifiedByBuilder.clear();
        System.err.println("building: " + this.getProject().getName() + " this: " + (Object)((Object)this));
        boolean bl = isFirstTime = !WorkflowIndexService.getInstance().isIndexed(this.getProject());
        if (!this.getProject().isSynchronized(2)) {
            System.err.println("Resource out of synch with filesystem, refreshing");
            if (!isFirstTime) {
                this.index = WorkflowIndexService.getInstance().getIndex(this.getProject());
                this.index.cleanProject();
            }
            this.getProject().refreshLocal(2, monitor);
            this.needRebuild();
            return this.getProject().getReferencedProjects();
        }
        System.err.println("Unindexed: " + isFirstTime);
        this.index = WorkflowIndexService.getInstance().getIndex(this.getProject());
        this.index.getWriteLock().lock();
        try {
            if (!isFirstTime) {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null && kind != 15) {
                    this.fullBuild(monitor);
                } else {
                    ChangeCounter counter = new ChangeCounter();
                    delta.accept((IResourceDeltaVisitor)counter);
                    System.err.println("delta: " + delta + " changes: " + counter.affected);
                    if (counter.affected > 0) {
                        this.incrementalBuild(delta, monitor);
                    }
                    this.index.indexExportedData();
                }
                if (this.modifiedByBuilder.size() > 0) {
                    this.needRebuild();
                    IProject[] iProjectArray = this.getProject().getReferencedProjects();
                    return iProjectArray;
                }
            }
        }
        finally {
            this.index.getWriteLock().unlock();
        }
        IProjectDescription desc = this.getProject().getDescription();
        IProject[] oldReferences = desc.getDynamicReferences();
        IProject[] allProjects = this.getProject().getWorkspace().getRoot().getProjects();
        LinkedList<IProject> refProjects = new LinkedList<IProject>();
        List<IWorkflowReference> newRefs = this.index.getWorkflowReferences();
        block3: for (IWorkflowReference ref : newRefs) {
            IProject[] iProjectArray = allProjects;
            int n2 = allProjects.length;
            n = 0;
            while (n < n2) {
                IProject p = iProjectArray[n];
                IWorkflowProject wp = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowProject(p);
                if (wp != null && wp.getId().equals(ref.getTargetId())) {
                    if (refProjects.contains(p)) continue block3;
                    refProjects.add(p);
                    continue block3;
                }
                ++n;
            }
        }
        boolean mismatch = false;
        for (IProject ref : refProjects) {
            boolean found = false;
            IProject[] iProjectArray = oldReferences;
            int n3 = oldReferences.length;
            int n4 = 0;
            while (n4 < n3) {
                IProject old = iProjectArray[n4];
                if (ref.equals((Object)old)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (found) continue;
            mismatch = true;
            break;
        }
        if (!mismatch) {
            IProject[] iProjectArray = oldReferences;
            n = oldReferences.length;
            int n5 = 0;
            while (n5 < n) {
                IProject old = iProjectArray[n5];
                if (!refProjects.contains(old)) {
                    mismatch = true;
                    break;
                }
                ++n5;
            }
        }
        if (mismatch) {
            desc.setDynamicReferences(refProjects.toArray(new IProject[refProjects.size()]));
            this.getProject().setDescription(desc, monitor);
        }
        if (!this.index.isValidated()) {
            this.validate(monitor);
        }
        return this.getProject().getReferencedProjects();
    }

    private void validate(IProgressMonitor monitor) {
        try {
            this.getProject().deleteMarkers("org.eclipse.vtp.desktop.model.core.workflowmarker", true, 2);
            this.index.setValidated(true);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        System.err.println("##########doing full build****************************");
        this.index.cleanProject();
        this.index.fullIndex();
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        RemovalDeltaVisitor removalVisitor = new RemovalDeltaVisitor();
        delta.accept((IResourceDeltaVisitor)removalVisitor);
        AddedDeltaVisitor addedVisitor = new AddedDeltaVisitor();
        delta.accept((IResourceDeltaVisitor)addedVisitor);
        ChangedDeltaVisitor changedVisitor = new ChangedDeltaVisitor();
        delta.accept((IResourceDeltaVisitor)changedVisitor);
        if (this.modifiedByBuilder.size() > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (IDesignDocument document : WorkflowProjectBuilder.this.modifiedByBuilder) {
                        try {
                            document.commitWorkingCopy();
                        }
                        catch (Exception ex) {
                            Status status = new Status(4, "org.eclipse.vtp.desktop.model.core", 0, "Error during build: updating a copied or moved document. " + document.getUnderlyingFile().getFullPath(), (Throwable)ex);
                            WorkflowCore.getDefault().getLog().log((IStatus)status);
                        }
                    }
                }
            });
        }
    }

    private class AddedDeltaVisitor
    implements IResourceDeltaVisitor {
        private AddedDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (delta.getKind() == 1) {
                System.out.println("Added Vistor: " + resource);
                System.out.println(delta);
                IWorkflowResource workflowResource = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource(resource);
                if (workflowResource instanceof IDesignDocument) {
                    IDesignDocument designDocument = (IDesignDocument)workflowResource;
                    if (delta.getFlags() != 4096) {
                        System.out.println("not a move operation");
                        designDocument.becomeWorkingCopy();
                        List<IDesignElement> mainElements = designDocument.getMainDesign().getDesignElements();
                        for (IDesignElement element : mainElements) {
                            if (!WorkflowProjectBuilder.this.index.elementExists(designDocument, element.getId())) continue;
                            System.out.println("duplicate id detected");
                            ((Design)designDocument.getMainDesign()).forceNewIds();
                            WorkflowProjectBuilder.this.modifiedByBuilder.add(designDocument);
                        }
                        designDocument.discardWorkingCopy();
                    }
                    WorkflowProjectBuilder.this.index.clean(designDocument);
                    WorkflowProjectBuilder.this.index.indexStructure(designDocument);
                } else if (workflowResource instanceof IWebserviceDescriptor) {
                    IWebserviceDescriptor descriptor = (IWebserviceDescriptor)workflowResource;
                    resource.deleteMarkers("org.eclipse.vtp.desktop.model.core.workflowmarker", true, 2);
                    try {
                        IMarker marker;
                        WSDL wsdl = descriptor.getWSDL();
                        List<SchemaProblem> schemaProblems = wsdl.getSchemaProblems();
                        List<WSDLProblem> wsdlProblems = wsdl.getWSDLProblems();
                        for (SchemaProblem schemaProblem : schemaProblems) {
                            marker = resource.createMarker("org.eclipse.vtp.desktop.model.core.workflowmarker");
                            marker.setAttributes(new String[]{"message", "lineNumber", "location", "severity"}, new Object[]{schemaProblem.getMessage(), schemaProblem.getLineNumber(), "Line " + schemaProblem.getLineNumber(), 2});
                        }
                        for (WSDLProblem wSDLProblem : wsdlProblems) {
                            marker = resource.createMarker("org.eclipse.vtp.desktop.model.core.workflowmarker");
                            marker.setAttributes(new String[]{"message", "lineNumber", "location", "severity"}, new Object[]{wSDLProblem.getMessage(), wSDLProblem.getLineNumber(), "Line " + wSDLProblem.getLineNumber(), 2});
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
    }

    private class ChangeCounter
    implements IResourceDeltaVisitor {
        int affected = 0;

        private ChangeCounter() {
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                return true;
            }
            IWorkflowResource workflowResource = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource(resource);
            if (workflowResource instanceof IDesignItemContainer) {
                return true;
            }
            if (workflowResource instanceof IDesignDocument) {
                ++this.affected;
            }
            return false;
        }
    }

    private class ChangedDeltaVisitor
    implements IResourceDeltaVisitor {
        private ChangedDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource instanceof IFile && delta.getKind() == 4) {
                IWorkflowResource workflowResource = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource(resource);
                if (workflowResource instanceof IDesignDocument) {
                    System.out.println("Changed Vistor: " + resource);
                    System.out.println(delta);
                    IDesignDocument designDocument = (IDesignDocument)workflowResource;
                    WorkflowProjectBuilder.this.index.clean(designDocument);
                    WorkflowProjectBuilder.this.index.indexStructure(designDocument);
                } else if (workflowResource instanceof IWebserviceDescriptor) {
                    IWebserviceDescriptor descriptor = (IWebserviceDescriptor)workflowResource;
                    resource.deleteMarkers("org.eclipse.vtp.desktop.model.core.workflowmarker", true, 2);
                    try {
                        IMarker marker;
                        WSDL wsdl = descriptor.getWSDL();
                        List<SchemaProblem> schemaProblems = wsdl.getSchemaProblems();
                        List<WSDLProblem> wsdlProblems = wsdl.getWSDLProblems();
                        for (SchemaProblem schemaProblem : schemaProblems) {
                            marker = resource.createMarker("org.eclipse.vtp.desktop.model.core.workflowmarker");
                            marker.setAttributes(new String[]{"message", "lineNumber", "location", "severity"}, new Object[]{schemaProblem.getMessage(), schemaProblem.getLineNumber(), "Line " + schemaProblem.getLineNumber(), 2});
                        }
                        for (WSDLProblem wSDLProblem : wsdlProblems) {
                            marker = resource.createMarker("org.eclipse.vtp.desktop.model.core.workflowmarker");
                            marker.setAttributes(new String[]{"message", "lineNumber", "location", "severity"}, new Object[]{wSDLProblem.getMessage(), wSDLProblem.getLineNumber(), "Line " + wSDLProblem.getLineNumber(), 2});
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
    }

    private class RemovalDeltaVisitor
    implements IResourceDeltaVisitor {
        private RemovalDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource instanceof IFile && delta.getKind() == 2) {
                System.out.println("Removal Vistor: " + resource);
                System.out.println(delta);
                WorkflowProjectBuilder.this.index.remove(resource.getProjectRelativePath().toString());
                return false;
            }
            return true;
        }
    }
}

