/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationContext;
import org.osgi.framework.Bundle;

public class ConfigurationContextRegistry {
    public static final String configurationManagerExtensionId = "org.eclipse.vtp.desktop.model.core.configurationContexts";
    private static final ConfigurationContextRegistry instance = new ConfigurationContextRegistry();
    private List<ContextRecord> managerRecords = new ArrayList<ContextRecord>();

    public static ConfigurationContextRegistry getInstance() {
        return instance;
    }

    public ConfigurationContextRegistry() {
        ContextRecord cmr;
        Bundle contributor;
        String className;
        HashMap<String, ContextRecord> recordsById = new HashMap<String, ContextRecord>();
        IConfigurationElement[] managerExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(configurationManagerExtensionId);
        int i = 0;
        while (i < managerExtensions.length) {
            if (managerExtensions[i].getName().equals("context")) {
                String managerId = managerExtensions[i].getAttribute("id");
                className = managerExtensions[i].getAttribute("class");
                contributor = Platform.getBundle((String)managerExtensions[i].getContributor().getName());
                try {
                    Class managerClass = contributor.loadClass(className);
                    cmr = new ContextRecord(managerId, managerClass);
                    this.managerRecords.add(cmr);
                    recordsById.put(managerId, cmr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        i = 0;
        while (i < managerExtensions.length) {
            if (managerExtensions[i].getName().equals("context-binding")) {
                String contextId = managerExtensions[i].getAttribute("context-id");
                className = managerExtensions[i].getAttribute("filter-class");
                contributor = Platform.getBundle((String)managerExtensions[i].getContributor().getName());
                try {
                    Class filterClass = contributor.loadClass(className);
                    cmr = (ContextRecord)recordsById.get(contextId);
                    if (cmr != null) {
                        cmr.addFilter(filterClass);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public List<ConfigurationContext> getConfigurationContextsFor(IWorkflowProject project) {
        ArrayList<ConfigurationContext> ret = new ArrayList<ConfigurationContext>();
        for (ContextRecord cr : this.managerRecords) {
            if (!cr.isApplicableTo(project)) continue;
            ConfigurationContext context = cr.getManagerInstance();
            context.setProject(project);
            ret.add(context);
        }
        return ret;
    }

    private class ContextRecord {
        private String contextId;
        private Class<ConfigurationContext> managerClass;
        private List<Class> adaptableFilters = new ArrayList<Class>();

        public ContextRecord(String managerId, Class<ConfigurationContext> managerClass) throws Exception {
            this.contextId = managerId;
            this.managerClass = managerClass;
        }

        public void addFilter(Class filter) {
            this.adaptableFilters.add(filter);
        }

        public boolean isApplicableTo(IWorkflowProject project) {
            for (Class c : this.adaptableFilters) {
                if (project.getAdapter(c) == null) continue;
                return true;
            }
            return false;
        }

        public ConfigurationContext getManagerInstance() {
            try {
                return this.managerClass.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

