/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.design;

import org.eclipse.vtp.desktop.model.core.design.IDesignConnector;
import org.eclipse.vtp.desktop.model.core.design.IDesignElement;

public interface IDesignElementConnectionPoint
extends Comparable {
    public IDesignElement getSourceElement();

    public String getName();

    public ConnectionPointType getType();

    public IDesignConnector getDesignConnector();

    public static enum ConnectionPointType {
        HOOK_POINT(1),
        EXIT_POINT(2),
        ERROR_POINT(4);

        private int bits;

        private ConnectionPointType(int bits) {
            this.bits = bits;
        }

        public boolean isSet(int flagSet) {
            return (flagSet & this.bits) == this.bits;
        }

        public static int getFlagSet(ConnectionPointType ... types) {
            int flagSet = 0;
            ConnectionPointType[] connectionPointTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionPointType type = connectionPointTypeArray[n2];
                flagSet |= type.bits;
                ++n2;
            }
            return flagSet;
        }
    }
}

