/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.design;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.design.ObjectField;

public class ObjectDefinition
implements PropertyChangeListener {
    public static final String PROP_NAME = "name";
    public static final String PROP_TYPE = "type";
    public static final String PROP_FIELDS = "fields";
    String name;
    FieldType type;
    List<ObjectField> fields;
    String defaultValue;
    boolean secure = false;
    List<PropertyChangeListener> listeners = new LinkedList<PropertyChangeListener>();

    public ObjectDefinition(String name, FieldType type) {
        this.name = name;
        this.type = type;
        this.fields = new ArrayList<ObjectField>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.postChange(PROP_NAME, oldName, name);
    }

    public FieldType getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        FieldType oldType = this.type;
        this.type = type;
        this.fields = new ArrayList<ObjectField>();
        this.postChange(PROP_TYPE, oldType, type);
    }

    public List<ObjectField> getFields() {
        return this.fields;
    }

    public String getPath() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectDefinition) {
            ObjectDefinition od = (ObjectDefinition)obj;
            return od.getPath().equals(this.getPath());
        }
        return false;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public ObjectField addField(ObjectField field) {
        ArrayList<ObjectField> oldFields = new ArrayList<ObjectField>(this.fields);
        boolean inserted = false;
        int i = 0;
        while (i < this.fields.size()) {
            if (this.fields.get(i).getName().compareToIgnoreCase(field.getName()) > 0) {
                this.fields.add(i, field);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            this.fields.add(field);
        }
        field.setParent(this);
        this.postChange(PROP_FIELDS, oldFields, this.fields);
        return field;
    }

    public void clearFields() {
        List<ObjectField> oldFields = this.fields;
        this.fields = new ArrayList<ObjectField>();
        for (ObjectField field : oldFields) {
            field.removePropertyChangeListener(this);
        }
        this.postChange(PROP_FIELDS, oldFields, this.fields);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void postChange(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, property, oldValue, newValue);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (PROP_NAME.equals(evt.getPropertyName())) {
            ArrayList<ObjectField> oldFields = new ArrayList<ObjectField>(this.fields);
            ObjectField field = (ObjectField)evt.getSource();
            int i = 0;
            while (i < this.fields.size()) {
                if (this.fields.get(i).getName().equals(evt.getOldValue())) {
                    this.fields.remove(i);
                    break;
                }
                ++i;
            }
            boolean inserted = false;
            int i2 = 0;
            while (i2 < this.fields.size()) {
                if (this.fields.get(i2).getName().compareToIgnoreCase(field.getName()) > 0) {
                    this.fields.add(i2, field);
                    inserted = true;
                    break;
                }
                ++i2;
            }
            if (!inserted) {
                this.fields.add(field);
            }
            this.postChange(PROP_FIELDS, oldFields, this.fields);
        }
    }
}

