/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.core.FieldType;
import org.eclipse.vtp.desktop.model.core.IBusinessObject;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectField;
import org.eclipse.vtp.desktop.model.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.event.ReloadObjectDataEvent;
import org.eclipse.vtp.desktop.model.core.internal.BusinessObjectField;
import org.eclipse.vtp.desktop.model.core.internal.BusinessObjectSet;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;
import org.eclipse.vtp.desktop.model.core.internal.event.ObjectEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BusinessObject
extends WorkflowResource
implements IBusinessObject {
    private BusinessObjectSet objectSet;
    private IFile file;
    private String id;
    private String name;
    private List<BusinessObjectField> fields;

    public BusinessObject(BusinessObjectSet objectSet, IFile file) {
        this.objectSet = objectSet;
        this.file = file;
        this.activateEvents();
        this.loadHeaders();
    }

    private void loadHeaders() {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.file.getContents());
            Element rootElement = document.getDocumentElement();
            this.id = rootElement.getAttribute("id");
            this.name = rootElement.getAttribute("name");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    void loadModel() {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.file.getContents());
            Element rootElement = document.getDocumentElement();
            this.fields = new ArrayList<BusinessObjectField>();
            System.err.println("Loading object:" + this.name);
            NodeList nl = rootElement.getElementsByTagName("field");
            int i = 0;
            while (i < nl.getLength()) {
                Element fieldElement = (Element)nl.item(i);
                String fieldName = fieldElement.getAttribute("name");
                System.err.println("Loading field: " + fieldName);
                String fieldInitialValue = fieldElement.getAttribute("initialValue");
                NodeList dtnl = fieldElement.getElementsByTagName("data-type");
                if (dtnl.getLength() > 0) {
                    FieldType fieldDataType = FieldType.load(this.objectSet, (Element)dtnl.item(0));
                    BusinessObjectField bof = new BusinessObjectField(this, fieldName, fieldDataType, fieldInitialValue, Boolean.parseBoolean(fieldElement.getAttribute("secured")));
                    this.fields.add(bof);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getObjectId() {
        return this.file.getFullPath().toPortableString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<IBusinessObjectField> getFields() {
        return new ArrayList<IBusinessObjectField>(this.fields);
    }

    @Override
    public IWorkflowResource getParent() {
        return this.objectSet;
    }

    public InputStream read() throws CoreException {
        return this.file.getContents();
    }

    @Override
    public void processObjectEvent(ObjectEvent event) {
        if (event instanceof ReloadObjectDataEvent) {
            this.loadModel();
            this.refresh();
        } else {
            super.processObjectEvent(event);
        }
    }

    public void write(InputStream source) throws CoreException {
        this.file.setContents(source, true, true, null);
        WorkflowCore.getDefault().postObjectEvent(new ReloadObjectDataEvent(this.getObjectId()));
    }

    @Override
    public IBusinessObjectSet getBusinessObjectSet() {
        return this.objectSet;
    }

    @Override
    public void delete() throws CoreException {
        this.file.delete(false, null);
        this.objectSet.refresh();
    }

    @Override
    public IFile getUnderlyingFile() {
        return this.file;
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (IResource.class.isAssignableFrom(adapterClass)) {
            return this.getUnderlyingFile();
        }
        if (BusinessObject.class.isAssignableFrom(adapterClass)) {
            return this;
        }
        return super.getAdapter(adapterClass);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BusinessObject) {
            return this.file.equals((Object)((BusinessObject)obj).getUnderlyingFile());
        }
        return false;
    }

    public int hashCode() {
        return this.file.toString().hashCode();
    }
}

