/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.model.core.IDatabase;
import org.eclipse.vtp.desktop.model.core.IDatabaseTable;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.internal.DatabaseSet;
import org.eclipse.vtp.desktop.model.core.internal.DatabaseTable;
import org.eclipse.vtp.desktop.model.core.internal.WorkflowResource;

public class Database
extends WorkflowResource
implements IDatabase {
    private static final String tableTemplate = "<database-table name=\"[name]\"><columns></columns></database-table>";
    DatabaseSet databaseSet;
    IFolder folder;
    String name;

    public Database(DatabaseSet databaseSet, IFolder folder) {
        this.databaseSet = databaseSet;
        this.folder = folder;
        this.name = folder.getName();
        this.activateEvents();
    }

    @Override
    protected String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<IDatabaseTable> getTables() {
        ArrayList<IDatabaseTable> ret = new ArrayList<IDatabaseTable>();
        try {
            IResource[] res = this.folder.members();
            int i = 0;
            while (i < res.length) {
                IFile file;
                if (res[i] instanceof IFile && (file = (IFile)res[i]).getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("dbt")) {
                    DatabaseTable table = new DatabaseTable(this, file);
                    ret.add(table);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public IWorkflowResource getParent() {
        return this.databaseSet;
    }

    @Override
    public IDatabaseTable createTable(String name) throws CoreException {
        IFile databaseTableFile = this.folder.getFile(String.valueOf(name) + ".dbt");
        if (databaseTableFile.exists()) {
            throw new IllegalArgumentException("A Database table with that name already exists: " + name);
        }
        String template = new String(tableTemplate);
        template = template.replaceAll("\\[name\\]", name);
        databaseTableFile.create((InputStream)new ByteArrayInputStream(template.toString().getBytes()), true, null);
        DatabaseTable database = new DatabaseTable(this, databaseTableFile);
        return database;
    }

    public IFolder getUnderlyingFolder() {
        return this.folder;
    }

    @Override
    public void delete() throws CoreException {
        this.folder.delete(false, null);
        this.databaseSet.refresh();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Database) {
            return this.folder.equals((Object)((Database)obj).getUnderlyingFolder());
        }
        return false;
    }

    public int hashCode() {
        return this.folder.toString().hashCode();
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (IResource.class.isAssignableFrom(adapterClass) && adapterClass.isAssignableFrom(this.folder.getClass())) {
            return this.folder;
        }
        if (Database.class.isAssignableFrom(adapterClass)) {
            return this;
        }
        return super.getAdapter(adapterClass);
    }

    @Override
    public List<IWorkflowResource> getChildren() {
        return new ArrayList<IWorkflowResource>(this.getTables());
    }
}

